package ProdDatabase;
import java.sql.*;
import java.util.*;

public class BarrelUtilities implements SCTDBInfo, barrelMetrologyData {

// *****************************************************************************************************************
    public static Vector getHybridVector(String sn1,String sn2,String locn) throws Exception {
// return a Vector containing bmHASIC serial nos, located at locn, not-assembled, with
// corresponding bmHPCs at the same locn also non-assembled

// convert to bmHASIC
      sn1 = sn1.substring(0,7)+"8"+sn1.substring(8);
      sn2 = sn2.substring(0,7)+"8"+sn2.substring(8);
      Vector itemList = new Vector();
      StringBuffer sqlStat = new StringBuffer("SELECT ");
      sqlStat.append("ser_no,assembled FROM items WHERE ser_no >="+sn1+" AND ser_no <="+sn2+" AND locn_name = '"+locn+"'");
      sqlStat.append(" ORDER BY ser_no");
//      System.out.println(sqlStat.toString());

      SCTDBInterface db = SCTDBInterface.getInstance();
      Statement statement = db.connection.createStatement();
      ResultSet resultSet = statement.executeQuery(sqlStat.toString());
      int recordCount=0;
      Hashtable tempHash = new Hashtable();
      for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
         recordCount++;
         String serno = resultSet.getString(1);
         String aFlag = resultSet.getString(2);
         tempHash.put(serno,"1");
//         if(aFlag.equals("NO")) tempHash.put(serno,"1");
//         else System.out.println("Cannot assemble hybrid "+serno+" - this is already assembled.");
	    }
      statement.close();
      if(recordCount==0) {
           System.out.println("There are "+recordCount+" bmHASICs located at "+locn+" within the requested range.");
           return itemList;
           }
// now check that the bmHPC are there too
      String firstbit = sn1.substring(0,7);
      String lastbit = sn1.substring(8);
      String sn1_2 = firstbit+"7"+lastbit;
      firstbit = sn2.substring(0,7);
      lastbit = sn2.substring(8);
      String sn2_2 = firstbit+"7"+lastbit;

      sqlStat = new StringBuffer("SELECT ser_no,assembled FROM items WHERE ser_no >="+sn1_2+" AND ser_no <="+sn2_2+" AND locn_name = '"+locn+"'");
      sqlStat.append(" ORDER BY ser_no");
//      System.out.println(sqlStat.toString());
      statement = db.connection.createStatement();
      resultSet = statement.executeQuery(sqlStat.toString());
      recordCount=0;
      for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
         recordCount++;
         String serno = resultSet.getString(1);
         String aFlag = resultSet.getString(2);
         if(aFlag.equals("NO")) {
              String bmHASIC = serno.substring(0,7)+"8"+serno.substring(8);
              if(tempHash.containsKey(bmHASIC)) itemList.add(serno.substring(0,7)+"0"+serno.substring(8));
              }
         else System.out.println("Cannot assemble bare hybrid "+serno+" - this is already assembled.");
      }
      statement.close();
      System.out.println("There are "+recordCount+" bmHASICs and bmHPCs located at "+locn+" within the requested range.");
      System.out.println("Of these, "+itemList.size()+" bmHPCs are not yet assembled.");
 
      return itemList;
      }
// *****************************************************************************************************************
    public static Vector getBaseBoardVector(String sn1,String sn2,String locn) throws Exception {
// return a Vector containing bmSB serial nos, located at locn, not-assembled, with
// corresponding bmBBs at the same locn also non-assembled

      Vector itemList = new Vector();
      StringBuffer sqlStat = new StringBuffer("SELECT ");
      sqlStat.append("ser_no,assembled FROM items WHERE ser_no >="+sn1+" AND ser_no <="+sn2+" AND locn_name = '"+locn+"'");
      sqlStat.append(" ORDER BY ser_no");

      SCTDBInterface db = SCTDBInterface.getInstance();
      Statement statement = db.connection.createStatement();
      ResultSet resultSet = statement.executeQuery(sqlStat.toString());
      int recordCount=0;
      Hashtable tempHash = new Hashtable();
      for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
         recordCount++;
         String serno = resultSet.getString(1);
         String aFlag = resultSet.getString(2);
         tempHash.put(serno,"1");
//         if(aFlag.equals("NO")) tempHash.put(serno,"1");
//         else System.out.println("Cannot assemble to sensor-baseboard "+serno+" - this is already assembled.");
	    }
      statement.close();
      if(recordCount==0) {
             System.out.println("There are "+recordCount+" bmSBs located at "+locn+" within the requested range.");
             return itemList;
             }
// now check that the bmBB are there too
      String firstbit = sn1.substring(0,7);
      String lastbit = sn1.substring(8);
      String sn1_2 = firstbit+"8"+lastbit;
      firstbit = sn2.substring(0,7);
      lastbit = sn2.substring(8);
      String sn2_2 = firstbit+"8"+lastbit;

      sqlStat = new StringBuffer("SELECT ser_no,assembled FROM items WHERE ser_no >="+sn1_2+" AND ser_no <="+sn2_2+" AND locn_name = '"+locn+"'");
      sqlStat.append(" ORDER BY ser_no");
//      System.out.println(sqlStat.toString());
      statement = db.connection.createStatement();
      resultSet = statement.executeQuery(sqlStat.toString());
      recordCount=0;
      for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
         recordCount++;
         String serno = resultSet.getString(1);
         String aFlag = resultSet.getString(2);
         if(aFlag.equals("NO")) {
              String bmSB = serno.substring(0,7)+"0"+serno.substring(8);
              if(tempHash.containsKey(bmSB)) itemList.add(bmSB);
              }
         else System.out.println("Cannot assemble bare baseboard "+serno+" - this is already assembled.");
      }
      statement.close();
      System.out.println("There are "+recordCount+" bmSBs and bmBBs located at "+locn+" within the requested range.");
      System.out.println("Of these, "+itemList.size()+" bmBBs are not yet assembled.");
      return itemList;
      }
// *****************************************************************************************************************
    public static Vector getModuleVector(String sn1,String sn2,String locn) throws Exception {
// return a Vector containing module serial nos, located at locn, not-assembled
      Vector itemList = new Vector();
      StringBuffer sqlStat = new StringBuffer("SELECT ");
      sqlStat.append("ser_no,assembled FROM items WHERE ser_no >="+sn1+" AND ser_no <="+sn2+" AND locn_name = '"+locn+"'");
      sqlStat.append(" ORDER BY ser_no");
//      System.out.println(sqlStat.toString());
      Hashtable tempHash = new Hashtable();

      SCTDBInterface db = SCTDBInterface.getInstance();
      Statement statement = db.connection.createStatement();
      ResultSet resultSet = statement.executeQuery(sqlStat.toString());
      int recordCount=0;
      for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
         recordCount++;
         String serno = resultSet.getString(1);
         String aFlag = resultSet.getString(2);
         if(aFlag.equals("NO")) tempHash.put(serno,"1");
         else System.out.println("Cannot assemble to module "+serno+" - this is already assembled.");
	    }
      statement.close();
      if(recordCount==0) {
         System.out.println("There are "+recordCount+" modules located at "+locn+" within the requested range.");
         return itemList;
         }
// now check that the bmHASIC are there too, they must be NOT-assembled
      String firstbit = sn1.substring(0,7);
      String lastbit = sn1.substring(8);
      String sn1_2 = firstbit+"8"+lastbit;
      firstbit = sn2.substring(0,7);
      lastbit = sn2.substring(8);
      String sn2_2 = firstbit+"8"+lastbit;

      sqlStat = new StringBuffer("SELECT ser_no,assembled FROM items WHERE ser_no >="+sn1_2+" AND ser_no <="+sn2_2+" AND locn_name = '"+locn+"'");
      sqlStat.append(" ORDER BY ser_no");
//      System.out.println(sqlStat.toString());
      statement = db.connection.createStatement();
      resultSet = statement.executeQuery(sqlStat.toString());
      recordCount=0;
      for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
         recordCount++;
         String serno = resultSet.getString(1);
         String aFlag = resultSet.getString(2);
         if(!aFlag.equals("NO")) System.out.println("Cannot assemble ASIC_HYBRID "+serno+" - this is already assembled.");
         else {
            String bmModule = serno.substring(0,7)+"0"+serno.substring(8);
            if(tempHash.containsKey(bmModule)) itemList.addElement(bmModule);
            else System.out.println(bmModule+" is not located at "+locn);
         }
      }
      statement.close();
      System.out.println("There are "+recordCount+" modules located at "+locn+" within the requested range.");
      System.out.println("Of these, "+itemList.size()+" are not yet assembled.");

      return itemList;
      }
// *****************************************************************************************************************
    public static boolean checkSensorList(Vector snList,String locn) throws Exception {

      StringBuffer snBuffer = new StringBuffer();
      int ndets=0;
      for(int i=0;i<snList.size();i++) {
          if(ndets>0) snBuffer.append(",");
          snBuffer.append((String)snList.elementAt(i));
          ndets++;
          }
      StringBuffer sqlStat = new StringBuffer("SELECT ");
      sqlStat.append("ser_no,assembled,locn_name FROM items WHERE ser_no IN ("+snBuffer.toString()+")");
      sqlStat.append(" AND ctype='bmSiDetectorOut'");
      sqlStat.append(" ORDER BY ser_no");

      SCTDBInterface db = SCTDBInterface.getInstance();
      Statement statement = db.connection.createStatement();
      ResultSet resultSet = statement.executeQuery(sqlStat.toString());

      int recordCount=0;
      int nready=0;
      for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
         recordCount++;
         String serno = resultSet.getString(1);
         String aFlag = resultSet.getString(2);
         String thislocn = resultSet.getString(3);
         if(aFlag.equals("NO") && thislocn.equals(locn)) nready++;
         else {
              if(aFlag.equals("YES")) System.out.println("Cannot assemble sensor "+serno+" - this is already assembled.");
              if(!thislocn.equals(locn))  System.out.println("Cannot assemble sensor "+serno+" - this is at "+thislocn+", not "+locn);
	    }
         }
      statement.close();
      if(nready!=4) return false;
      return true;
      }
// *****************************************************************************************************************
    public static boolean checkSensorBaseboard(String sn,String locn) throws Exception {


      StringBuffer sqlStat = new StringBuffer("SELECT ");
      sqlStat.append("ser_no,assembled,locn_name FROM items WHERE ser_no = "+sn);
      sqlStat.append(" AND ctype='bmSB'");

      SCTDBInterface db = SCTDBInterface.getInstance();
      Statement statement = db.connection.createStatement();
      ResultSet resultSet = statement.executeQuery(sqlStat.toString());

      int nready=0;
      int ncounts=0;
      for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
         ncounts++;
         String serno = resultSet.getString(1);
         String aFlag = resultSet.getString(2);
         String thislocn = resultSet.getString(3);
         if(aFlag.equals("NO") && thislocn.equals(locn)) nready++;
         else {
              if(aFlag.equals("YES")) System.out.println("Cannot assemble sensor-baseboard "+serno+" - this is already assembled.");
              if(!thislocn.equals(locn))  System.out.println("Cannot assemble sensor-baseboard "+serno+" - this is at "+thislocn+", not "+locn);
	    }
         }
      
      statement.close();
      if(ncounts==0) System.out.println("No sensor-baseboard registered with serial no "+sn);
      if(nready!=1) return false;
      return true;
      }

// *****************************************************************************************************************
    public static Hashtable getChipHash(Vector chipList, String thisLocn) throws Exception {
      Hashtable thisHash = new Hashtable();
      StringBuffer mfrSerNos = new StringBuffer();
      for(int i=0;i<chipList.size();i++) {
          if(i>0) mfrSerNos.append(",");
          mfrSerNos.append("'"+(String)chipList.elementAt(i)+"'"); 
          }
      StringBuffer sqlStat = new StringBuffer("SELECT ");
      sqlStat.append("ser_no,mfr_ser_no,locn_name FROM items WHERE mfr_ser_no IN ("+mfrSerNos.toString()+") AND ctype='chABCD3T' AND assembled='NO'");
      sqlStat.append(" ORDER BY ser_no");

      SCTDBInterface db = SCTDBInterface.getInstance();
      Statement statement = db.connection.createStatement();
      ResultSet resultSet = statement.executeQuery(sqlStat.toString());
      int recordCount=0;
      for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          recordCount++;
          String sn = resultSet.getString(1);   
          String mfr = resultSet.getString(2);
          String locn = resultSet.getString(3);
          if(!locn.equals(thisLocn)) {
                  System.out.println("Chip "+mfr+" is owned by "+locn+", not "+thisLocn+"!");
                  continue;
                  }
          thisHash.put(mfr,sn);
	    }
//      System.out.println("Retrieved "+recordCount+" records in total.");
      statement.close();
      return thisHash;
      }
// *****************************************************************************************************************
    public static Vector getItemVector(String serialNo) throws Exception {
      Vector itemList = new Vector();
      StringBuffer sqlStat = new StringBuffer("SELECT ");
      sqlStat.append("mfr,mfr_ser_no,ctype,locn_name,assembled,trashed FROM items WHERE ser_no="+serialNo);
      sqlStat.append(" ORDER BY ser_no");

      SCTDBInterface db = SCTDBInterface.getInstance();
      Statement statement = db.connection.createStatement();
      ResultSet resultSet = statement.executeQuery(sqlStat.toString());
      int recordCount=0;
      for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          recordCount++;
          itemList.addElement(resultSet.getString(1));   // mfr name
          itemList.addElement(resultSet.getString(2));   // mfr serial no
          itemList.addElement(resultSet.getString(3));   // type
          itemList.addElement(resultSet.getString(4));   // location name
          itemList.addElement(resultSet.getString(5));   // assembled flag
          itemList.addElement(resultSet.getString(6));   // trashed flag
	    }
//      System.out.println("Retrieved "+recordCount+" records in total.");
      statement.close();
      return itemList;
      }

// ****************************************************************************************************************
    public static Vector getSNfile(String shipment_no) throws Exception {
      Vector itemList = new Vector();
      Vector theLine =  new Vector();
      theLine.addElement("Serial Number");
      theLine.addElement("Mfr Serial No");
      theLine.addElement("Type");
      theLine.addElement("Current Location");
      theLine.addElement("Assembled?");
      itemList.addElement(theLine);

      StringBuffer sqlStat = new StringBuffer("SELECT ");
      sqlStat.append("ser_no,mfr_ser_no,ctype,locn_name,assembled FROM items");
      sqlStat.append(" WHERE ser_no IN (SELECT ship_items.ser_no FROM ship_items WHERE ship_items.ship_no = "+shipment_no+")");
      sqlStat.append(" ORDER BY ser_no");

      SCTDBInterface db = SCTDBInterface.getInstance();
      Statement statement = db.connection.createStatement();
      ResultSet resultSet = statement.executeQuery(sqlStat.toString());
     int recordCount=0;
     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          recordCount++;
          theLine = new Vector();
          theLine.addElement(resultSet.getString(1));   // serial no
          theLine.addElement(resultSet.getString(2));   // mfr serial no
          theLine.addElement(resultSet.getString(3));   // type
          theLine.addElement(resultSet.getString(4));   // location name
          theLine.addElement(resultSet.getString(5));   // assembled flag
          itemList.addElement(theLine);
	    }
      System.out.println("Retrieved "+recordCount+" records in total.");
      statement.close();
      return itemList;
      }
//*******************************************************************************8
      public static Vector checkDataSheets(String location, int fileType, Vector fileList) throws Exception {
          
         StringBuffer sqlStat = new StringBuffer("SELECT run_no FROM tests");
         sqlStat.append(" WHERE tests.locn_name='"+location+"' AND tests.test_name='"+dataSheetTestNames[fileType]+"'");

//      SCTDBInterface db = SCTDBInterface.getInstance();
      Statement statement = SCTDBInterface.getInstance().connection.createStatement();
      ResultSet resultSet = statement.executeQuery(sqlStat.toString());

        for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          String testFileName = resultSet.getString(1);
          if(fileList.removeElement(testFileName)) {
              System.out.println(testFileName+" is already uploaded, skipping...");
              }
          }
      statement.close();
      return fileList;
      }
//-----------------------------------------------------------------------------------------------
   public static Hashtable getDataSheetStatus(String moduleSerialNo, String bmSBserialNo) throws Exception {
// return a has of testdatasheet name vs DB testno
      Hashtable thisHash = new Hashtable();
      if(moduleSerialNo==null) return thisHash;
      
      StringBuffer sqlStat = new StringBuffer("SELECT ");
      sqlStat.append(" tests.test_no,tests.test_name FROM tests");
      sqlStat.append(" WHERE tests.test_name LIKE 'bm%_RData'");
      sqlStat.append(" AND tests.run_no != 'SIGNOFF' AND tests.run_no != 'FINALSIGNOFF'");

      String sn1 = moduleSerialNo.substring(0,7)+"%"+moduleSerialNo.substring(8);
      if(bmSBserialNo!=null) {
         String sn2= bmSBserialNo.substring(0,7)+"%"+bmSBserialNo.substring(8);
         sqlStat.append(" AND (tests.ser_no LIKE '"+sn1+"' OR tests.ser_no LIKE '"+sn2+"')");
         }
      else sqlStat.append(" AND tests.ser_no LIKE '"+sn1+"'");
 
      sqlStat.append(" ORDER BY tests.test_date,tests.test_no");
   
      Statement statement = SCTDBInterface.getInstance().connection.createStatement();
      ResultSet resultSet = statement.executeQuery(sqlStat.toString());
      for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          String testno = resultSet.getString(1);
          String testname = resultSet.getString(2);
          thisHash.put(testname,testno);
          }
      statement.close();
      return thisHash;
      }
//************************************************************************************
   public static Vector getXYMetrologyData(String testno) throws Exception {
// generate report of single XY metrology data measurement
      Vector itemList = new Vector();
      Vector theLine = new Vector();
      theLine.addElement("Parameter");
      theLine.addElement("Nominal");
      theLine.addElement("Data");
      theLine.addElement("Deviation");
      theLine.addElement("GOOD cut");
      theLine.addElement("PASS cut");
      theLine.addElement("PASS2 cut");
      theLine.addElement("SPARE cut");
      theLine.addElement("Status");
      itemList.addElement(theLine);
      StringBuffer sqlStat = new StringBuffer("SELECT EVENT");
      for(int i=0;i<xyMetrologyParameters.length;i++) {
              sqlStat.append(",");
              sqlStat.append(xyMetrologyParameters[i]);
              }
      sqlStat.append(" FROM SCT_TSTBMSURVEYXY WHERE test_no = "+testno);
      Statement statement = SCTDBInterface.getInstance().connection.createStatement();
//     System.out.println(sqlStat.toString());
     java.text.DecimalFormat myFormatter = new java.text.DecimalFormat("#.##");
     String machine="";
     String temperature="";
     ResultSet resultSet = statement.executeQuery(sqlStat.toString());
     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          String eventType = resultSet.getString(1);
          for(int i=0;i<xyMetrologyParameters.length;i++) {
             theLine = new Vector();
             String theData = resultSet.getString(2+i);
             if(i==xyMetrologyParameters.length-2) machine = resultSet.getString(2+i);
             else if(i==xyMetrologyParameters.length-1) temperature = resultSet.getString(2+i);
             else {      
                     double idata = Double.parseDouble(theData);
                     idata *= XYConversions[i];   // convert to microns
                     String thisData = myFormatter.format(idata);
                     idata-=XYOffsets[i];  // offset from nominal if requested
                     String deviation = myFormatter.format(idata);
                     theLine.addElement(xyMetrologyParameters[i]);
                     theLine.addElement(Double.toString(XYOffsets[i]));
                     theLine.addElement(thisData);
                     theLine.addElement(deviation);
                     for(int j=0;j<4;j++) theLine.addElement(Double.toString(XYTolerances[j][i]));
                     if(eventType.equals("SB")) {
                       if(i<13) theLine.addElement(categories[getXYStatus(i,theData)]);
                       else theLine.addElement("n/a");
                       }
                     else theLine.addElement(categories[getXYStatus(i,theData)]);
                     itemList.addElement(theLine);
                     }
                  }      
      }
      statement.close();
      Vector returnVector = new Vector();
      returnVector.addElement(machine);
      returnVector.addElement(temperature);
      returnVector.addElement(itemList);
      return returnVector;
}

    public static int getXYStatus(int index, String data) {
      double idata = Double.parseDouble(data);
      idata *= XYConversions[index];   // convert to microns
      idata-=XYOffsets[index]; 
      String deviation = new java.text.DecimalFormat("#.#####").format(idata);
      int thisIndex = deviation.indexOf("."); 
      if(thisIndex!=-1) {
         int maxLength = thisIndex+XYTolerances_rd[index]+1;
         if(deviation.length()>maxLength) deviation = deviation.substring(0,maxLength);
         }    
      double dev = Double.parseDouble(deviation);

      for(int j=0;j<4;j++) if(Math.abs(dev)<=XYTolerances[j][index]) return j;
      return 4;
      }

    public static int getZStatus(int index, String data) {

      int thisIndex = data.indexOf(".");
      double idata;
  
      switch(ZToleranceType[index]) {
        default:
         return 0;
        case 0: 
         if(thisIndex!=-1) {
           int maxLength = thisIndex+ZTolerances_rd[index]+1;
           if(data.length()>maxLength) data = data.substring(0,maxLength);
           } 
         idata = Double.parseDouble(data);
         for(int j=0;j<4;j++) if(idata>=ZTolerances[j][index]) return j;
         break;
        case 1:
// special case for optimalRMSZerrorLower and optimalRMSZerrorUpper
// precision is 3 for GOOD/PASS, 2 for PASS2/SPARE
         for(int j=0;j<4;j++) {
           int precision = (j>1 && (index==12 || index==13)) ? 2 : ZTolerances_rd[index];
           if(thisIndex!=-1) {
             int maxLength = thisIndex+precision+1;
             if(data.length()>maxLength) data = data.substring(0,maxLength);
             } 
           idata = Double.parseDouble(data);
           if(idata<=ZTolerances[j][index]) return j;
           }
         break;
        case 2:
         double dev = Math.abs(ZDesignValues[index]-Double.parseDouble(data));
         String deviation = new java.text.DecimalFormat("#.#####").format(dev);
         thisIndex = deviation.indexOf(".");
         if(thisIndex!=-1) {
           int maxLength = thisIndex+ZTolerances_rd[index]+1;
           if(deviation.length()>maxLength) deviation = deviation.substring(0,maxLength);
           } 
         dev = Double.parseDouble(deviation);
         for(int j=0;j<4;j++) if(dev<=ZTolerances[j][index]) return j;
         break;
         }
       return 4;
       }



//***********************************************************************************************
   public static Vector getZMetrologyData(String testno) throws Exception {
// generate report of single XY metrology data measurement
      Vector itemList = new Vector();
      Vector theLine = new Vector();
      theLine.addElement("Parameter");
      theLine.addElement("Data");
      theLine.addElement("GOOD cut");
      theLine.addElement("PASS cut");
      theLine.addElement("PASS2 cut");
      theLine.addElement("SPARE cut");
      theLine.addElement("Category");
      itemList.addElement(theLine);
      StringBuffer sqlStat = new StringBuffer("SELECT EVENT");
      for(int i=0;i<zMetrologyParameters.length;i++) {
              sqlStat.append(",");
              sqlStat.append(zBarrelDBParameters[i]);
              }
      sqlStat.append(" FROM SCT_TSTBMSURVEYZ WHERE test_no = "+testno);
      Statement statement = SCTDBInterface.getInstance().connection.createStatement();
//     System.out.println(sqlStat.toString());
     String machine="";
     String temperature="";
     ResultSet resultSet = statement.executeQuery(sqlStat.toString());
     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          String eventType=resultSet.getString(1);
          for(int i=0;i<zMetrologyParameters.length;i++) {
             theLine = new Vector();
             String theData = resultSet.getString(2+i);
             if(i==zMetrologyParameters.length-2) machine = resultSet.getString(2+i);
             else if(i==zMetrologyParameters.length-1) temperature = resultSet.getString(2+i);
             else {      

                     theLine.addElement(zMetrologyParameters[i]);
                     theLine.addElement(theData);
                     switch(ZToleranceType[i]) {
                        default:
                          theLine.addElement("n/a");
                          theLine.addElement("n/a");
                          theLine.addElement("n/a");
                          theLine.addElement("n/a");
                          break;
                        case 0:
                          for(int j=0;j<4;j++)theLine.addElement(">="+Double.toString(ZTolerances[j][i]));
                          break;
                        case 1:
                          for(int j=0;j<4;j++)theLine.addElement("<="+Double.toString(ZTolerances[j][i]));
                          break;
                        case 2:
                          for(int j=0;j<4;j++)theLine.addElement(Double.toString(ZDesignValues[i])+"+/-"+Double.toString(ZTolerances[j][i]));
                          break;
                        }
                     if(ZToleranceType[i]==3) theLine.addElement("n/a");
                     else {
                       if(eventType.equals("SB")) {
                          if(is_SB_ZTolerance[i]) theLine.addElement(categories[getZStatus(i,theData)]);
                          else theLine.addElement("n/a");
                          }
                       else theLine.addElement(categories[getZStatus(i,theData)]);
                       }
                     itemList.addElement(theLine);
                     }
                  }      
      }
      statement.close();
      Vector returnVector = new Vector();
      returnVector.addElement(machine);
       returnVector.addElement(temperature);
      returnVector.addElement(itemList);
      return returnVector;
}     

   public static void checkQualityUploads(Map qualityMap,Map signoffMap) throws Exception {

         StringBuffer sqlStat = new StringBuffer("SELECT ser_no,run_no FROM tests");
         sqlStat.append(" WHERE test_name='bmMOD_RData'");
         sqlStat.append(" ORDER BY test_date, test_no");
         Statement statement = SCTDBInterface.getInstance().connection.createStatement();
         ResultSet resultSet = statement.executeQuery(sqlStat.toString());
         for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
            String sn = resultSet.getString(1);
            String type = resultSet.getString(2);
            if(type.equals("SIGNOFF")) qualityMap.remove(sn);
            if(type.equals("FINALSIGNOFF")) signoffMap.remove(sn);
	    }
      statement.close();
      }

    public static String writeUploadFile(String sn, String dataFile, String userInitials, String location, String signoffType) throws Exception {
        Preferences.PreferencesInterface prefs = Preferences.PreferencesInterface.getInstance();
        java.io.File outFile = new java.io.File(prefs.getPreference(Preferences.PreferencesInterface.UPLOAD_DIR),sn+"_"+signoffType+".upl");
        java.io.BufferedWriter out = new java.io.BufferedWriter(new java.io.FileWriter(outFile));
        out.write("%NEWTEST");
        out.newLine();
        out.write("SERIAL NUMBER : "+sn);
        out.newLine();
        out.write("TEST MADE BY : "+userInitials);
        out.newLine();
        out.write("LOCATION NAME : "+location);
        out.newLine();
        out.write("Run number : "+signoffType);
        out.newLine();
        out.write("TEST DATE : "+guiUtilities.DaveUtils.getTodaysDate());
        out.newLine();
        out.write("PASSED : YES");
        out.newLine();
        out.write("PROBLEM : NO");
        out.newLine();
        out.write("%bmMOD_RData");
        out.newLine();
        out.write("%TEST Rawdata");
        out.newLine();
        out.write("FILENAME : "+dataFile);
        // note deliberately miss final newline, otherwise UploadTestData will fail!
        out.close();
        return outFile.getAbsolutePath();
        }
 

}