package DisplayGUI;
/*
 
 */

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import javax.swing.event.TableModelEvent;


public class guiTableAdapter extends AbstractTableModel implements displayParams {
    Vector		rows;
    public int recordCount;
    String[]            columnNames = {};
    public guiTableAdapter() {
       rows = new Vector();
       recordCount=0;
         }


// update the table using externally queried and processed data
    public void reTable(Vector theData) {
         if(theData.size()>0) {
           Vector colNames = (Vector)theData.elementAt(0); // first line should be column names
           int numberOfColumns = colNames.size();
           columnNames = new String[numberOfColumns];

           for(int column = 0; column < numberOfColumns; column++) {
             columnNames[column] = (String)colNames.elementAt(column);
             }
  
           theData.removeElementAt(0);
         }
         rows = theData;
         recordCount= (theData.size()>=0) ? theData.size() : 0;

         fireTableChanged(null); // Tell the listeners a new table has arrived.


      return ;
    }

//    protected void finalize() throws Throwable {
//        closeConnection();
//        super.finalize();
//    }

    //  Now the Implementation of the TableModel Interface
   
    public String getColumnName(int column) {
        if (columnNames[column] != null) {
            return columnNames[column];
        } else {
            return "";
        }
    }

    public Class getColumnClass(int column) {
//            return String;
            return getValueAt(0, column).getClass();

   }

    public boolean isCellEditable(int row, int column) {
            return false;
 
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    // Data methods

    public int getRowCount() {
        return rows.size();
    }

    public Object getValueAt(int aRow, int aColumn) {
        Vector row = (Vector)rows.elementAt(aRow);
        return row.elementAt(aColumn);
    }


    public void setValueAt(Object value, int row, int column) {
        Vector dataRow = (Vector)rows.elementAt(row);
        dataRow.setElementAt(value, column);

    }


}
