/*
 * gui.java
 *
 * Created on 24 June 2003, 12:08
 */

package DisplayGUI;
import javax.swing.*;
import java.util.Vector;
import java.util.Hashtable;
import java.util.Enumeration;
import java.awt.event.*;

/**
 *
 * @author  robinson
 * the SctGUI
 */
public class gui extends javax.swing.JFrame implements displayParams,TestDataInfo {
    
    // panes
     public DisplayStatus displayStatus;
     public DisplayStatusPane displayStatusPane;
     public javax.swing.JPanel bannerPane;
     public DisplayPanel displayPane;
     public ConfigurationInterface config;
     public ISInterface isInterface;
     public CalibrationControllerPanel2 calibrationControllerPanel;
     public GuiMenuBar2 menuBar;
     public guiUtilities.HTMLViewer htmlViewer;
     public TablesDisplayPane tablesDisplayPane;
     public ColorScalePane colorScalePane;
//     public DisplayTitlePane displayTitlePane;
     public SelectorPane selectorPane;
     private ConfigurationListener configurationListener;
     public ProdDatabase.UploadProgressMonitor uploader;
    
    /** Creates new form start */
    public gui() {
        // pre-init code
        super("SctGui");

        config = ConfigurationInterface.getInstance();
        isInterface = new ISInterface(this);
        htmlViewer = guiUtilities.HTMLViewer.getInstance();

// create the sCT database uploader
        uploader = new ProdDatabase.UploadProgressMonitor(this);
        
// create menuBar
        menuBar = new GuiMenuBar2(this);
        setJMenuBar(menuBar);

// general components
        initComponents();

        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);

        displayPane.initPanelParameters();
        displayStatus.setConfigurationMode();
        displayPane.setDisplayColors();
        displayPane.refreshDisplay();

        configurationListener = new ConfigurationListener(this);

    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        displayStatus = new DisplayStatus(this);
        selectorPane = new SelectorPane(this);

        bannerPane = new banner();
        displayPane = new DisplayPanel(this);
        tablesDisplayPane = new TablesDisplayPane(this);
        colorScalePane = new ColorScalePane(this);
//        displayTitlePane = new DisplayTitlePane(this);
        displayStatusPane = new DisplayStatusPane(this);
        calibrationControllerPanel = new CalibrationControllerPanel2(this);

        JPanel pane = new JPanel();
        pane.setBackground(new java.awt.Color(255, 255, 255));
        java.awt.GridBagConstraints gridBagConstraints;
        pane.setLayout(new java.awt.GridBagLayout());


        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new java.awt.Insets(10,10,0,10);
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        pane.add(colorScalePane, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.7;
        gridBagConstraints.weightx = java.awt.GridBagConstraints.REMAINDER;       
//        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.insets = new java.awt.Insets(10,10,0,10);
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        pane.add(tablesDisplayPane, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.insets = new java.awt.Insets(10,10,10,0);
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        pane.add(selectorPane, gridBagConstraints);
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
 //       gridBagConstraints.insets = new java.awt.Insets(yOffSet-4, 0, 0, 0);
        gridBagConstraints.insets = new java.awt.Insets(10,10,0,10);
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 0.1;
        pane.add(calibrationControllerPanel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.insets = new java.awt.Insets(10,0,10,10);
        gridBagConstraints.ipadx=5;
//        gridBagConstraints.ipady=5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        pane.add(displayPane, gridBagConstraints);

        setContentPane(pane);

        pack();
    }
//	public java.awt.Insets getInsets() {
//		return new java.awt.Insets(10,10,10,10);
//		}
    
    /** Exit the Application */
    public  void exitForm(java.awt.event.WindowEvent evt) {

        ExitPrompt exitPrompt = new ExitPrompt(this,true);
        exitPrompt.setLocationRelativeTo(this);
        exitPrompt.setVisible(true);
        if(!exitPrompt.okToExit()) return;

        calibrationControllerPanel.close();   // unsubscribe from control object
        displayStatus.unsubscribeAll();
        htmlViewer.close();                   // delete html reports
        configurationListener.close();
        System.exit(0);
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new gui().show();
    }

      



      
        





}
