package DisplayGUI;

import Sct_CalibrationController.TestData;
import is.*;
import Sct.Serializable;
import Sct.IS.*;

/**
 *
 * @author  robinson
 */
public class TestSelection implements TestDataInfo {

     String resultObjectHeader;   // the header of the summary object name
     String sctdbObjectHeader;    // the header of the SCTDAQ object name
     String testObjectHeader;     // the header of the test object name
     String sctdbRodDaqObjectHeader; // the header of the SCTDB RodDaq object name
     String regex;         // the run no and scanno
     TestData testData;
     int testIndex;
     String testObjectName;

     public TestSelection(String testObjectName, String location) {

         StringBuffer regexB = new StringBuffer(".*(");         
         testIndex=-1;
         this.testObjectName = testObjectName;

         try {
           testData = new TestData(); 
           GuiComponents.System.ISInterface.getInstance().getRepository().getValue(testObjectName, testData); 
           String runNo = Integer.toString(testData.runNumber);
           for(int k=testData.startScanNumber;k<testData.startScanNumber+testData.nScans;k++) {
             if(k>testData.startScanNumber) regexB.append("|");
             regexB.append("\\.");
             regexB.append(runNo);
             regexB.append("\\.");
             regexB.append(Integer.toString(k));
             regexB.append("\\.");
             }
         regexB.append(")");

// first extract the run number, and scan numbers
           String testName = testData.testName;
           for(int i=0;i<testNames.length;i++) {
           if(testName.indexOf(testNames[i])!=-1) {
                    if(testName.equals("NPtGainTest") && testData.nScans==3) {
                             testIndex=TEST_3PTGAIN;
                             break;
                             }
                    testIndex=i;
                    break;
                    }  
            }       
          }catch(Exception e2) {
              System.err.println("SctGUI::TestSelection : Exception extracting TestData : "+e2.toString());
              testData=null;
              }

          if(testIndex==-1) {
             System.out.println("sctGui::TestSelection : Unrecognised testname: "+testData.testName);
             resultObjectHeader=null;
             sctdbObjectHeader=null;
             testObjectHeader=null;
             sctdbRodDaqObjectHeader=null;
             regex=null;
             return;
             }
       
          testObjectHeader = "TestData.SctData::"+testData.testName+"Result."+Integer.toString(testData.runNumber)+"."+Integer.toString(testData.startScanNumber)+".";
          resultObjectHeader = isRetrievedData() ? "RetrievedData.Summary."+Integer.toString(testData.runNumber)+"."+Integer.toString(testData.startScanNumber)+"." : "TestData.Summary."+Integer.toString(testData.runNumber)+"."+Integer.toString(testData.startScanNumber)+".";
          sctdbObjectHeader = "SCTDBData."+testNames[testIndex]+"."+location+".";
          sctdbRodDaqObjectHeader = "SCTDBData."+Preferences.PreferencesInterface.getInstance().getPreference(Preferences.PreferencesInterface.INSTITUTE)+".Summary."+Integer.toString(testData.runNumber)+"."+Integer.toString(testData.startScanNumber)+".";
          regex = regexB.toString();
         } 
      public void setSCTDBLocation(String location) {
          sctdbObjectHeader=null;
          if(testIndex==-1) return;
          sctdbObjectHeader = "SCTDBData."+testNames[testIndex]+"."+location+".";
          }
      public String getRunScanRegex() {
          return regex;
          }
      public int getTestIndex() {
          return testIndex;
          }
      public String getTestObjectHeader() {
          return testObjectHeader;
          }
      public String getResultObjectHeader() {
          return resultObjectHeader;
          }
      public String getSCTDBObjectHeader() {
          return sctdbObjectHeader;
          }
      public String getSCTDBRodDaqObjectHeader() {
          return sctdbRodDaqObjectHeader;
          }
   public int getRunNo() {
         if(testData==null) return -1;
         else return testData.runNumber;
         }
   public int getScanNo() {
         if(testData==null) return -1;
         else return testData.startScanNumber;
         }
   public int getNoScans() {
         if(testData==null) return 0;
         else return testData.nScans;
         }
   public String getTestName() {
         if(testData==null) return null;
         else return testData.testName;
         }
   public int getStartScanNumber() {
         if(testData==null) return -1;
         else return testData.startScanNumber;
         }
   public TestData getTestData() {
        // get updated copy of testData
        try {
           GuiComponents.System.ISInterface.getInstance().getRepository().getValue(testObjectName, testData); 
           return testData;
        }catch(Exception e){System.err.println("SctGUI::TestSelection - cant retrieve testData - "+e.toString());}
        return null;
        }
   public int getTestStatus() {
        try {
           GuiComponents.System.ISInterface.getInstance().getRepository().getValue(testObjectName, testData); 
           return testData.status;
        }catch(Exception e){System.err.println("SctGUI::TestSelection - cant retrieve testData - "+e.toString());}
        return -1;
        }
   public boolean isRetrievedData() {
       return testObjectName.startsWith("RetrievedData");
       }
   public boolean isSCTDBRodDaqData() {
       return testObjectName.startsWith("SCTDBData");
       }

}
       