package DisplayGUI;
/** 
Detector parameters. 
**/

public interface TestDataInfo {

   static final String[] testNames = {"ResetTest","RedundancyTest","FullBypassTest","PipelineTest",
"StrobeDelayTest","3PtGainTest","TrimRangeTest","NPtGainTest","NoiseOccupancyTest","TimeWalkTest","LongTermTest","IVScanTest","NMaskTest", "RxThresholdTest", "RxDelayTest","DefaultTest"};
   static final String[] testMenuNames = {
       "Reset","Redundancy","FullByPass","Pipeline",
       "StrobeDelay","3PtGain","Trim","NPtGain","Noise","TimeWalk","LongTerm","IVscan","NMask",  
       "RxThreshold", "RxDelay", "DefaultTest"};
// the keywords to flag tests in the result summary files
   static final String[] resultFileKeyNames = {
              "","",
              "FullBypassTest","PipelineTest","StrobeDelay","ThreePointGain","Trim","ResponseCurve","NO","TimeWalkTest",
              "","DetModIV","NMaskTest", "RxThreshold", "RxDelay","DefaultTest"};

   static final String[][] testParameters = {
                {},
                {},
                {"Result Status","Defect Count","DCS Conditions","Token","RToken","Token Comment","RToken Comment"},
                {"Result Status","Defect Count","DCS Conditions","Defective pipelines"},
                {"Result Status","Defect Count","DCS Conditions","Strobe Delay"},
                {"Result Status","Defect Count","DCS Conditions","VT50(mV)","VT50(mV) RMS","Gain (mV/fC)","Gain RMS","Offset (mV)","Offset RMS","Output Noise (mV)","Input Noise (enc)","Noise RMS (enc)"},
                {"Result Status","Defect Count","DCS Conditions","Trim Range","Target","N(untrimmed)","VT50(mV)","VT50(mV) RMS","Offset (mV)","Offset RMS","Step size (mV)","Step Size RMS"},
                {"Result Status","Defect Count","DCS Conditions","VT50(mV)","VT50(mV) RMS","Gain (mV/fC)","Gain RMS","Offset (mV)","Offset RMS","Output Noise (mV)","Input Noise (enc)","Noise RMS (enc)"},
                {"Result Status","Defect Count","DCS Conditions","Offset (mV)","Occupancy","RMS Occupancy","Input Noise (enc)"},
                {"Result Status","Defect Count","DCS Conditions","TimeWalk(ns)","TCal"},
                {},
                {},
                {"Result Status","Defect Count","DCS Conditions"},  // NMask - no other data
		{"Result Status","Defect Count","DCS Conditions","Rx Threshold"},
		{"Result Status","Defect Count","DCS Conditions","Rx Delay"},
                {}
         };
   static final boolean[][] canBeZero = {
                {},
                {},
                {true,true,true,true,true,true,true},
                {true,true,true,true},
                {true,true,true,true},
                {true,true,true,true,true,true,true,true,true,true,true,true},
                {true,true,true,true,true,true,true,true,true,true,true,true},
                {true,true,true,true,true,true,true,true,true,true,true,true},
                {true,true,true,true,true,true,true},
                {true,true,true,true,true},
                {},
                {},
                {true,true,true},  // NMask - no other data
		{true, true, true,true},
		{true, true, true,true},
                {}
         };
   public double[][] testDataTolerances = {
                {},
                {},
                {0.0,1.0,0.0,0.1,0.1,1.0,1.0},
                {0.0,1.0,0.0,1.0},
                {0.0,1.0,0.0,3.0},
                {0.0,1.0,0.0,50.0,5.0,10.0,1.0,5.0,3.0,2.0,200.0,50.0},
                {0.0,1.0,0.0,4.0,200.0,1.0,100.0,10.0,100.0,20.0,10.0,1.0},
                {0.0,1.0,0.0,50.0,5.0,10.0,1.0,5.0,3.0,2.0,200.0,50.0},
                {0.0,1.0,0.0,10.0,5e-5,5e-5,200.0},
                {0.0,1.0,0.0,0.5,0.5},
                {},
                {},
                {0.0, 1.0,0.0,},
		{0.0, 1.0, 0.0,3.0},
		{0.0, 1.0, 0.0,3.0},
                {}
          };

   public final String[] chipOptions = {"Chip Maximum","Chip Minimum","Mean (Link0)","Mean (Link1)","Chip M0","Chip S1","Chip S2","Chip S3","Chip S4","Chip E5","Chip M8",
"Chip S9","Chip S10","Chip S11","Chip S12","Chip E13"}; 

   public final String[] linkOptions = {"Link 0","Link 1"};

   public final String[] dcsOptions = {"Sensor HV(Volts)","Sensor Current(uA)","Hybrid T0(degC)","Hybrid T1(degC)","Chip VCC (Volts)","Chip ICC (mA)","Chip VDD (Volts)","Chip IDD (mA)"};

   public final String[] dcsParams = {"HVchVolt","HVchCurr","MOch_Tm0","MOch_Tm1","LVch_Vcc","LVch_Icc","LVch_Vdd","LVch_Idd"};


   public static final int TEST_RESET=0;
   public static final int TEST_REDUNDANCY=1;
   public static final int TEST_FULLBYPASS=2;
   public static final int TEST_PIPELINE=3;
   public static final int TEST_STROBEDELAY=4;
   public static final int TEST_3PTGAIN=5;
   public static final int TEST_TRIM=6;
   public static final int TEST_NPTGAIN=7;
   public static final int TEST_NOISE=8;
   public static final int TEST_TIMEWALK=9;
   public static final int TEST_LONGTERM=10;
   public static final int TEST_IV=11;
   public static final int TEST_NMASK=12;
   public static final int TEST_RXTHRESHOLD=13;
   public static final int TEST_RXDELAY=14;
   public static final int TEST_DEFAULT=15;

   public final boolean[] testIsDefined = {false,false,true,true,true,true,true,true,true,true,false,false,true, true, true,false};
   public final boolean[] testIsSCTDAQ = {true,true,true,true,true,true,true,true,true,true,true,true,false,false,false,false};

}

