/*
 * TablesDisplayPane.java
 *
 * Created on 23 June 2003, 15:43
 */

package DisplayGUI;
import javax.swing.JTable;
import javax.swing.event.*;
import javax.swing.ListSelectionModel;
import java.awt.event.KeyListener;
import java.awt.event.KeyEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.JOptionPane;
import java.util.Vector;
import java.util.Hashtable;
import java.util.Collections;
import Sct_CalibrationController.TestData;
import GuiComponents.System.*;
/**
 *
 * @author  robinson
 */
public class TablesDisplayPane extends javax.swing.JPanel implements TestDataInfo,TableModelListener,ListSelectionListener,displayParams {
    gui guiControl;
    public javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    public javax.swing.JLabel table1Title;
    public javax.swing.JLabel table2Title;
    guiTableAdapter[] resultTable = new guiTableAdapter[2];
    JTable[] table = new JTable[2];
    Vector[] objectNames = new Vector[2];
    ListSelectionModel[] rowSM = new ListSelectionModel[2];
    String table1,table2;
    boolean selectionListenerIsActive=true;
    private GuiComponents.System.ISInterface is;

    private TestSelection testSelection;
    private IVTestSelection ivTestSelection;

    public TablesDisplayPane(gui parent) {
        guiControl=parent;
        testSelection=null;
        ivTestSelection=null;
        is = GuiComponents.System.ISInterface.getInstance();
        for(int i=0;i<2;i++) {
          resultTable[i] = new guiTableAdapter();
          resultTable[i].addTableModelListener(this);
          table[i] = new JTable(resultTable[i]);
          table[i].setFont(tableFont);
          rowSM[i] = table[i].getSelectionModel();
          rowSM[i].addListSelectionListener(this);
        }

        table[0].setSelectionMode(ListSelectionModel.SINGLE_INTERVAL_SELECTION);
        table[1].setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

        table1 = null;
        table2 = null;

        initComponents();

        table[0].addMouseListener(new tables0MouseAdapter());  // popup menu on second table only
        table[1].addMouseListener(new tables1MouseAdapter());  // popup menu on second table only
        setBorder(new javax.swing.border.TitledBorder(null, "Data", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Arial", 0, 11), new java.awt.Color(0, 0, 153)));
 
    }
    
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jScrollPane1 = new javax.swing.JScrollPane(table[0]);
        table1Title = new javax.swing.JLabel();
        jScrollPane2 = new javax.swing.JScrollPane(table[1]);
        table2Title = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        setBackground(new java.awt.Color(255, 255, 255));
        jScrollPane1.setBackground(new java.awt.Color(255, 255, 255));
        jScrollPane1.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED));
        jScrollPane1.setMinimumSize(new java.awt.Dimension(300, 150));
        jScrollPane1.setPreferredSize(new java.awt.Dimension(300, 200));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weighty = 0.4;
        add(jScrollPane1, gridBagConstraints);

        table1Title.setFont(new java.awt.Font("Arial", 0, 12));
        table1Title.setForeground(new java.awt.Color(51, 0, 153));
        table1Title.setText("Table 1");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weighty = 0.05;
        add(table1Title, gridBagConstraints);

        jScrollPane2.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED));
        jScrollPane2.setMinimumSize(new java.awt.Dimension(300, 150));
        jScrollPane2.setPreferredSize(new java.awt.Dimension(300, 200));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weighty = 0.4;
        add(jScrollPane2, gridBagConstraints);

        table2Title.setFont(new java.awt.Font("Arial", 0, 12));
        table2Title.setForeground(new java.awt.Color(51, 0, 153));
        table2Title.setText("Table 2");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weighty = 0.05;
        add(table2Title, gridBagConstraints);

        jScrollPane1.addMouseListener(new tables0MouseAdapter());  // popup menu on second table only
        jScrollPane2.addMouseListener(new tables1MouseAdapter());  // popup menu on second table only

    }//GEN-END:initComponents
  
    public java.awt.Insets getInsets() {
        return new java.awt.Insets(10,10,10, 10);
    }
    
    public void tableChanged(javax.swing.event.TableModelEvent e) {
        table1Title.setText((table1==null) ? "" : table1+" : "+Integer.toString(resultTable[0].getRowCount()));
        table2Title.setText((table2==null) ? "" : table2+" : "+Integer.toString(resultTable[1].getRowCount()));
    }
    public void setTableTitles(String title1, String title2) {
        table1=title1;
        table2=title2;
        table1Title.setText((title1==null) ? "" : table1+" : "+Integer.toString(resultTable[0].getRowCount()));
        table2Title.setText((title2==null) ? "" : table2+" : "+Integer.toString(resultTable[1].getRowCount()));        
    }
    public int getRowCount(int table) {
        if(resultTable[table]==null) return 0;
        return resultTable[table].getRowCount();
        }
    public void setTable1Title(String title) {
        table2 = new String(title);
        table2Title.setText(table2+" : "+Integer.toString(resultTable[1].getRowCount()));        
    }  
    public void refresh(int thisModuleGroup, java.util.Vector tableContents) {
        selectionListenerIsActive=false;
        resultTable[thisModuleGroup].reTable(tableContents);
        selectionListenerIsActive=true;
        javax.swing.table.TableColumn column = table[thisModuleGroup].getColumnModel().getColumn(0);
        column.setPreferredWidth(100);
        }
    public void refresh(Vector[] tableContents, int table0RowSelect, int table1RowSelect) {
        selectionListenerIsActive=false;
        
        for(int i=0;i<2;i++) {
               resultTable[i].reTable(tableContents[i]);
                javax.swing.table.TableColumn column = table[i].getColumnModel().getColumn(0);
                column.setPreferredWidth(110);
                }
        selectionListenerIsActive=true;
        if(table0RowSelect!=-1) rowSM[0].setSelectionInterval(table0RowSelect,table0RowSelect);
        if(table1RowSelect!=-1) rowSM[1].setSelectionInterval(table1RowSelect,table1RowSelect);
        }
    public void refresh1(Vector newObjectNames, Vector tableContents, String title) {
        int oldSelect = rowSM[1].getMinSelectionIndex();
        objectNames[1] = new Vector(newObjectNames);
        selectionListenerIsActive=false;
        resultTable[1].reTable(tableContents);
        if(oldSelect>=0 && oldSelect<=tableContents.size()-1) rowSM[1].setSelectionInterval(oldSelect,oldSelect);
        selectionListenerIsActive=true;
        javax.swing.table.TableColumn column = table[1].getColumnModel().getColumn(0);
        column.setPreferredWidth(110);       
        setTable1Title(title); 
        }
    public void refresh1(Vector tableContents, String title) {   // no update of objectNames[1]
        selectionListenerIsActive=false;
        int oldSelect = rowSM[1].getMinSelectionIndex();
        resultTable[1].reTable(tableContents);
        if(oldSelect>=0 && oldSelect<=tableContents.size()-1) rowSM[1].setSelectionInterval(oldSelect,oldSelect);
        selectionListenerIsActive=true;
        javax.swing.table.TableColumn column = table[1].getColumnModel().getColumn(0);
        column.setPreferredWidth(110);       
        setTable1Title(title); 
        }


    public String getSelectedObject() {
       return getSelectedObject(1);
       }

    public String getSelectedObject(int tableIndex) {
        int selectedRow = rowSM[tableIndex].getMinSelectionIndex();
        if(objectNames[tableIndex]==null) return null;
        int arraySize = objectNames[tableIndex].size();
        if(selectedRow==-1 || arraySize==0 || selectedRow>arraySize-1) return null;
        return (String)objectNames[tableIndex].elementAt(selectedRow);
        }
    public String getSelectedSerialNo() {
        int selectedRow = rowSM[1].getMinSelectionIndex();
        if(selectedRow==-1) return null;
        return (String)resultTable[1].getValueAt(selectedRow,0);
        }
    public void setSelectedSerialNo(String sn, boolean changeSelection) {
        int is = rowSM[1].getMinSelectionIndex();
        if(is!=-1 && !changeSelection) return;
        for(int i=0;i<resultTable[1].getRowCount();i++) {
           if(sn.equals((String)resultTable[1].getValueAt(i,0))) {
                       rowSM[1].setSelectionInterval(i,i); 
                       break;
                       }
           }

       }
              

    public int getSelectedTest() {
        return rowSM[0].getMinSelectionIndex();
        }
    public Vector getTestControlObjectNames() {
        return objectNames[0];
       }
    public String getTestControlObjectName() {
        int selectedRow = rowSM[0].getMinSelectionIndex();
        if(selectedRow==-1) return null;
        if(objectNames[0]==null) return null;
        if(selectedRow>=objectNames[0].size()) return null;
        return (String)objectNames[0].elementAt(selectedRow);
        }

    
    /** method required by ListSelectionListener interface */
    public void valueChanged(ListSelectionEvent e) {
              if(!selectionListenerIsActive) {
//                         selectionListenerIsActive=true;
                         return;
                         }

              if (e.getValueIsAdjusting()) return;

              ListSelectionModel lsm = (ListSelectionModel)e.getSource();
              int thisTable = (lsm==rowSM[0]) ? 0 : 1;
        
              if (lsm.isSelectionEmpty()) {
                 //no rows are selected
                  if(thisTable==0) {   
                       testSelection=null;
                       ivTestSelection=null;
                       guiControl.displayPane.setDisplayColors();
                       guiControl.displayPane.refreshDisplay();  
                       guiControl.selectorPane.initParamList();
                       }
                   return;
                   }

              int minRow=lsm.getMinSelectionIndex();
              int maxRow=lsm.getMaxSelectionIndex();   
              int nselected = maxRow-minRow+1;  

              int displayStatus=guiControl.displayStatus.getStatus();
              switch(displayStatus) {
                 case DisplayStatus.MODULE_GROUP_SELECTION:
                   if(nselected>0) lsm.setSelectionInterval(minRow,minRow);
                   if(thisTable==0) guiControl.selectorPane.setMouseClickIndex(minRow);
                   guiControl.displayPane.setDisplayColors();
                   guiControl.displayPane.refreshDisplay();
                   break;
                 case DisplayStatus.IS_MONITOR:
// if more than one row is selected, assume they want to delete them
                   if(nselected>1) {
                       int response = JOptionPane.showConfirmDialog(null,"Are you sure you want to delete these "+nselected+" objects from IS?","Confirm Deletion Request",JOptionPane.YES_NO_OPTION,JOptionPane.QUESTION_MESSAGE);
                       if(response==JOptionPane.NO_OPTION) {
                             lsm.setSelectionInterval(minRow,minRow);
                             return; 
                             }
                     // delete the objects
                       if(thisTable==0) guiControl.isInterface.removeTests(objectNames[0],minRow,maxRow);
//                     else deleteSelectedDataObjects();
                       updateTables();
                       return;
                       } 
                    if(thisTable!=0) return;
                    if(objectNames[0]!=null && objectNames[0].size()>0) testSelection = new TestSelection((String)objectNames[0].elementAt(minRow),guiControl.isInterface.getLocation());

                    String runScanRegex = testSelection.getRunScanRegex();
                    if(runScanRegex!=null) guiControl.isInterface.setISCounter(runScanRegex);
//                    guiControl.isInterface.setTestFilter((String)objectNames[0].elementAt(minRow)); 
                    guiControl.selectorPane.initParamList(); // maybe require change of parameter menu

                    if(testSelection.isRetrievedData()) checkForRetrievedObjects();

                    guiControl.colorScalePane.setColorScale(); 
                    guiControl.displayPane.setDisplayColors();      
                    ModuleCell lastClickedCell;
                    if((lastClickedCell=guiControl.displayPane.getLastClickedCell())!=null) listISObjects(lastClickedCell);
                    guiControl.displayPane.refreshDisplay();
                    break;
                 case DisplayStatus.TEST_DATA:
                if(thisTable!=0) return; // only interest in changes to the first table 
                    if(objectNames[0]!=null && objectNames[0].size()>0) testSelection = new TestSelection((String)objectNames[0].elementAt(minRow),guiControl.isInterface.getLocation());
//                   guiControl.isInterface.setTestFilter((String)objectNames[0].elementAt(minRow)); 
                   guiControl.selectorPane.initParamList(); // maybe require change of parameter menu

                   if(testSelection.isRetrievedData()) checkForRetrievedObjects(2);   // publish test data object, if not already done

                   guiControl.colorScalePane.setColorScale(); 
                   guiControl.displayPane.setDisplayColors();      
                   guiControl.displayPane.refreshDisplay();
                   listTestResults();
                   break;
                 case DisplayStatus.SCTDB_DATA:
                 case DisplayStatus.SCTDB_RODDAQ_DATA:
                   if(thisTable!=0) return; // only interest in changes to the first table 
                    if(objectNames[0]!=null && objectNames[0].size()>0) testSelection = new TestSelection((String)objectNames[0].elementAt(minRow),guiControl.isInterface.getLocation());
//                   guiControl.isInterface.setTestFilter((String)objectNames[0].elementAt(minRow)); 
                   guiControl.selectorPane.initParamList(); // maybe require change of parameter menu
                   guiControl.colorScalePane.setColorScale(); 
                   guiControl.displayPane.setDisplayColors();      
                   guiControl.displayPane.refreshDisplay();
                   listTestResults();
                   break;
                 case DisplayStatus.IV_DATA:
                   if(thisTable!=0) return; // only interest in changes to the first table 
                   if(objectNames[0]!=null && objectNames[0].size()>0) ivTestSelection = new IVTestSelection((String)objectNames[0].elementAt(minRow));
                   guiControl.selectorPane.initParamList(); // maybe require change of parameter menu
                   guiControl.colorScalePane.setColorScale(); 
                   guiControl.displayPane.setDisplayColors();      
                   guiControl.displayPane.refreshDisplay();
                   listTestResults();
                   break;
                  default:
                 }
            }

    public TestSelection getTestSelection() {
           return testSelection;
           }
    public IVTestSelection getIVTestSelection() {
           return ivTestSelection;
           }

    public void listISObjects(ModuleCell thisCell) {
       String title = "No module selected";

       if(thisCell!=null) {
            title =guiControl.selectorPane.getDisplayParameter()+" for "+thisCell.getSerialNo();
            refresh1(getISTableList(thisCell),title);
            }
        }

    public Vector getISTableList(ModuleCell thisCell) {

       Vector theLine;
       java.util.SortedMap m = new java.util.TreeMap();

       if(thisCell!=null && testSelection!=null && testSelection.getRunScanRegex()!=null) {
       String thisSN = thisCell.getSerialNo();
       java.util.List isList = (java.util.List)guiControl.isInterface.isCounter.getModuleList(guiControl.selectorPane.getDisplayParameterIndex(),testSelection.getRunScanRegex(),thisSN,testSelection.isRetrievedData());
       if(isList==null) objectNames[1] = new Vector();
       else {
         objectNames[1] = new Vector(isList);
         for(int i=0;i<objectNames[1].size();i++) {
            String[] objectParts = ((String)objectNames[1].elementAt(i)).split("\\.");
            theLine = new Vector();
            String sn = objectParts[4];
            Integer runNo = Integer.valueOf(objectParts[2]);
            Integer scanNo = Integer.valueOf(objectParts[3]);
            String fname = objectParts[1];
            theLine.add(sn);
            theLine.add(runNo);
            theLine.add(scanNo);
            theLine.add(fname);
            m.put(new Integer(runNo.intValue()*10000 + scanNo.intValue()),theLine);
            }
          }
         }
         Vector tableContents = new Vector(m.values());
         theLine=new Vector();
         theLine.addElement("Serial No");
         theLine.addElement("Run No");
         theLine.addElement("Scan No");
         theLine.addElement("Data");
         tableContents.insertElementAt(theLine,0);
         return tableContents;
        }
     public void listTestResults() {

        int status = guiControl.displayStatus.getStatus();
        int displayParameter = guiControl.selectorPane.getDisplayParameterIndex();
        String testParameter = (displayParameter==2 && status!=DisplayStatus.DCS_DATA) ? guiControl.selectorPane.getOption() : guiControl.selectorPane.getDisplayParameter();
        if(status==DisplayStatus.IV_DATA) {
              if(ivTestSelection==null) return;
              switch(displayParameter) {
                case 1:
                 testParameter = guiControl.selectorPane.getIVParameter();
                 break;
                case 2:                 
                 testParameter = guiControl.selectorPane.getOption();
                 break;
                default:
                 testParameter = guiControl.selectorPane.getDisplayParameter();
                }
              }
        else if(status!=DisplayStatus.DCS_DATA && testSelection==null) return;

        java.util.Set moduleList = guiControl.config.getSortedVector(guiControl.displayPane.getSCTView());
        int index = guiControl.selectorPane.getMouseClickIndex();
        Vector theLine = new Vector();
        Vector table = new Vector();
        Vector objectsVector = new Vector();
        theLine.addElement("Serial No");
        switch(status) {
           case DisplayStatus.SCTDB_DATA:
            theLine.addElement("Location");
            theLine.addElement("Date");
            break;
           case DisplayStatus.SCTDB_RODDAQ_DATA:
              theLine.addElement("Date");
             break;
           default:
           }
        theLine.addElement(testParameter);
        table.addElement(theLine);

        SummaryReader.Test testResult;

        for (java.util.Iterator i = moduleList.iterator(); i.hasNext(); ) {
           String thisSN=(String)i.next();

                 ModuleCell thisCell = (ModuleCell)guiControl.config.getModuleCell(guiControl.displayPane.getSCTView(),thisSN);
                 theLine=new Vector();
                 theLine.addElement(thisSN);

                 switch(status) {
                   case DisplayStatus.SCTDB_DATA:
                     if(testSelection.getSCTDBObjectHeader()==null) continue;
                     testResult = guiControl.isInterface.getSCTDBTest(testSelection.getSCTDBObjectHeader()+thisSN);
                     if(testResult==null) {
                       theLine.addElement(" - ");
                       theLine.addElement(" - ");
                       }
                     else {
                       theLine.addElement(testResult.getDAQInfo().get(SummaryReader.DAQInfo.LOCATION));
                       theLine.addElement(testResult.getDAQInfo().get(SummaryReader.DAQInfo.DATE));
                       }
                     break;
                   case DisplayStatus.SCTDB_RODDAQ_DATA:
                     testResult = guiControl.isInterface.getSCTDBTest(testSelection.getSCTDBRodDaqObjectHeader()+thisSN);
                     if(testResult==null) theLine.addElement(" - ");
                     else theLine.addElement(testResult.getDAQInfo().get(SummaryReader.DAQInfo.DATE));
                     break;
                   default:
                   }

                 ColorScale thisColorScale;
                 if((thisColorScale = guiControl.colorScalePane.getColorScale())!=null) theLine.addElement(thisColorScale.getLabel(thisCell.getData()));
                 else theLine.addElement("No Data");
                 table.addElement(theLine);
                 }      
          String title = (status==DisplayStatus.TEST_DATA && guiControl.displayPane.getDisplayOption()==2) ? testParameter+" Comparisons" : testParameter+" Results ";
          refresh1(objectsVector,table,title);     
         }   

    public void updateTables(boolean keepSelections) {
         changeTables(keepSelections);
         }
    public void updateTables() {
         changeTables(!guiControl.menuBar.autoSelectMode.isSelected());
         }

    private void changeTables(boolean keepSelections) {

      testSelection=null;
      ivTestSelection=null;

      Vector theLine = new Vector();
      int table0Select=-1;
      int table1Select=-1;
      String selectedObject0 = getSelectedObject(0);
      String selectedObject1 = getSelectedObject(1);
      if(keepSelections) {
        table0Select = (selectedObject0!=null) ? objectNames[0].indexOf(selectedObject0) : -1;
        }
      table1Select = (selectedObject1!=null) ? objectNames[1].indexOf(selectedObject1) : -1;
        
      String title0=null;
      String title1=null;
      Vector[] tableContents = new Vector[2];
      tableContents[0] = new Vector();
      tableContents[1] = new Vector();

      int previousSelection = keepSelections ? getSelectedTest() : -1;

      int view = guiControl.displayPane.getSCTView();

      switch(guiControl.displayStatus.getStatus()) {
          case DisplayStatus.MODULE_GROUP_SELECTION :
             title0 = "ModuleGroups";
             String option = guiControl.selectorPane.getOption();
             title1 = (option!=null) ? option+" modules" : null;
             theLine.addElement("Serial No");
             String title = (view<4) ? "Row" : "Quadrant";
             theLine.addElement(title);
             theLine.addElement("Posn");
             theLine.addElement("MUR");
             tableContents[1].addElement(theLine);
             theLine = new Vector();
             theLine.addElement("Group");
             theLine.addElement("# Modules");
             tableContents[0].addElement(theLine);

             java.util.Set moduleList = guiControl.config.getSortedVector(view);
             java.util.Map groupCounts = new java.util.HashMap();

             int selectedGroup = guiControl.selectorPane.getMouseClickIndex();
             table0Select = selectedGroup;
             for (java.util.Iterator i = moduleList.iterator(); i.hasNext(); ) {
               String thisSN=(String)i.next();
               ModuleCell thisCell = (ModuleCell)guiControl.config.getModuleCell(view,thisSN);
               int thisGroup = thisCell.getModuleGroup();
               if(thisGroup<0) continue;

               Integer iThisGroup = new Integer(thisGroup);
               Integer c;
               if((c = (Integer)groupCounts.get(iThisGroup))==null) groupCounts.put(iThisGroup,new Integer(1));
               else groupCounts.put(iThisGroup,new Integer(c.intValue()+1));

               if(thisGroup!=selectedGroup) continue;
               theLine = new Vector();
               theLine.addElement(thisSN);
               if(view<4) {
                    theLine.addElement(Integer.toString(thisCell.getRow()));
                    theLine.addElement(Integer.toString(thisCell.getPosition()));
                    }
               else {
                    theLine.addElement(thisCell.getQuadrant());
                    theLine.addElement(thisCell.getEndCapPosition());
                    }

               theLine.addElement(Integer.toString(thisCell.getMUR()));
               tableContents[1].addElement(theLine);
               }
               for(int i=0;i<8;i++) {
                  theLine = new Vector();
                  theLine.addElement("ModuleGroup "+i);
                  Integer c;
                  if((c=(Integer)groupCounts.get(new Integer(i)))==null) theLine.addElement(new Integer(0));
                  else theLine.addElement(c);
                  tableContents[0].addElement(theLine);
                  }
             break;
           case DisplayStatus.IS_MONITOR:
               title0 = "Tests";
               title1 = guiControl.selectorPane.getDisplayParameter();
               tableContents[1] = getISTableList(guiControl.displayPane.getLastClickedCell());
               tableContents[0] = getTestTableList();             
               break;
           case DisplayStatus.IV_DATA:
               title0 = "IV scans";
               title1 = "IV Data";
               tableContents[0] = getIVScanList();
               theLine = new Vector();
               theLine.addElement("Serial No");
               theLine.addElement(guiControl.selectorPane.getIVParameter());
               tableContents[1].addElement(theLine);
               break;
           case DisplayStatus.TEST_DATA:
           case DisplayStatus.SCTDB_DATA:
           case DisplayStatus.SCTDB_RODDAQ_DATA:
               int testType = guiControl.isInterface.getListFilterIndex();
               title0 = (testType==-1) ? "Number of Tests " : "Number of "+testMenuNames[testType]+" Tests ";
               String testParameter = guiControl.selectorPane.getDisplayParameter();
               title1 = testParameter+ " Results";
               theLine = new Vector();
               theLine.addElement("Serial No");
               theLine.addElement(testParameter);
               tableContents[1].addElement(theLine);
               tableContents[0]=getTestTableList();
               if(tableContents[0].size()>1) {
                     if(previousSelection<=tableContents[0].size()-2 && previousSelection>=0) table0Select=previousSelection;
                     else table0Select=tableContents[0].size()-2; // remember titles!!   
                     }

               break;
           case DisplayStatus.DCS_DATA:
               table0Select=-1;
               table1Select=-1;
               title0 = "Server Info";
               title1 = guiControl.selectorPane.getDisplayParameter()+ " Data";
               theLine = new Vector();
               theLine.addElement("Serial No");
               theLine.addElement(guiControl.selectorPane.getDisplayParameter());
               tableContents[1].addElement(theLine);
               theLine = new Vector();
               theLine.addElement("Server");
               theLine.addElement("Last Update");
               tableContents[0].addElement(theLine);
               theLine = new Vector();
               theLine.addElement(Preferences.PreferencesInterface.getInstance().getPreference(Preferences.PreferencesInterface.DCS_SERVER_NAME));
               theLine.addElement(guiControl.isInterface.isRequestBuffer.getLastUpdateTime());
               tableContents[0].addElement(theLine);
               break;
           default:
               return;
              }      
        if(table0Select==-1 && tableContents[0].size()>1) table0Select=tableContents[0].size()-2; // remember titles!!  
        if(table1Select==-1 && tableContents[1].size()>1) table1Select=tableContents[1].size()-2; // remember titles!!  
        refresh(tableContents,table0Select,table1Select);
        setTableTitles(title0,title1);

        if(getSelectedTest()==-1) {  // no test now selected, so need to update display manually (otherwise selection listener would do it)
//              guiControl.isInterface.setTestFilter(null);
              testSelection=null;
              ivTestSelection=null;
              guiControl.displayPane.setDisplayColors();
              guiControl.displayPane.refreshDisplay();
              guiControl.selectorPane.initParamList();
               }
// for DCS, there is no selection in the test table that will fill the bottom table, so do it here manually
        if(guiControl.displayStatus.getStatus()==DisplayStatus.DCS_DATA) {
              testSelection=null;
              ivTestSelection=null;
              guiControl.displayPane.setDisplayColors();
              guiControl.displayPane.refreshDisplay();
              listTestResults();
              }
    }

    public void setTestTable(Vector ISTests) {
           objectNames[0] = ISTests;
           updateTables(true);
           }
    public void addNewTest(String theObjectName) {
           if(objectNames[0]==null) return;
           if(!objectNames[0].contains(theObjectName)) objectNames[0].addElement(theObjectName);
           }
    public void removeTest(String theObjectName) {
           if(objectNames[0].contains(theObjectName)) {
                objectNames[0].removeElement(theObjectName);
                updateTables(true);
                }
           }

   public Vector getTestTableList() {
// generate the test table list ordered by run numer and scan number
       Vector theLine = new Vector();        // each line of the table
       Vector tableContent = new Vector();   // vector of table lines
       Vector orderVector = new Vector();      // vector for re-ordering based on runno and scanno
       Hashtable orderHash = new Hashtable();// hashtable to map order runno/scanno to table lines
       Hashtable objectOrderHash = new Hashtable();

       theLine.addElement("Test");
       theLine.addElement("Status");
       theLine.addElement("Run");
       theLine.addElement("Scan");
       theLine.addElement("#Scans");
       theLine.addElement("Source");
       tableContent.addElement(theLine);
       int exceptionCount=0;
       for(int i=0;i<objectNames[0].size();i++) {
           String thisObject = (String)objectNames[0].elementAt(i);
           TestData testData = new TestData(); 
           try {
           is.getRepository().getValue(thisObject, testData); 
           theLine=new Vector();
           if(testData.testName.equals("NPtGainTest") && testData.nScans==3) testData.testName = "3PtGainTest";
           theLine.addElement(testData.testName);
           switch(testData.status) {
             case 0:
                 theLine.addElement("Executing");
                 break;
             case 1:
                 theLine.addElement("Completed");
                 break;
             case 2:
                 theLine.addElement("Aborted");
                 break;
             default:
                 theLine.addElement("Unknown");
             }
           theLine.addElement(new Integer(testData.runNumber));
           theLine.addElement(new Integer(testData.startScanNumber));
           theLine.addElement(new Integer(testData.nScans));

           int offsetCount = (thisObject.matches("RetrievedData.*")) ? 0 : 100000000;
           Integer runScanNumber = new Integer(testData.runNumber*10000 + testData.startScanNumber +offsetCount); 

           if(thisObject.matches("RetrievedData.*")) theLine.addElement("Archive");
           else if(thisObject.matches("SCTDBData.*")) theLine.addElement("SCTDB");
           else theLine.addElement("New");        

           orderVector.addElement(runScanNumber);
           orderHash.put(runScanNumber,theLine);
           objectOrderHash.put(runScanNumber,thisObject);
           }catch(Exception e){exceptionCount++;}

           }

       Collections.sort(orderVector);
       objectNames[0]=new Vector();
       for(int i=0;i<orderVector.size();i++) {
            Integer runscan= (Integer)orderVector.elementAt(i);
            objectNames[0].addElement((String)objectOrderHash.get(orderVector.elementAt(i)));          // re-order object names appropriately
            tableContent.addElement((Vector)orderHash.get(orderVector.elementAt(i))); // and the same for the table entries
            }
       if(exceptionCount>0) System.err.println("SctGUI::TablesDisplayPane - exception reading retrieving IS data.");
       return tableContent;
    }

   public Vector getIVScanList() {
// generate the test table list ordered by run numer and scan number
       Vector theLine = new Vector();        // each line of the table
       Vector tableContent = new Vector();   // vector of table lines
       Vector orderVector = new Vector();      // vector for re-ordering based on runno and scanno
       Hashtable orderHash = new Hashtable();// hashtable to map order runno/scanno to table lines
       Hashtable objectOrderHash = new Hashtable();

       theLine.addElement("Run");
       theLine.addElement("Scan");
       theLine.addElement("Date");
       theLine.addElement("Time");
       theLine.addElement("#Modules");
       theLine.addElement("Source");
       tableContent.addElement(theLine);
       for(int i=0;i<objectNames[0].size();i++) {
           String thisObject = (String)objectNames[0].elementAt(i);
           IVScanControl iv = new IVScanControl();
           is.getRepository().getValue(thisObject, iv); 
           theLine=new Vector();
           theLine.addElement(new Integer(iv.runNo));
           theLine.addElement(new Integer(iv.scanNo));
           theLine.addElement(iv.scanDate);
           theLine.addElement(iv.scanTime);
           theLine.addElement(new Integer(iv.modules.length));

           int offsetCount = (thisObject.matches("RetrievedData.*")) ? 0 : 100000000;
           Integer runScanNumber = new Integer(iv.runNo*10000 + iv.scanNo +offsetCount); 

           if(thisObject.matches("SCTDBData.*")) theLine.addElement("SCTDB");
           else theLine.addElement("DCS");        

           orderVector.addElement(runScanNumber);
           orderHash.put(runScanNumber,theLine);
           objectOrderHash.put(runScanNumber,thisObject);

           }

       Collections.sort(orderVector);
       objectNames[0]=new Vector();
       for(int i=0;i<orderVector.size();i++) {
            Integer runscan= (Integer)orderVector.elementAt(i);
            objectNames[0].addElement((String)objectOrderHash.get(orderVector.elementAt(i)));          // re-order object names appropriately
            tableContent.addElement((Vector)orderHash.get(orderVector.elementAt(i))); // and the same for the table entries
            }
       return tableContent;
    }

    public void updateTest(String testObjectName) {
           if(objectNames[0]==null) return;
           if(!objectNames[0].contains(testObjectName)) return;
           int rowNumber=objectNames[0].indexOf(testObjectName);
           try {
           TestData testData = new TestData(); 
           Sct.IS.SctNames.getISRepository().getValue(testObjectName, testData); 
           switch(testData.status) {
               case 0:
                 resultTable[0].setValueAt("Executing",rowNumber,1);
                 break;
               case 1:
                 resultTable[0].setValueAt("Completed",rowNumber,1);
                 break;
               case 2:
                 resultTable[0].setValueAt("Aborted",rowNumber,1);
                 break;
               default:
                 resultTable[0].setValueAt("Unknown",rowNumber,1);
               }
             resultTable[0].fireTableCellUpdated(rowNumber,1);
             if(testData.status==1 && guiControl.menuBar.autoUploadIsEnabled() && !testData.testName.equals("NMaskTest")) {
                    UploadManager upload = new UploadManager(guiControl);  // upload the data!
                    }
            }catch(Exception updateE){System.err.println("***ERROR updating test status in table list : "+updateE.toString());}
           
         }

    public void updateTestTable(String testObjectName, int rowNumber) {
           if(rowNumber==-1) return;
           try {
           TestData testData = new TestData(); 
           Sct.IS.SctNames.getISRepository().getValue(testObjectName, testData); 
           switch(testData.status) {
               case 0:
                 resultTable[0].setValueAt("Executing",rowNumber,1);
                 break;
               case 1:
                 resultTable[0].setValueAt("Completed",rowNumber,1);
                 break;
               case 2:
                 resultTable[0].setValueAt("Aborted",rowNumber,1);
                 break;
               default:
                 resultTable[0].setValueAt("Unknown",rowNumber,1);
               }
             resultTable[0].fireTableCellUpdated(rowNumber,1);
            }catch(Exception updateE){System.err.println("***ERROR updating test status in table list : "+updateE.toString());}
         }


    class tables1MouseAdapter extends java.awt.event.MouseAdapter {
            public void mouseClicked(java.awt.event.MouseEvent e) {
               switch(e.getModifiers()) {
                 case java.awt.event.InputEvent.BUTTON2_MASK:
                 case java.awt.event.InputEvent.BUTTON3_MASK:
                       int rowSelect = table[1].rowAtPoint(new java.awt.Point(e.getX(),e.getY()));
                       rowSM[1].setSelectionInterval(rowSelect,rowSelect);
                       if(rowSelect>=0) {
                         guiControl.menuBar.setSelectedSerialNo((String)resultTable[1].getValueAt(rowSelect,0));                       
                         guiControl.menuBar.showTablesPopupMenu(1,e);
                         }
                       break;
                 default:
                 }
            }
    }
    class tables0MouseAdapter extends java.awt.event.MouseAdapter {
            public void mouseClicked(java.awt.event.MouseEvent e) {
               switch(e.getModifiers()) {
                 case java.awt.event.InputEvent.BUTTON2_MASK:
                 case java.awt.event.InputEvent.BUTTON3_MASK:
                       int rowSelect = table[0].rowAtPoint(new java.awt.Point(e.getX(),e.getY()));
                       rowSM[0].setSelectionInterval(rowSelect,rowSelect);  
                       guiControl.menuBar.showTablesPopupMenu(0,e);
                       break;
                 default:
                 }
            }
    }
    public void checkForRetrievedObjects() {
         checkForRetrievedObjects(-1);
         }

    public void checkForRetrievedObjects(int serverIndex) {
         if(testSelection==null || !testSelection.isRetrievedData()) return;
         if(serverIndex==-1) serverIndex = guiControl.selectorPane.getDisplayParameterIndex();
         if(guiControl.isInterface.isCounter.archivedObjectsRetrievedOk(serverIndex,testSelection.getRunScanRegex())) return;
         System.out.println("SctGUI - Retrieving archived data files...");
         String oName;
         switch(serverIndex) {
                          case 1:
                              oName = "SctData::FitScanResult";
                              break;
                          case 2:
                              oName = "SctData::*TestResult";
                              break;
                          default:
                              oName = "SctData::RawScanResult";
                              }
                      
         try {
//           System.out.println("retrieve("+testSelection.getRunNo()+","+testSelection.getScanNo()+","+oName+","+"*"+")");
           ArchivingServiceI.ArchivingServiceInterface a = SystemInterface.getInstance().getArchivingService(); 
           int scan=testSelection.getScanNo(); 
           if(serverIndex==2) a.retrieve(Integer.toString(testSelection.getRunNo()),Integer.toString(scan),oName,"*");
           else {
               for(int i = 0;i<testSelection.getNoScans();i++) a.retrieve(Integer.toString(testSelection.getRunNo()),Integer.toString(scan+i),oName,"*");
               }
         }catch(Exception e2) {System.err.println("SctGUI::TablesDisplayPane - Exception from retrieving from ArchiveService: "+e2.toString());}

              }



    
}
