package DisplayGUI;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

import java.util.*;

//SelectorPane itself is not a visible component.
public class SelectorPane extends JPanel implements ListSelectionListener,displayParams,SCTInfo,TestDataInfo {
    private JList displayParameters, sctViews, mouseOptions;
    private JSplitPane splitPane;
    private String[] defaultString = {"...None"};
    private String[] resultStatusString = {"Overall Status"};
    private String[] defectCountString = {"Total Count"};
    private String[][] displayParameterStrings = {
                          {},
                          {"Module Group"},
                          {"Raw Data","Fitted Data","Analysed Data"},
                          {},
                          {},
                          {},
                          {},
                          {"Result Status","IVScan Data","DCS Conditions"}
                       };
    private String[][] mouseOptionStrings = {
                         {},
                         {"Group 0","Group 1","Group 2","Group 3","Group 4","Group 5","Group 6","Group 7"},
                         {"List Data objects"},
                         {},
                         {},
                         {},
			 {"Current Conditions"}
                       };
    private gui guiControl;

    private boolean selectionListenerIsActive=true;

    private Map viewMap;


    public SelectorPane(gui parent) {
        guiControl=parent;

        buildViewMap();

        sctViews = new JList(SCTViewNames);
        sctViews.setFont(displayScaleFont);
        sctViews.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        int viewIndex=0;
        try {
         Preferences.PreferencesInterface prefs = Preferences.PreferencesInterface.getInstance();
         String preferredView = prefs.getPreference(Preferences.PreferencesInterface.SCT_VIEW);
         if(!preferredView.equals(Preferences.PreferencesInterface.unDefinedString)) {
            Integer i1 = (Integer)viewMap.get(preferredView);
            if(i1!=null) viewIndex = i1.intValue();
            }
        }catch(Exception e){}
        sctViews.setSelectedIndex(viewIndex);
        sctViews.addListSelectionListener(this);

        JScrollPane viewScrollPane = new JScrollPane(sctViews);
        JLabel header2 = new JLabel("Views");
        header2.setForeground(darkBlueColor);
        header2.setBackground(backgroundColor);
        header2.setFont(displayTextFont);
        viewScrollPane.setColumnHeaderView(header2);
        viewScrollPane.getColumnHeader().setBackground(backgroundColor);
        viewScrollPane.setBorder(new javax.swing.border.EmptyBorder(0,0,0,0));
        viewScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        viewScrollPane.getVerticalScrollBar().setBackground(backgroundColor);

        displayParameters = new JList();
        displayParameters.setFont(displayScaleFont);
        displayParameters.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

        displayParameters.addListSelectionListener(this);
        JScrollPane paramScrollPane = new JScrollPane(displayParameters);
        JLabel header1 = new JLabel("Display Data");
        header1.setForeground(darkBlueColor);
        header1.setBackground(backgroundColor);
        header1.setFont(displayTextFont);
        paramScrollPane.setColumnHeaderView(header1);
        paramScrollPane.getColumnHeader().setBackground(backgroundColor);
        paramScrollPane.setBorder(new javax.swing.border.EmptyBorder(0,0,0,0));
//        paramScrollPane.setBorder(BorderFactory.createLineBorder(Color.black));
        paramScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        paramScrollPane.getVerticalScrollBar().setBackground(backgroundColor);

        mouseOptions = new JList();
        mouseOptions.setFont(displayScaleFont);
        mouseOptions.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        mouseOptions.addListSelectionListener(this);
        JScrollPane mouseScrollPane = new JScrollPane(mouseOptions);
        JLabel header3 = new JLabel("Options");
        header3.setForeground(darkBlueColor);
        header3.setBackground(backgroundColor);
        header3.setFont(displayTextFont);
        mouseScrollPane.setColumnHeaderView(header3);
        mouseScrollPane.getColumnHeader().setBackground(backgroundColor);
        mouseScrollPane.setBorder(new javax.swing.border.EmptyBorder(0,0,0,0));
        mouseScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        mouseScrollPane.getVerticalScrollBar().setBackground(backgroundColor);

        //Create a split pane with the two scroll panes in it
        JSplitPane topSplit = new JSplitPane(JSplitPane.VERTICAL_SPLIT, paramScrollPane, mouseScrollPane);
        topSplit.setDividerSize(8);
        topSplit.setDividerLocation(0.50);
        topSplit.setBorder(new javax.swing.border.EmptyBorder(0,0,0,0));

        splitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT,
                                   topSplit, viewScrollPane);
//        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(0.65);
        splitPane.setDividerSize(8);
        splitPane.setBorder(new javax.swing.border.EmptyBorder(0,0,0,0));

        //Provide minimum sizes for the two components in the split pane
        Dimension minimumSize = new Dimension(95, 16);
        paramScrollPane.setMinimumSize(minimumSize);
        mouseScrollPane.setMinimumSize(minimumSize);
        viewScrollPane.setMinimumSize(minimumSize);

        //Provide a preferred size for the split pane
        splitPane.setPreferredSize(new Dimension(95,yOffSet+56*boxHeight)); 
        add(splitPane);
        setBackground(backgroundColor);
        setBorder(new javax.swing.border.TitledBorder(null, "Display", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Arial", 0, 11), new java.awt.Color(0, 0, 153)));
//        setContentPane(splitPane);

//        pack();
//        setVisible(true);

    }
    public void initParamList() {

        selectionListenerIsActive=false;

        int displayType = guiControl.displayStatus.getStatus();
        boolean noParameters=true, noOptions=true;
        int previousParameterSelection = getDisplayParameterIndex();
        int previousOptionSelection = getMouseClickIndex();
        TestSelection testSelection = guiControl.tablesDisplayPane.getTestSelection();
        int testIndex = (testSelection!=null) ? testSelection.getTestIndex() : -1;

        if(displayType==DisplayStatus.UNDEFINED) return;
        switch(displayType) {
            case DisplayStatus.MODULE_GROUP_SELECTION:
            case DisplayStatus.IS_MONITOR:
               displayParameters.setListData(displayParameterStrings[displayType]);
               mouseOptions.setListData(mouseOptionStrings[displayType]);
               noParameters=false;
               noOptions=false;
               break;
            case DisplayStatus.TEST_DATA:
	    case DisplayStatus.SCTDB_DATA:
	    case DisplayStatus.SCTDB_RODDAQ_DATA:
               if(testIndex!=-1 && testIndex!=TEST_DEFAULT) {
                    displayParameters.setListData(testParameters[testIndex]);
                    noParameters=false;
                    switch(previousParameterSelection) {
                    case 0: // Result Status
                    case -1: // no previous selection - will be set to 0 by default
                        mouseOptions.setListData(resultStatusString);
                        noOptions=false;
                        break;
                    case 1: // Result Status
                        mouseOptions.setListData(defectCountString);
                        noOptions=false;
                        break;
                    case 2:                      
                        mouseOptions.setListData(dcsOptions);
                        noOptions=false;
                        break;
                    default:
                        if(testIndex==TEST_RXTHRESHOLD || testIndex==TEST_RXDELAY) mouseOptions.setListData(linkOptions);
                        else mouseOptions.setListData(chipOptions);
                        noOptions=false;
                        }
                    }

               break;
            case DisplayStatus.DCS_DATA:
               displayParameters.setListData(dcsOptions);
               noParameters=false;
               mouseOptions.setListData(mouseOptionStrings[displayType]);
               noOptions=false;
               break;
            case DisplayStatus.IV_DATA:
               IVTestSelection iv = guiControl.tablesDisplayPane.getIVTestSelection();
               if(iv==null) {
                 displayParameters.setListData(defaultString);
                 noParameters=true;
                 mouseOptions.setListData(defaultString);
                 noOptions=true;
                 }
              else {
                 displayParameters.setListData(displayParameterStrings[displayType]);
                 noParameters=false;
                 switch(previousParameterSelection) {
                    case 0:
                    case -1: // no previous selection - will be set to 0 by default
                        mouseOptions.setListData(resultStatusString);
                        noOptions=false;
                        break;
                    case 1:                      
                        mouseOptions.setListData(iv.getVList());
                        noOptions=false;
                        break;
                    case 2:                      
                        mouseOptions.setListData(dcsOptions);
                        noOptions=false;
                        break;
                        }
                 }
               break;

            case DisplayStatus.UNDEFINED:
            default:
              displayParameters.setListData(defaultString);
              mouseOptions.setListData(defaultString);
            }

        int numParameters = displayParameters.getModel().getSize();
        int selectionIndex=0;  
 
        if(numParameters>0) {
           if(previousParameterSelection<numParameters && previousParameterSelection>=0) selectionIndex=previousParameterSelection;
           else if(previousParameterSelection>=numParameters) selectionIndex =displayParameters.getLastVisibleIndex();
           }
        displayParameters.setSelectedIndex(selectionIndex);

        numParameters = mouseOptions.getModel().getSize();
        selectionIndex=0;
        if(numParameters>0) {
            if(previousOptionSelection<numParameters && previousOptionSelection>=0) selectionIndex= previousOptionSelection;
            else if(previousOptionSelection>=numParameters) selectionIndex = mouseOptions.getLastVisibleIndex();
            }
        mouseOptions.setSelectedIndex(selectionIndex);

        if(noParameters) displayParameters.setListData(defaultString);
        if(noOptions) mouseOptions.setListData(defaultString);
        setVisible(true);
        selectionListenerIsActive=true;
    }
   public String getIVParameter() {
     if(getDisplayParameterIndex()==0) return "Result Status";
     return getOption();
     }

   public int getDisplayParameterIndex() {
     return displayParameters.getSelectedIndex();
     }
   public int getMouseClickIndex() {
     return mouseOptions.getSelectedIndex();
     }
   public void setMouseClickIndex(int row) {
     mouseOptions.setSelectedIndex(row);
     }
   public int getViewIndex() {
     return sctViews.getSelectedIndex();
     }
   public String getOption() {
      if(getMouseClickIndex()==-1) return null;
      return (String)mouseOptions.getSelectedValue();
      }
   public String getDisplayParameter() {
     if(getDisplayParameterIndex()==-1) return null;
     return (String)displayParameters.getSelectedValue();
     }

    public JSplitPane getSplitPane() {
        return splitPane;
    }

    public void valueChanged(ListSelectionEvent e) {

        if (e.getValueIsAdjusting())
            return;

        JList theList = (JList)e.getSource();
        if (theList.isSelectionEmpty()) {
              // huh?
        } else {
        if(!selectionListenerIsActive) {
//             selectionListenerIsActive=true;
             return;
             }
            int index = theList.getSelectedIndex();
            if(theList==sctViews) {
                   guiControl.displayPane.setSCTView(index);
                   return;
                   }
            switch(guiControl.displayStatus.getStatus()) {
            case DisplayStatus.MODULE_GROUP_SELECTION:
               guiControl.tablesDisplayPane.updateTables(true);
               break;
            case DisplayStatus.IS_MONITOR:
//              guiControl.isInterface.setServerName(index);

              guiControl.tablesDisplayPane.checkForRetrievedObjects();
              guiControl.colorScalePane.setColorScale();  
              guiControl.displayPane.setDisplayColors();    
              guiControl.displayPane.refreshDisplay();
              ModuleCell lastClickedCell;
              if((lastClickedCell=guiControl.displayPane.getLastClickedCell())!=null) guiControl.tablesDisplayPane.listISObjects(lastClickedCell);
              break;
           case DisplayStatus.TEST_DATA:
           case DisplayStatus.SCTDB_DATA:
	   case DisplayStatus.SCTDB_RODDAQ_DATA:
              if(theList==displayParameters) initParamList(); 
              guiControl.colorScalePane.setColorScale();
              guiControl.displayPane.setDisplayColors();
              guiControl.displayPane.refreshDisplay();
              guiControl.tablesDisplayPane.listTestResults();
	      break;
	   case DisplayStatus.DCS_DATA:
//	      if(theList==mouseOptions) { // must resubscribe, depending on which DCS data we are looking at
//	          guiControl.isInterface.unsubscribe();
//		  guiControl.isInterface.subscribe();
//		  }
	      guiControl.colorScalePane.setColorScale();
              guiControl.displayPane.setDisplayColors();
              guiControl.displayPane.refreshDisplay();
              guiControl.tablesDisplayPane.listTestResults();
              break;
	   case DisplayStatus.IV_DATA:
              if(theList==displayParameters) initParamList();                      
              guiControl.colorScalePane.setColorScale();
              guiControl.displayPane.setDisplayColors();
              guiControl.displayPane.refreshDisplay();
              guiControl.tablesDisplayPane.listTestResults();
	      break;
           default:
           }    

        }
    }
  private void buildViewMap() {
     viewMap = new HashMap();
     for(int i=0;i<SCTViewNames.length;i++) viewMap.put(SCTViewNames[i], new Integer(i));
     }
  public void setSCTView(String value) {
     if(!viewMap.containsKey(value)) return;
     sctViews.setSelectedIndex(((Integer)viewMap.get(value)).intValue());
     }


}
