package DisplayGUI;

import is.*;
import Sct.Serializable;
import Sct.IS.*;

/**
 *
 * @author  robinson
 */
public class IVTestSelection {

     String resultObjectHeader;   // the header of the control object name
     String testObjectName;
  
     IVScanControl iv;


     public IVTestSelection(String testObjectName) {
        
         this.testObjectName = testObjectName;

         try {
           iv = new IVScanControl(); 
           GuiComponents.System.ISInterface.getInstance().getRepository().getValue(testObjectName, iv); 
          }catch(Exception e2) {
              System.err.println("SctGUI::IVTestSelection : Exception extracting IVScan Control data : "+e2.toString());
              iv=null;
              }
          if(iv==null) resultObjectHeader=null;
          else resultObjectHeader = isSCTDBData() ? "SCTDBData.IVScanData."+Integer.toString(iv.runNo)+"."+Integer.toString(iv.scanNo)+"." : "RetrievedData.IVScanData."+Integer.toString(iv.runNo)+"."+Integer.toString(iv.scanNo)+".";
         } 


   public String getResultObjectHeader() {
          return resultObjectHeader;
          }
   public int getRunNo() {
         if(iv==null) return -1;
         else return iv.runNo;
         }
   public int getScanNo() {
         if(iv==null) return -1;
         else return iv.scanNo;
         }
   public String[] getVList() {
         return iv.voltageData;
         }

   public boolean isSCTDBData() {
       return testObjectName.startsWith("SCTDBData");
       }


}
       