/*
 * IVScanLister.java
 *
 * Created on 27 February 2004, 13:50
 */

package DisplayGUI;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import java.util.*;
import is.*;
import Sct.Serializable;
import Sct.IS.*;
import ProdDatabase.*;

/**
 *
 * @author  robinson
 */
public class IVScanLister extends javax.swing.JFrame implements displayParams, ListSelectionListener {
    
    DataList dataList;
    Map testMap;
    ListSelectionModel rowSM;
    int sctView;
    IVTestInterface ivTestInterface;

    private javax.swing.JButton jButton1;
    private javax.swing.JTable jTable;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JScrollPane jScrollPane1;

    /** Creates new form test */
    public IVScanLister(int sctView) {
        super("Import IV scans");
        this.sctView=sctView;
        initComponents();
        ivTestInterface = new IVTestInterface(sctView);

         refreshScanList();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {
       
        java.awt.GridBagConstraints gridBagConstraints;

        jButton2 = new javax.swing.JButton();
        jButton2.setFont(displayTextFont);
        jLabel2 = new javax.swing.JLabel();
        dataList = new DataList();
        jTable = new javax.swing.JTable(dataList);
        jTable.setFont(tableFont);
        jTable.setSelectionMode(ListSelectionModel.SINGLE_INTERVAL_SELECTION);
        rowSM = jTable.getSelectionModel();
        rowSM.addListSelectionListener(this);
        jScrollPane1 = new javax.swing.JScrollPane(jTable);
        jScrollPane1.setBackground(new java.awt.Color(255, 255, 255));
        jScrollPane1.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED));
        jScrollPane1.setMinimumSize(new java.awt.Dimension(400, 150));
        jScrollPane1.setPreferredSize(new java.awt.Dimension(400, 200));
        jButton1 = new javax.swing.JButton();
        jButton1.setFont(displayTextFont);
        jButton3 = new javax.swing.JButton();
        jButton3.setFont(displayTextFont);

        getContentPane().setLayout(new java.awt.GridBagLayout());

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        jButton2.setText("Import Selected Scan(s)");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        getContentPane().add(jButton2, gridBagConstraints);
        jButton2.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                       int minSelectedRow = rowSM.getMinSelectionIndex();
                       int maxSelectedRow = rowSM.getMaxSelectionIndex();
                       for(int i=minSelectedRow;i<=maxSelectedRow;i++) {
                           publishControlObject(ivTestInterface.getIVInfo(i));
                           }
                       setVisible(false);
                     }
             });
        jButton2.setEnabled(false);



        jLabel2.setText("No Data listed...");
        jLabel2.setFont(displayScaleFont);  
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(2, 5, 0, 5);
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
//        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        getContentPane().add(jLabel2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
        gridBagConstraints.weighty = 0.6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        getContentPane().add(jScrollPane1, gridBagConstraints);

        jButton1.setText("Refresh Data List");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.CENTER;
        getContentPane().add(jButton1, gridBagConstraints);
        jButton1.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                            refreshScanList();
                    }
             });

        jButton3.setText("Close");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHEAST;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.weightx = 0.5;
        getContentPane().add(jButton3, gridBagConstraints);
        jButton3.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                     exitForm(null);
                     }
             });
        getContentPane().setBackground(new java.awt.Color(255, 255, 255));

        pack();

    }

    /** method required by ListSelectionListener interface */
    public void valueChanged(ListSelectionEvent e) {

              if (e.getValueIsAdjusting()) return;

              ListSelectionModel lsm = (ListSelectionModel)e.getSource();
 
        
              if (lsm.isSelectionEmpty()) {
                   jButton2.setEnabled(false);
                   return;
                   }

              jButton2.setEnabled(true);
              }
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {
       setVisible(false);
       dispose();
    }

   private void publishControlObject(IVInfo ivInfo) {

         Integer run = ivInfo.getRun();
         Integer scan = ivInfo.getScan();
         String controlObjectName = "RetrievedData.ControlIVScanData."+run.toString()+"."+scan.toString();

         String[] modules = ivInfo.getModuleList();
         IVScanControl iv = new IVScanControl();
         iv.runNo= run.intValue();
         iv.scanNo= scan.intValue();
         iv.scanDate = ivInfo.getDate();
         iv.scanTime = ivInfo.getTime();
         iv.modules = modules;
         List vList = ivInfo.getVList();
         iv.voltageData = new String[vList.size()];
         for(int i=0;i<vList.size();i++) iv.voltageData[i] = new String("Current @ "+((Double)vList.get(i)).toString()+"V");
// publish the control object!
         try {
         if(!SctNames.getISRepository().contains(controlObjectName)) SctNames.getISRepository().insert(controlObjectName, iv);  
         }catch(Exception e) {
              System.err.println("SctGUI::IVScanLister - Exception creating control object - "+e.toString());
              return;
              }
// now publish the module detector objects
        for(int i=0;i<modules.length;i++) {
            String sn = modules[i];
            String filestem = ivInfo.getFileStem();
            String objectName = "RetrievedData.IVScanData."+run.toString()+"."+scan.toString()+"."+modules[i];
            TestSummaryIS isObject = new TestSummaryIS();
            String dataString = ivTestInterface.getDataString(run,scan,modules[i],filestem);
            if(dataString!=null) {
              isObject.dataString=dataString;
              try {
                if(!SctNames.getISRepository().contains(objectName)) SctNames.getISRepository().insert(objectName, isObject);
              }catch(Exception e2){System.err.println("SctGUI::IVScanLister - Failed to publish "+objectName+" - "+e2.toString());}
              }
            }
         return;
         }
    private void refreshScanList() {
         try {
                         ivTestInterface.refresh();
                         List table = new ArrayList();
                         List ivInfoList = ivTestInterface.getTableList();
                         for(int i=0;i<ivInfoList.size();i++) {
                            IVInfo ivInfo = (IVInfo)ivInfoList.get(i);
                            Integer run = ivInfo.getRun();
                            Integer scan = ivInfo.getScan();        
                            List theLine = new ArrayList();
                            theLine.add(run);
                            theLine.add(scan);
                            theLine.add(ivInfo.getDate());
                            theLine.add(ivInfo.getTime());
                            theLine.add(new Integer(ivInfo.getModuleCount()));
                            try {
                              theLine.add(new Boolean(SctNames.getISRepository().contains("RetrievedData.ControlIVScanData."+run.toString()+"."+scan.toString())));
                              }catch(Exception e){theLine.add("Unknown");}
                            table.add(theLine);
                            }
                         dataList.reTable(table);
                         jLabel2.setText(dataList.getRowCount()+" IV scans are available.");
                       }catch(Exception e){System.err.println("Failed to retrieve IVScan list - "+e.toString());} 
   }


public class DataList extends javax.swing.table.AbstractTableModel {
    private String[] columnNames = {"Run","Scan","Date","Time","#Modules","Imported?"};
    List rows;

    public DataList() {
         rows=new ArrayList();
         }


    public void reTable(List rows) {
         this.rows=rows;
         fireTableChanged(null); // Tell the listeners a new table has arrived.
         return ;
    }



    //  Now the Implementation of the TableModel Interface
   
    public String getColumnName(int column) {
        if (columnNames[column] != null) {
            return columnNames[column];
        } else {
            return "";
        }
    }

    public Class getColumnClass(int column) {
            return getValueAt(0, column).getClass();

   }

    public boolean isCellEditable(int row, int column) {
            return false; 
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public int getRowCount() {
        return rows.size();
    }

    public Object getValueAt(int aRow, int column) {

        List theRow = (ArrayList)rows.get(aRow);
        return theRow.get(column);
    }


    public void setValueAt(Object value, int row, int column) {
        List dataRow = (List)rows.get(row);
        dataRow.set(column, value);
    }






}

    
    

    
}
