package DisplayGUI;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.tree.*;
import java.awt.*;


public class ISTree extends JFrame implements ActionListener, displayParams {
    gui guiControl;
    JButton closeButton, refreshButton;
       // Create the tree
    protected JTree trISServers;
    JMenu popupOptionMenu;
 
    protected DefaultMutableTreeNode rootNode;

     public ISTree(gui parent, DefaultMutableTreeNode top) {
	    super("Information Service Status"); 
            guiControl=parent;

            
            JPanel pane = new JPanel();
            pane.setLayout(new BoxLayout(pane,BoxLayout.Y_AXIS));

            popupOptionMenu = getTreeOptionMenu();


            trISServers = new javax.swing.JTree();
            trISServers.setEditable(false);
            trISServers.setBorder(new javax.swing.border.EtchedBorder());
            JScrollPane scrollPane = new JScrollPane(trISServers);
            scrollPane.setPreferredSize(new java.awt.Dimension(300,300));
            pane.add(Box.createRigidArea(new Dimension(0,5)));
            pane.add(scrollPane);

            pane.add(Box.createRigidArea(new Dimension(0,5)));

            JPanel buttonPane = new JPanel();
            buttonPane.setLayout(new BoxLayout(buttonPane,BoxLayout.X_AXIS));

            closeButton = new JButton("Close");
            refreshButton = new JButton("Refresh");
            closeButton.setEnabled(true);
            closeButton.addActionListener(this);
            refreshButton.setEnabled(true);
            refreshButton.addActionListener(this);

            buttonPane.add(refreshButton);
            buttonPane.add(Box.createHorizontalGlue());
            buttonPane.add(closeButton);
//           buttonPane.add(Box.createRigidArea(new Dimension(20,0)));
            pane.add(buttonPane);
            pane.setToolTipText("Keyboard Options:\nALT_DELETE to delete the selection(s)\nALT_V to view the IS data");

            trISServers.addMouseListener(new isTreeMouseAdapter());

	    setContentPane(pane);
            pack();

            setTree(top);
}




	public Insets getInsets() {
		return new Insets(20,20,20,20);
		}
 
 




public void actionPerformed(ActionEvent evt) {
  Object source = evt.getSource();



  if(source==closeButton) setVisible(false);
  else setTree(guiControl.isInterface.getISTree());

}


   public void setTree(DefaultMutableTreeNode top) {

        trISServers.setModel(new DefaultTreeModel(top));
        setVisible(true);

           }

   private JMenu getTreeOptionMenu() {
       JMenu thisMenu = new JMenu("TreeOptions");
       thisMenu.setFont(menuFont);
       JMenuItem item1 = new JMenuItem("Delete selection(s)");
       JMenuItem item2 = new JMenuItem("View Selection");
       item1.setFont(menuFont);
       item2.setFont(menuFont);
       thisMenu.add(item1);
       thisMenu.add(item2);
       item1.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                     TreePath[] paths;
                     if((paths = trISServers.getSelectionPaths())==null) return;
                     GuiComponents.System.ISInterface is = GuiComponents.System.ISInterface.getInstance();
                     for (int i=paths.length-1; i>=0; i--) {
                       DefaultMutableTreeNode hist = (DefaultMutableTreeNode)paths[i].getLastPathComponent();                        
        //This call handles message creation for us so can be called in any thread.
                       ((DefaultTreeModel)trISServers.getModel()).removeNodeFromParent(hist); 
                         System.out.println(is.remove(hist.toString()));
                         }
              }
           });
       item2.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                    TreePath path = trISServers.getSelectionPath();
                    if(path==null) return;
                    guiControl.isInterface.viewISData(path.getLastPathComponent().toString());
              }
          });  
      return thisMenu;
      }

    class isTreeMouseAdapter extends java.awt.event.MouseAdapter {
            public void mouseClicked(java.awt.event.MouseEvent e) {
               switch(e.getModifiers()) {
                 case java.awt.event.InputEvent.BUTTON2_MASK:
                 case java.awt.event.InputEvent.BUTTON3_MASK:
                     TreePath[] existingSelections = trISServers.getSelectionPaths();
                     TreePath selPath = trISServers.getPathForLocation(e.getX(), e.getY());
                     if(selPath!=null && (existingSelections==null || existingSelections.length<2)) trISServers.setSelectionPath(selPath);
                     existingSelections = trISServers.getSelectionPaths();
                     if(existingSelections==null) return;             
                     JPopupMenu pMenu = popupOptionMenu.getPopupMenu();
                     pMenu.show(e.getComponent(),e.getX(),e.getY());
                     pMenu.setInvoker(popupOptionMenu);
                 break;
                 default:
                 }
            }
    }


}
