package DisplayGUI;

import java.awt.event.*;
import javax.swing.*; 
/*
* class to limit IS requests to half-second intervals
* @author robinson
*/
class ISRequestBuffer {


    public final static int TIME_INTERVAL = 750;
   
    gui guiControl;
    private Timer timer;
    String queuedObjectName;
    final java.util.regex.Pattern objectPattern = java.util.regex.Pattern.compile(".*TestData\\.[0-9]+\\.[0-9]+");
    final java.util.regex.Pattern rObjectPattern = java.util.regex.Pattern.compile(".*TestData\\.[0-9]+\\.[0-9]+.*Test");
    final java.util.regex.Pattern ivObjectPattern = java.util.regex.Pattern.compile(".*ControlIVScanData.*");

    String lastUpdateTime = "No updates yet";

    public ISRequestBuffer(gui parent) {

       guiControl=parent;
    }


   public void queueObject(String objectName, boolean isNewObject) {   // queue it for later

       java.util.regex.Matcher matcher = objectPattern.matcher(objectName);
       java.util.regex.Matcher matcher2 = rObjectPattern.matcher(objectName);
       java.util.regex.Matcher matcher3 = ivObjectPattern.matcher(objectName);
      
       if(matcher.matches() || matcher2.matches() || matcher3.matches()) {
             if(!isNewObject) { // control object change - must be change in test running state
                     guiControl.tablesDisplayPane.updateTest(objectName);
                     return;
                     }
             updateAll(objectName);  // if a control object, update immediately
             return;
             }

       if(timer!=null && timer.isRunning()) {
           queuedObjectName=objectName;
//           System.out.println("Queueing "+queuedObjectName+" for later ...");
           return;   
           }
// ok no requests queued, so update the display and start the timer
       timer = new Timer(TIME_INTERVAL, new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
               if(queuedObjectName!=null) {
//                   System.out.println("Timer: Now updating for queued object "+queuedObjectName);
                   updateAll(queuedObjectName);
                   queuedObjectName=null;
                   }
            }
        });
     timer.setRepeats(false);
     timer.start();
     updateAll(objectName);
     queuedObjectName=null;
     }

  private void updateAll(String theObjectName) {
// NB updateTables does a display update, so don't call setDisplayColors after this call
//                guiControl.displayPane.setDisplayColors();
                  java.util.regex.Matcher matcher = objectPattern.matcher(theObjectName);
                  java.util.regex.Matcher matcher2 = rObjectPattern.matcher(theObjectName);
                  java.util.regex.Matcher matcher3 = ivObjectPattern.matcher(theObjectName);
                  if(matcher.matches() || matcher2.matches() || matcher3.matches()) {
                       // if DCS enabled, and this is a new current test object (not downloaded from SCTDB)
                       if(!theObjectName.startsWith("SCTDBData") && !theObjectName.startsWith("RetrievedData")) guiControl.isInterface.fillDCSMap(theObjectName); // snapshot the DCS data
                     // if a new control object, add it to the list
                       guiControl.tablesDisplayPane.addNewTest(theObjectName);
                       guiControl.tablesDisplayPane.updateTables();  // immediately add the control info to the table
                       return;
                    }
                  else {
                    switch(guiControl.displayStatus.getStatus()) {
                     case DisplayStatus.IS_MONITOR:
                          guiControl.tablesDisplayPane.listISObjects(guiControl.displayPane.getLastClickedCell());
                          guiControl.displayPane.setDisplayColors();
                          guiControl.displayPane.refreshDisplay();  // just refresh the display
                          break;
                     case DisplayStatus.TEST_DATA:
                     case DisplayStatus.SCTDB_DATA:
		     case DisplayStatus.SCTDB_RODDAQ_DATA:
                        if(theObjectName.startsWith("TestData")) guiControl.tablesDisplayPane.updateTables(false);
                        else {
                           guiControl.displayPane.setDisplayColors();
                           guiControl.tablesDisplayPane.listTestResults();
                           guiControl.displayPane.refreshDisplay();  // just refresh the display
                             }
                        break;
		     case DisplayStatus.IV_DATA:    
                           guiControl.displayPane.setDisplayColors();
                           guiControl.tablesDisplayPane.listTestResults();
                           guiControl.displayPane.refreshDisplay();  // just refresh the display
                        break;
         
                     case DisplayStatus.DCS_DATA:
                           lastUpdateTime = guiUtilities.DaveUtils.getCurrentTime();
                           guiControl.tablesDisplayPane.updateTables(false);

			   break;
                     default:
                     }
                  }
               }
   public String getLastUpdateTime() {
       return lastUpdateTime;
       }



}
