/*
 * HardwareConfigurationPanel.java
 *
 */
package DisplayGUI;

import sctConf.*;
import ipc.*;

import GuiComponents.SctConf.*;
import GuiComponents.System.*;

import java.util.Enumeration;
import java.util.Vector;
import java.awt.Dimension;
import java.awt.BorderLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.*;

import org.omg.CORBA.IntHolder;

/**
 * Displays Bruce's configuration panels
 * @author  robinson
 */
public class HardwareConfigurationPanel extends javax.swing.JPanel {
    
    private sctConf.Configuration config;

    ConfigFileLister configFileLister=null;

    public HardwareConfigurationPanel() {

        connectServer();
	if (config==null) {
	    System.err.println("Error (check configuration running)");
	    System.exit(0);
	}
        System.out.println("Found configuration ok");
        initComponents();
    }
    
    
   

    private void initComponents() {
        
        setBackground(new java.awt.Color(255, 255, 255));

        TreeView treeView = new TreeView(new Proxies(config), config);
//        scrollPane = new javax.swing.JScrollPane(new TreeView(new Proxies(config), config));
//        scrollPane.setMinimumSize(new java.awt.Dimension(500, 400));
//        scrollPane.setPreferredSize(new java.awt.Dimension(600, 600));

        saveConfigButton = new javax.swing.JButton();
        reLoadConfigButton = new javax.swing.JButton();
        moduleListButton = new javax.swing.JButton();
        powerMappingsButton = new javax.swing.JButton();
        newModuleButton = new javax.swing.JButton();
 
        title = new javax.swing.JLabel("Hardware Configuration");
        title.setFont(new java.awt.Font("Arial",java.awt.Font.BOLD,16));
        title.setForeground(new java.awt.Color(51, 0, 153));

        java.awt.GridBagConstraints gridBagConstraints;
        setLayout(new java.awt.GridBagLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.weighty = 0.1;
        add(title, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.weighty = 0.8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(treeView, gridBagConstraints);

        saveConfigButton.setFont(new java.awt.Font("Arial", 0, 12));
        saveConfigButton.setText("Save");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(saveConfigButton, gridBagConstraints);
        saveConfigButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                    try {
                        config.saveConfiguration("Dump_From_ConfigGUI.xml");
                    } catch(ConfigurationException c) {
                        JOptionPane.showMessageDialog(null, "Save configuration failed!");
                    }
            }
        });
        reLoadConfigButton.setFont(new java.awt.Font("Arial", 0, 12));
        reLoadConfigButton.setText("Reload");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(reLoadConfigButton, gridBagConstraints);
        reLoadConfigButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                    try {
                        config.loadConfiguration("");
                    } catch(ConfigurationException c) {
                        JOptionPane.showMessageDialog(null, "Load configuration failed!");
                    }
            }
        });
        moduleListButton.setFont(new java.awt.Font("Arial", 0, 12));
        moduleListButton.setText("Module List");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(moduleListButton, gridBagConstraints);
        moduleListButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                    JFrame frame = new JFrame("Module list");
                    if(config == null) {
                        connectServer();
                    }
                    frame.getContentPane().add(new ModuleListView(config));

                    frame.addWindowListener(new WindowAdapter() {
                            public void windowClosing(WindowEvent e) {
                                e.getWindow().dispose();
                            }
                        });
                    frame.pack();
                    frame.setVisible(true);
            }
        });
        powerMappingsButton.setFont(new java.awt.Font("Arial", 0, 12));
        powerMappingsButton.setText("Power Mappings");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(powerMappingsButton, gridBagConstraints);
        powerMappingsButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                    JFrame frame = new JFrame("Power Mappings");
                    if(config == null) {
                        connectServer();
                    }
                    frame.getContentPane().add(new PowerMappings(config));

                    frame.addWindowListener(new WindowAdapter() {
                            public void windowClosing(WindowEvent e) {
                                e.getWindow().dispose();
                            }
                        });
                    frame.pack();
                    frame.setVisible(true);
            }
        });

        newModuleButton.setFont(new java.awt.Font("Arial", 0, 12));
        newModuleButton.setText("New Module...");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(newModuleButton, gridBagConstraints);
        newModuleButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                    if(config == null) {
                        connectServer();
                    }
                    if(configFileLister==null) configFileLister = new ConfigFileLister(config);
                    configFileLister.show();
            }
        });


    }

    public void connectServer() {
        SystemInterface sys = SystemInterface.getInstance();
        // If config server lost then need to reconnect
        sys.refresh();
        config = sys.getConfigurationService();
    }


    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables

    private javax.swing.JButton saveConfigButton;
    private javax.swing.JButton reLoadConfigButton;
    private javax.swing.JButton moduleListButton;
    private javax.swing.JButton powerMappingsButton;
    private javax.swing.JButton newModuleButton;

    private javax.swing.JScrollPane scrollPane;

    private javax.swing.JLabel title;
}
