package DisplayGUI;
import java.awt.Color;
import java.awt.Font;

public class DisplayTitle {
    String title;
    Color color;
    Font font;

    public DisplayTitle(String title, Color color, Font font) {
       this.title=title;
       this.color=color;
       this.font=font;
       }
    public int drawText(java.awt.Graphics2D g2,int x, int alignment) {
       g2.setFont(font);
       g2.setPaint(color);
       java.awt.FontMetrics metrics = g2.getFontMetrics();
       int width=metrics.stringWidth(title);
       int xloc = (alignment==0) ? x : x-width;
       g2.drawString(title,xloc,metrics.getHeight());
       return width;
       }
    public void drawCenteredText(java.awt.Graphics2D g2,int x, int y) {
       g2.setFont(font);
       g2.setPaint(color);
       java.awt.FontMetrics metrics = g2.getFontMetrics();
       int width=metrics.stringWidth(title);
       g2.drawString(title,x-width/2,y-metrics.getHeight());
       } 

}