package DisplayGUI;

import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.swing.*;
import java.awt.Graphics2D.*;
import java.awt.geom.*;
import java.util.*;

class DisplayPanel extends JPanel implements guiInterface, TestDataInfo  {
        gui guiControl;
        private int selectedView = 0;
        FontMetrics metrics;
	int maxWidth;
        private int displayOption=0; // for testdata 0:rod 1: sctdb 2: rod-sctdb comparison

        private JMenu dataPopupMenu, sctdbPopupMenu;

        private Rectangle draggedRectangle;
        
        private boolean firstTime = true;
	private Rectangle area;   
        private Dimension dim;

        private ModuleCell redCell,lastClickedCell,popupCell;
        private String mouseLocationText, mouseLocationSN;

        private DisplayTitle leftTitle, middleTitle, rightTitle, optionTitle;

        ConfigurationInterface config;

        private java.util.List changedModuleList;

    public DisplayPanel(gui parent){
        guiControl=parent;
        setBackground(Color.white);
        addMouseMotionListener(this);
        addMouseListener(this);
        dim = getSize();
        maxWidth = (int)dim.getWidth();

        setMinimumSize(new Dimension(14*boxWidth,yOffSet+58*boxHeight));
        setPreferredSize(new Dimension(14*boxWidth,yOffSet+58*boxHeight));    

        selectedView = guiControl.selectorPane.getViewIndex();

        config = ConfigurationInterface.getInstance();
        config.setWindowSize(maxWidth,(int)dim.getHeight());

        leftTitle = null;
        middleTitle = null;
        rightTitle = null;
        optionTitle=null;

        changedModuleList = new ArrayList();


    }

    


    // Handles the event of the user pressing down the mouse button.
    public void mousePressed(MouseEvent e){
        if(guiControl.displayStatus.getStatus()!=DisplayStatus.MODULE_GROUP_SELECTION) return;
        draggedRectangle = new Rectangle(new Point(e.getX(),e.getY()));   
    }

    // Handles the event of a user dragging the mouse while holding
    // down the mouse button.
    public void mouseDragged(MouseEvent e){

 
        if(guiControl.displayStatus.getStatus()!=DisplayStatus.MODULE_GROUP_SELECTION) return;
        redCell=null;
        int width = e.getX() - (int)draggedRectangle.getX();
        int height = e.getY() - (int)draggedRectangle.getY();
        int thisModuleGroup = guiControl.selectorPane.getMouseClickIndex();
// re-define or resize the dragged rectangle
        if(width<0 || height<0) {
             int oldWidth = (int)draggedRectangle.getWidth();
             int oldHeight = (int)draggedRectangle.getHeight();
             draggedRectangle = new Rectangle(new Point(e.getX(),e.getY()),new Dimension(Math.abs(width)+oldWidth,Math.abs(height)+oldHeight));
             }
        else draggedRectangle.setSize(new Dimension(width,height));
        for(Enumeration e2 = config.getSerialNumberMap(selectedView).elements(); e2.hasMoreElements();) {
               ModuleCell thisCell = (ModuleCell) e2.nextElement();
               if(thisCell.getSctComponent()!=selectedView) continue;
               if(thisCell.intersects(draggedRectangle)) {
                   switch(e.getModifiers()) {
                     case InputEvent.BUTTON2_MASK:
                     case InputEvent.BUTTON3_MASK:
                     if(thisCell.getModuleGroup()==thisModuleGroup) {
                           thisCell.setModuleGroup(-1);
                           changedModuleList.add(thisCell);
                           }
                     break;
                   default:
                       if(!thisCell.isSelected()) {
                              thisCell.setModuleGroup(thisModuleGroup);
                              changedModuleList.add(thisCell);
                              }
                     }
               }
          }
        if(guiControl.displayStatus.getStatus()==DisplayStatus.MODULE_GROUP_SELECTION) {
                  setDisplayColors();
//                  if(changedModuleList.size()>0) config.updateModuleGroups(changedModuleList);
                  }
        repaint();

    }

    // Handles the event of a user releasing the mouse button.
    public void mouseReleased(MouseEvent e){
       if(draggedRectangle!=null) {
           draggedRectangle=null;
           repaint();
           }
       if(guiControl.displayStatus.getStatus()==DisplayStatus.MODULE_GROUP_SELECTION && changedModuleList.size()>0) {
           guiControl.tablesDisplayPane.updateTables();
           config.updateModuleGroups(changedModuleList);
           changedModuleList.clear();
           }
    }
       
     // This method is required by MouseListener.
     public void mouseMoved(MouseEvent e){ 
       if(draggedRectangle!=null) return;
       ModuleCell thisCell = config.getCell(selectedView,e.getX(),e.getY());
       if(thisCell==null) {
           redCell = null;
           if(mouseLocationText!=null) {
               mouseLocationText = null;
               mouseLocationSN=null;
               repaint();
           }
           return;
       }

// check for redCell
       if(thisCell==redCell)  return;  // no change
       else {
//            if(redCell!=null) redCell.setSelected(false);
//            thisCell.setSelected(true);
            redCell = thisCell;
       }
// update mouse Text
       String sn = thisCell.getSerialNo();
       String infoString = sn+" ("+config.getSNInfo(sn,SNInfo.ROD_CRATE)+","+config.getSNInfo(sn,SNInfo.ROD_NUMBER)+","+config.getSNInfo(sn,SNInfo.ROD_CHANNEL)+","+config.getSNInfo(sn,SNInfo.DCS_CRATE)+","+config.getSNInfo(sn,SNInfo.DCS_CHANNEL)+") ";
       switch(guiControl.displayStatus.getStatus()) {
          case DisplayStatus.IS_MONITOR:
               if(guiControl.tablesDisplayPane.getTestSelection()!=null && thisCell.getData()!=null) {
                 mouseLocationText = new String(infoString+" : "+thisCell.getData().intValue()+" data objects");
                 }
               break;
          case DisplayStatus.MODULE_GROUP_SELECTION:
               if(selectedView<4) mouseLocationText = new String(infoString+" MUR: "+thisCell.getMUR()+" Position: "+thisCell.getModulePosition());
               else mouseLocationText = new String(infoString+" MUR: "+thisCell.getMUR()+" Quadrant/Position: "+thisCell.getQuadrant()+"/"+thisCell.getEndCapPosition());
               break;
          default:  
               ColorScale thisColorScale = guiControl.colorScalePane.getColorScale();              
               if(thisColorScale!=null) mouseLocationText = new String(infoString+" : "+thisColorScale.getLabel(thisCell.getData()));
               else mouseLocationText = new String(infoString+" : No Data");
               break;
          }


       repaint();
     }

     // These methods are required by MouseMotionListener.
     public void mouseClicked(MouseEvent e){
       ModuleCell thisCell = config.getCell(selectedView,e.getX(),e.getY());
       if(thisCell==null) {
          switch(e.getModifiers()) {
           case InputEvent.BUTTON2_MASK:
           case InputEvent.BUTTON3_MASK:             
           guiControl.menuBar.showPopupMenu(e);
           break;
          default:
          }
         return;
        }
       
       lastClickedCell = thisCell;

       switch(guiControl.displayStatus.getStatus()) {

         case DisplayStatus.MODULE_GROUP_SELECTION:
            int thisModuleGroup =guiControl.selectorPane.getMouseClickIndex();  
              switch(e.getModifiers()) {
               case InputEvent.BUTTON2_MASK:
               case InputEvent.BUTTON3_MASK:     
                     if(thisCell.getModuleGroup()==thisModuleGroup) {
                           thisCell.setModuleGroup(-1);
                           changedModuleList.add(thisCell);
                           }
                     break;
              default:
                     if(!thisCell.isSelected()) {
                              thisCell.setModuleGroup(thisModuleGroup);
                              changedModuleList.add(thisCell);
                              }
             }

           repaint();

           if(changedModuleList.size()>0) {
              guiControl.tablesDisplayPane.updateTables();
              config.updateModuleGroups(changedModuleList);
              changedModuleList.clear();
              }            

           break;

       case DisplayStatus.IS_MONITOR:
           guiControl.tablesDisplayPane.listISObjects(thisCell);
           guiControl.tablesDisplayPane.setSelectedSerialNo(thisCell.getSerialNo(),false);
           switch(e.getModifiers()) {
//               case InputEvent.BUTTON1_MASK:
//
//                  break;
               case InputEvent.BUTTON2_MASK:
               case InputEvent.BUTTON3_MASK: 
                  popupCell=thisCell;    
                   guiControl.menuBar.setSelectedSerialNo(thisCell.getSerialNo());   
                   JPopupMenu pMenu = guiControl.menuBar.dataManagerSNMenu.getPopupMenu();
                   pMenu.show(e.getComponent(),e.getX(),e.getY());
                   pMenu.setInvoker(guiControl.menuBar.dataManagerSNMenu);
               break;
              default:
           }
           break;
       case DisplayStatus.TEST_DATA:
//              SummaryReader.ReaderReportUtilities.showTestReport(guiControl,thisCell);
           guiControl.tablesDisplayPane.setSelectedSerialNo(thisCell.getSerialNo(),true);
           switch(e.getModifiers()) {
               case InputEvent.BUTTON2_MASK:
               case InputEvent.BUTTON3_MASK: 
                  popupCell=thisCell; 
                   guiControl.menuBar.setSelectedSerialNo(thisCell.getSerialNo());   
                   JPopupMenu pMenu = guiControl.menuBar.testDataMenu.getPopupMenu();
                   pMenu.show(e.getComponent(),e.getX(),e.getY());
                   pMenu.setInvoker(guiControl.menuBar.testDataMenu);
               break;
              default:
           }
           break;
       case DisplayStatus.SCTDB_DATA:
       case DisplayStatus.SCTDB_RODDAQ_DATA:
           guiControl.tablesDisplayPane.setSelectedSerialNo(thisCell.getSerialNo(),true);
           switch(e.getModifiers()) {
               case InputEvent.BUTTON2_MASK:
               case InputEvent.BUTTON3_MASK: 
                  popupCell=thisCell;    
                   guiControl.menuBar.setSelectedSerialNo(thisCell.getSerialNo()); 
                    JPopupMenu pMenu = guiControl.menuBar.sctdbDataSNMenu.getPopupMenu();
                   pMenu.show(e.getComponent(),e.getX(),e.getY());
                   pMenu.setInvoker(guiControl.menuBar.sctdbDataSNMenu);
                   break;
                default:
                }
               break;
       case DisplayStatus.IV_DATA:
           guiControl.tablesDisplayPane.setSelectedSerialNo(thisCell.getSerialNo(),true);
           switch(e.getModifiers()) {
               case InputEvent.BUTTON2_MASK:
               case InputEvent.BUTTON3_MASK: 
                  popupCell=thisCell;    
                   guiControl.menuBar.setSelectedSerialNo(thisCell.getSerialNo()); 
                    JPopupMenu pMenu = guiControl.menuBar.ivScanMenu.getPopupMenu();
                   pMenu.show(e.getComponent(),e.getX(),e.getY());
                   pMenu.setInvoker(guiControl.menuBar.ivScanMenu);
               break;
              default:
           }
           break;
        default:
	    guiControl.tablesDisplayPane.setSelectedSerialNo(thisCell.getSerialNo(),true);
        }
       
       }

     public void mouseExited(MouseEvent e){}
     public void mouseEntered(MouseEvent e){}
                         

     public void refreshDisplay(){
          redCell=null;
	  repaint();
     }

    public void initPanelParameters() {  //must do this because config needs the panel size before it is painted
            dim = getSize();
            maxWidth = (int)dim.getWidth();
            config.setWindowSize(maxWidth,(int)dim.getHeight());
            }


    public void paintComponent(Graphics g){

        super.paintComponent(g);
        

        
        Graphics2D g2 = (Graphics2D)g;
	g2.setStroke(new BasicStroke(1.0f));

        if ( firstTime ) {
//            dim = getSize();
            area = new Rectangle(dim);
//            maxWidth = (int)dim.getWidth();
            firstTime = false;
            g2.setFont(displayTextFont);
            metrics = g2.getFontMetrics();
//            config.setWindowSize(maxWidth,(int)dim.getHeight());
	}
        // Clears the rectangle that was previously drawn.
        g2.setPaint(Color.white);
        g2.fill(area);

        
        config.drawSCTViewOutline(g2,selectedView);
        drawTitle(g2);
        if(mouseLocationText!=null) drawMouseLocation(g2,mouseLocationText);
        drawGraphicsCells(g2);
        drawMouseSelections(g2);

    }


    
    public void drawGraphicsCells(Graphics2D g2) {
        ColorScale thisColorScale = guiControl.colorScalePane.getColorScale();
        if(selectedView<4) {
          for(Enumeration e = config.getSerialNumberMap(selectedView).elements(); e.hasMoreElements();) {
               ModuleCell thisCell = (ModuleCell) e.nextElement();
               if(thisCell.getSctComponent()!=selectedView) continue;
               g2.setPaint(thisCell.getColor());
               g2.fill((Polygon)thisCell);
               g2.setColor(Color.black);
               g2.draw((Polygon)thisCell);
               }
          }
         else {
          // for endcaps, must draw/paint middle ring first
          for(Enumeration e = config.getSerialNumberMap(selectedView).elements(); e.hasMoreElements();) {
               ModuleCell thisCell = (ModuleCell) e.nextElement();
               if(thisCell.getSctComponent()!=selectedView) continue;
               int ring = thisCell.getPosition();
               if(ring<13 || ring>22) continue;
               g2.setPaint(thisCell.getColor());
               g2.fill((Polygon)thisCell);
               g2.setColor(Color.black);
               g2.draw((Polygon)thisCell);
               }
          for(Enumeration e = config.getSerialNumberMap(selectedView).elements(); e.hasMoreElements();) {
               ModuleCell thisCell = (ModuleCell) e.nextElement();
               if(thisCell.getSctComponent()!=selectedView) continue;
               int ring = thisCell.getPosition();
               if(ring>=13 && ring<=22) continue;
               g2.setPaint(thisCell.getColor());
               g2.fill((Polygon)thisCell);
               g2.setColor(Color.black);
               g2.draw((Polygon)thisCell);
               }
           }
    }

   public void drawMouseSelections(Graphics2D g2) {
       if(redCell!=null) {
            g2.setColor(Color.red);
            g2.draw((Polygon)redCell);
          }
           if(draggedRectangle!=null) {
               g2.setColor(Color.red);
               g2.draw(draggedRectangle);
           }
          g2.setColor(Color.lightGray);
      }



    public void drawMouseLocation(Graphics2D g2, String mouseLocationText) {
        g2.setFont(displayTextFont);
//        g2.setPaint(darkBlueColor);
        g2.setPaint(Color.white);
        metrics = g2.getFontMetrics();
        int stringWidth = metrics.stringWidth(mouseLocationText);
        int stringHeight = metrics.getHeight();
        g2.drawString(mouseLocationText,maxWidth/2+7*boxWidth - stringWidth-5,yOffSet+boxHeight-stringHeight);
    }

    public void drawTitle(Graphics2D g2) {
        g2.setPaint(Color.blue);
        int leftX = maxWidth/2-6*boxWidth;
        int rightX = maxWidth/2+7*boxWidth;
        Rectangle top = new Rectangle(leftX,0,13*boxWidth,yOffSet);
        g2.fill(top);
        leftX+=5;

        // left Title
        if(leftTitle!=null) leftTitle.drawText(g2, leftX, 0);

        // right Title
        int rightTitleWidth= 0;
        if(rightTitle!=null) rightTitleWidth = rightTitle.drawText(g2,rightX-5,1);

        // middle Title
        if(middleTitle!=null) middleTitle.drawText(g2,rightX-rightTitleWidth-20,1);

        g2.setFont(displayTextFont);
        g2.setPaint(Color.white);
        int y =yOffSet+boxHeight-g2.getFontMetrics().getHeight();
        g2.drawString(SCTViewNames[selectedView],leftX,y);
        int sWidth = g2.getFontMetrics().stringWidth(SCTViewNames[selectedView]);

//        if(optionTitle!=null) optionTitle.drawCenteredText(g2,maxWidth/2-20,yOffSet+boxHeight);
        if(optionTitle!=null) g2.drawString(optionTitle.title,leftX+20+sWidth,y);
    }


    public void setSCTView(int view) {
        selectedView=view;
        guiControl.tablesDisplayPane.updateTables();
        }
    public void setDisplayOption(int displayOption) {
        this.displayOption=displayOption;
        guiControl.colorScalePane.setColorScale();
        setDisplayColors();
        refreshDisplay();
        guiControl.tablesDisplayPane.listTestResults();
        }
   public int getDisplayOption() {
        return displayOption;
        }
   public void resetDisplayOption() {
        displayOption=0;
        }
   public int getSCTView() {
        return selectedView;
        }
   public ModuleCell getLastClickedCell() {
        return lastClickedCell;
        }

    public void setDisplayColors() {
//       System.out.println("**setDisplayColors**");
       TestSelection testSelection = guiControl.tablesDisplayPane.getTestSelection();
       IVTestSelection ivTestSelection = guiControl.tablesDisplayPane.getIVTestSelection();
       int testIndex = (testSelection!=null) ? testSelection.getTestIndex() : -1;

       int displayStatus = guiControl.displayStatus.getStatus();
       Map countMap = null;
       if(displayStatus==DisplayStatus.IS_MONITOR && testSelection!=null) countMap = guiControl.isInterface.isCounter.getModuleMap(guiControl.selectorPane.getDisplayParameterIndex(),testSelection.getRunScanRegex(),testSelection.isRetrievedData());
       Map dcsMap = null;
//       if(displayStatus==DisplayStatus.DCS_DATA && guiControl.tablesDisplayPane.getTestControlObjectName()!=null) dcsMap=guiControl.isInterface.getDCSMap(guiControl.tablesDisplayPane.getTestControlObjectName());
       if(guiControl.tablesDisplayPane.getTestControlObjectName()!=null) dcsMap=guiControl.isInterface.getDCSMap(guiControl.tablesDisplayPane.getTestControlObjectName());
       int parameterIndex = guiControl.selectorPane.getDisplayParameterIndex();
       int mouseOption = guiControl.selectorPane.getMouseClickIndex();

       SummaryReader.DCSInfo dcsInfo;

// enumerate through all modules
       MODULELOOP:
       for(Enumeration e = config.getSerialNumberMap(selectedView).elements(); e.hasMoreElements();) {
           ModuleCell thisCell = (ModuleCell) e.nextElement();
           String sn = thisCell.getSerialNo();
           Double theData=null;
           String header=null;
           switch(displayStatus) {
// TEST_DATA *********************************
             case DisplayStatus.TEST_DATA:
                  if(testSelection!=null) header = testSelection.getResultObjectHeader();
                  if(header==null) {
                       fillCellData(thisCell,null);
                       continue MODULELOOP;                       
                       }    
                   dcsInfo = (dcsMap!=null) ? (SummaryReader.DCSInfo)dcsMap.get(sn) : null;
                   switch(displayOption) {
                     case 1: // SCTDB Data only    
                        header = testSelection.getSCTDBObjectHeader();
                        if((theData = guiControl.isInterface.getSCTDBData(header+sn,testIndex))==null) {
                            fillCellData(thisCell,null);
                            continue MODULELOOP;
                            }    
                        break;
                     case 2: // Compare SCTDB and ROD data
                         if((theData=guiControl.isInterface.getTestData(header,sn,testIndex,dcsInfo))==null) {
                             fillCellData(thisCell,null);
                             continue MODULELOOP;
                             }  
                          Double sctdbData;                    
                          if((sctdbData = guiControl.isInterface.getSCTDBData(testSelection.getSCTDBObjectHeader()+sn,testIndex))==null) {
                             fillCellData(thisCell,null);
                             continue MODULELOOP;
                             }    
                          double diff = Math.abs(theData.doubleValue()-sctdbData.doubleValue());
                          if(testIndex==TEST_FULLBYPASS && parameterIndex>2) theData=new Double(1.0);
                          else theData = (diff>testDataTolerances[testIndex][parameterIndex]) ? new Double(2.0) : new Double(1.0);
                          break;
                   case 0: // ROD Data only
                   default:
                         if((theData=guiControl.isInterface.getTestData(header,sn,testIndex,dcsInfo))==null) {
                            fillCellData(thisCell,null);
                            continue MODULELOOP;
                            }    
                    }

                break;
// IV_DATA***********************************************
             case DisplayStatus.IV_DATA:
                 if(ivTestSelection==null) {
                      fillCellData(thisCell,null);
                      continue MODULELOOP;
                      }
                 header = ivTestSelection.getResultObjectHeader();
                 if(header==null || (theData = guiControl.isInterface.getTestData(header,thisCell.getSerialNo(),TEST_IV,null))==null) {
                       fillCellData(thisCell,null);
                       continue MODULELOOP;
                       }   
                 break;

// SCTDB ************************************************
             case DisplayStatus.SCTDB_DATA:
                 if(testSelection==null) {
                      fillCellData(thisCell,null);
                      continue MODULELOOP;
                      }
                 header = testSelection.getSCTDBObjectHeader();
                 if(header==null || (theData = guiControl.isInterface.getSCTDBData(header+thisCell.getSerialNo(),testIndex))==null) {
                       fillCellData(thisCell,null);
                       continue MODULELOOP;
                       }    
                break;
// SCTDB RodDAQ************************************************
             case DisplayStatus.SCTDB_RODDAQ_DATA:
                 if(testSelection==null) {
                      fillCellData(thisCell,null);
                      continue MODULELOOP;
                      }
                 header = testSelection.getSCTDBRodDaqObjectHeader();
                 if(header==null || (theData = guiControl.isInterface.getSCTDBData(header+thisCell.getSerialNo(),testIndex))==null) {
                       fillCellData(thisCell,null);
                       continue MODULELOOP;
                       }    
                break;
// DCS *************************************************
             case DisplayStatus.DCS_DATA: 
                if((theData=guiControl.isInterface.getDCSData(sn,parameterIndex))==null) {
                           fillCellData(thisCell,null);
                           continue MODULELOOP;
                           }

                break;
// Display Manager ***************************************
             case DisplayStatus.IS_MONITOR:
                     if(testSelection==null || countMap==null) {
                            fillCellData(thisCell,null);
                            continue MODULELOOP;
                            }
                    theData = (countMap.containsKey(sn)) ? new Double(((java.util.List)countMap.get(sn)).size()) : new Double(0.);
//                     theData = (moduleCountMap.containsKey(sn)) ? new Double(((Integer)moduleCountMap.get(sn)).intValue()) : new Double(0.);
                break;
// ModuleGroup *******************************************
             case DisplayStatus.MODULE_GROUP_SELECTION:
                  theData = new Double(thisCell.getModuleGroup());                   
             default:
                  fillCellData(thisCell,null);
           } 
          fillCellData(thisCell,theData);
          }
// now define titles
        int displayedTestIndex = guiControl.isInterface.getListFilterIndex();
        int selectedTestIndex = (testSelection!=null) ? testSelection.getTestIndex() : -1;
        int runno = (testSelection!=null) ? testSelection.getRunNo() : -1;
        int scanno = (testSelection!=null) ? testSelection.getScanNo() : -1;
        String statusString="No Data";
        String runScanString="No Data";
        String dataDescription = guiControl.selectorPane.getDisplayParameter();
        String option = guiControl.selectorPane.getOption();
        switch(guiControl.displayStatus.getStatus()) {
           case DisplayStatus.TEST_DATA:
              statusString="Test Results";
              if(selectedTestIndex>=0) statusString=testMenuNames[selectedTestIndex]+" Result";
              else if(displayedTestIndex>=0) statusString=testMenuNames[displayedTestIndex]+" Result";
              leftTitle = new DisplayTitle(statusString,java.awt.Color.yellow,displayTitleFont);
              switch(displayOption) {
                case 0:
                     rightTitle = (runno!=-1) ? new DisplayTitle("Run "+Integer.toString(runno)+" Scan "+Integer.toString(scanno),java.awt.Color.yellow,displayTitleFont) : new DisplayTitle("No Data",java.awt.Color.red,displayTitleFont);
                    break;
                case 1:
                     rightTitle = new DisplayTitle("SctDaq Reference",java.awt.Color.red,displayTitleFont);
                     break;
                case 2:
                     rightTitle = new DisplayTitle("SctDaq Comparison",java.awt.Color.red,displayTitleFont);
                default:
                }
              middleTitle = (dataDescription!=null) ? new DisplayTitle(dataDescription, java.awt.Color.white,displayTitleFont) : null;
              optionTitle = (option!=null) ? new DisplayTitle(option,java.awt.Color.white,displayTextFont) : null;
              break;
            case DisplayStatus.IV_DATA:                            
              rightTitle = (ivTestSelection!=null) ? new DisplayTitle("Run "+Integer.toString(ivTestSelection.getRunNo())+" Scan "+Integer.toString(ivTestSelection.getScanNo()),java.awt.Color.yellow,displayTitleFont) :  new DisplayTitle("No Data",java.awt.Color.red,displayTitleFont);
              leftTitle = new DisplayTitle("IV Scans",java.awt.Color.yellow,displayTitleFont);
              middleTitle = (ivTestSelection!=null) ? new DisplayTitle(guiControl.selectorPane.getIVParameter(),java.awt.Color.white,displayTitleFont) : null;
              optionTitle = null;
              break;
            case DisplayStatus.SCTDB_DATA:
              statusString="SCTDAQ Reference Data";
              if(selectedTestIndex>=0) statusString=testMenuNames[selectedTestIndex];
              else if(displayedTestIndex>=0) statusString=testMenuNames[displayedTestIndex];
              leftTitle = new DisplayTitle(statusString,java.awt.Color.yellow,displayTitleFont);
              rightTitle= (runno!=-1) ? new DisplayTitle("SCTDAQ Reference",java.awt.Color.red,displayTitleFont) : new DisplayTitle("No Data",java.awt.Color.red,displayTitleFont);
              middleTitle = (dataDescription!=null) ? new DisplayTitle(dataDescription, java.awt.Color.white,displayTitleFont) : null;              
              optionTitle = (option!=null) ? new DisplayTitle(option,java.awt.Color.white,displayTextFont) : null;
              break;
            case DisplayStatus.SCTDB_RODDAQ_DATA:
              statusString="SctRodDaq Reference Data";
              if(selectedTestIndex>=0) statusString=testMenuNames[selectedTestIndex]+" (SCTDB)";
              else if(displayedTestIndex>=0) statusString=testMenuNames[displayedTestIndex]+" (SCTDB)";
              leftTitle = new DisplayTitle(statusString,java.awt.Color.yellow,displayTitleFont);
              rightTitle = (runno!=-1) ? new DisplayTitle("Run "+Integer.toString(runno)+" Scan "+Integer.toString(scanno),java.awt.Color.yellow,displayTitleFont) : new DisplayTitle("No Data",java.awt.Color.red,displayTitleFont);
              middleTitle = (dataDescription!=null) ? new DisplayTitle(dataDescription, java.awt.Color.white,displayTitleFont) : null;              
              optionTitle = (option!=null) ? new DisplayTitle(option,java.awt.Color.white,displayTextFont) : null;
              break;
            case DisplayStatus.DCS_DATA:
              leftTitle= new DisplayTitle("Present DCS Conditions",java.awt.Color.yellow,displayTitleFont);
              rightTitle = null;
              optionTitle=null;
              middleTitle = (dataDescription!=null) ? new DisplayTitle(dataDescription, java.awt.Color.white,displayTitleFont) : null;
              break;
            case DisplayStatus.IS_MONITOR:
              leftTitle= new DisplayTitle("Data Manager",java.awt.Color.yellow,displayTitleFont);
              rightTitle = (runno!=-1) ? new DisplayTitle("Run "+Integer.toString(runno)+" Scan "+Integer.toString(scanno),java.awt.Color.yellow,displayTitleFont) : new DisplayTitle("No Data",java.awt.Color.red,displayTitleFont);
              middleTitle = (dataDescription!=null) ? new DisplayTitle(dataDescription, java.awt.Color.white,displayTitleFont) : null;
              optionTitle=null;
              break;
            case DisplayStatus.MODULE_GROUP_SELECTION:
              leftTitle= new DisplayTitle("Module Group Selection",java.awt.Color.yellow,displayTitleFont);
              rightTitle=null;
              middleTitle= (option!=null) ? new DisplayTitle(option+" Count : "+Integer.toString(guiControl.tablesDisplayPane.getRowCount(1)),java.awt.Color.white,displayTitleFont) : null;
              optionTitle = null;
              break;
            default:
              leftTitle= new DisplayTitle("Display UNCONFIGURED",java.awt.Color.white,displayTitleFont);
              rightTitle=null;
              middleTitle=null;
              optionTitle=null;
            }




   }

    private void fillCellData(ModuleCell thisCell, Double theData) {
         if(theData==null) {
            thisCell.setData(null,java.awt.Color.white);
            return;
            }
         ColorScale thisColorScale;
         if((thisColorScale = guiControl.colorScalePane.getColorScale())!=null) thisCell.setData(theData,thisColorScale.getColor(theData));
         else thisCell.setData(null,java.awt.Color.white);
         }






 
}
