/*
 * DisplayChoiceToolbar.java
 *
 * Created on 01 October 2003, 10:56
 */

package DisplayGUI;
import Preferences.*;

/**
 *
 * @author  robinson
 */
public class DisplayChoiceToolbar extends javax.swing.JFrame implements displayParams {
    gui guiControl;
    /** Creates new form DisplayChoiceToolbar */
    public DisplayChoiceToolbar(gui parent) {
        super("Display Selection");
        guiControl=parent;
        initComponents();
    }

    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {
        buttonGroup1 = new javax.swing.ButtonGroup();
        jRadioButton = new javax.swing.JRadioButton[DisplayStatus.statusNames.length-1];

        getContentPane().setBackground(backgroundColor);
        getContentPane().setLayout(new java.awt.FlowLayout());

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

       for(int i=1;i<DisplayStatus.statusNames.length;i++) {
        jRadioButton[i-1] = new javax.swing.JRadioButton();
        jRadioButton[i-1].setFont(displayScaleFont);
        jRadioButton[i-1].setBackground(backgroundColor);

        jRadioButton[i-1].setText(DisplayStatus.statusNames[i]);
        buttonGroup1.add(jRadioButton[i-1]);
        getContentPane().add(jRadioButton[i-1]);

        switch(i) {
             case DisplayStatus.MODULE_GROUP_SELECTION:  // ModuleGroup Selection
             jRadioButton[i-1].addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                   guiControl.displayStatus.setModuleGroupSelectionMode();   
                     }
             });
             break;
             case DisplayStatus.IS_MONITOR:  // Data Manager
             jRadioButton[i-1].addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                   guiControl.displayStatus.setISMode();     
                     }
             });
             break;
             case DisplayStatus.TEST_DATA:   // Test Results
             jRadioButton[i-1].addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                    guiControl.displayStatus.setTestDataMode(-1);            
                     }
             });
             break;
             case DisplayStatus.SCTDB_DATA:    // SCTDB Data
             jRadioButton[i-1].addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                     guiControl.displayStatus.setSCTDBDataMode(-1);    
                     }
             });
             break;
             case DisplayStatus.DCS_DATA:    // DCS Data
             jRadioButton[i-1].addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                     guiControl.displayStatus.setDCSDataMode();     
                     }
             });
             break;
            case DisplayStatus.SCTDB_RODDAQ_DATA:    // SctRodDaq Archive Data
             jRadioButton[i-1].addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                     guiControl.displayStatus.setSCTDBRodDaqMode(-1);        
                     }
             });
             break;
            case DisplayStatus.IV_DATA:    // SctRodDaq Archive Data
             jRadioButton[i-1].addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                  String ivdirectory = PreferencesInterface.getInstance().getPreference(PreferencesInterface.IV_DIRECTORY);
                   if(ivdirectory.equals(PreferencesInterface.unDefinedString)) javax.swing.JOptionPane.showMessageDialog(null,"You have not defined the IV data directory. You need to do this before importing IV scan data.");                        
                     guiControl.displayStatus.setIVDataMode();           
                     }
             });
             break;
             default:
             }


          }


        int currentDisplay = guiControl.displayStatus.getStatus()-1;
        if(currentDisplay>=0) jRadioButton[currentDisplay].setSelected(true);

        pack();
        setVisible(true);
    }
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {
        setVisible(false);
    }
    
    public void setButton(int i) {
        int sel=i-1;
        if(sel>=0) jRadioButton[sel].setSelected(true);
        }
    
    
    // Variables declaration - do not modify
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JRadioButton[] jRadioButton;

    // End of variables declaration
    
}
