/*
 * ConfigurationListener.java
 *
 * 
 */

package DisplayGUI;

import Sct.IS.SctNames;
import is.*;
import rc.RCStateInfo;


public class ConfigurationListener implements InfoListener {
    
    gui guiControl;
    int runCtrl_presence=-1;

    public ConfigurationListener(gui parent) {
        guiControl=parent;
        is = GuiComponents.System.ISInterface.getInstance();
        subscribe();
    }
    
    private void subscribe() {     


        try {
           is.subscribe("ConfigurationServer","ModuleConfChangeCount",false,this);
           is.subscribe("ConfigurationServer","ModuleMappingChangeCount",false,this);
           is.subscribe("ConfigurationServer","SystemStructureChangeCount",false,this);
        } catch (RuntimeException e2) {
            System.err.println("SctGUI::ConfigurationListener::Couldn't subscribe to ConfigurationServer: " + e2.getMessage());
        }
        try {
          is.subscribe("RunCtrl","RootCtrl",false,this);
        } catch (RuntimeException e3) {
            System.err.println("SctGUI::ConfigurationListener::Couldn't subscribe to RunCtrl: " + e3.getMessage());
        }
    }
    
    void close() {


        try {
            is.unsubscribe("ConfigurationServer","ModuleConfChangeCount");
            is.unsubscribe("ConfigurationServer","ModuleMappingChangeCount");
            is.unsubscribe("ConfigurationServer","SystemStructureChangeCount");
            is.unsubscribe("RunCtrl","RootCtrl");
        } catch (RuntimeException e2) {
            System.err.println("Couldn't unsubscribe from ConfigurationServer: " + e2.getMessage());
        }
    }

    abstract class StringRunnable implements Runnable {
	protected String name;
	StringRunnable(String name) {
	    this.name = name;
	}	
    }
    
    public void infoCreated(is.InfoEvent infoEvent) {
//       javax.swing.SwingUtilities.invokeLater(new StringRunnable(infoEvent.getName()) {
//          public void run() {
//                  if(!name.equals("RunCtrl.RootCtrl")) resetDisplayConfiguration();
//             }
//        });
    }
    
    public void infoDeleted(is.InfoEvent infoEvent) {
    }
    
    public void infoUpdated(is.InfoEvent infoEvent) {
       javax.swing.SwingUtilities.invokeLater(new StringRunnable(infoEvent.getName()) {
          public void run() {
             if(!name.equals("RunCtrl.RootCtrl")) resetDisplayConfiguration();
             else {
                RCStateInfo rc = new RCStateInfo();
                GuiComponents.System.ISInterface.getInstance().getRepository().getValue(name, rc); 
// if runCtrl is alive, and before it was absent or dead, then refresh and reconfigure
                if(rc.presence==0 && runCtrl_presence!=rc.presence) {
                       GuiComponents.System.SystemInterface.getInstance().refresh();  
                       resetDisplayConfiguration();
                       }      
// if runCtrl is absent or dead, then refresh               
                if(rc.presence!=0) {
                       GuiComponents.System.SystemInterface.getInstance().refresh();   
                       }
                runCtrl_presence=rc.presence;               
                }             
             }
        });
    }


    private void resetDisplayConfiguration() {
       ConfigurationInterface.getInstance().Refresh();
       guiControl.displayStatus.setConfigurationMode(); 
       int nmods = ConfigurationInterface.getInstance().getTotalNumberOfModules();
       System.out.println("Configuration updated with "+nmods+" modules.");
       int cacheSize = nmods<200 ? 200 : nmods;
       guiControl.isInterface.setCacheSize(cacheSize);
       }
    

     private GuiComponents.System.ISInterface is;


 
}


