/*
 * ConfigFileLister.java
 *
 * Created on 27 February 2004, 13:50
 */

package DisplayGUI;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import java.util.*;
import ProdDatabase.*;

import is.*;

/**
 *
 * @author  robinson
 */
public class ConfigFileLister extends javax.swing.JFrame implements displayParams, SCTDBInfo, TestDataInfo, ListSelectionListener {
    
    DataList dataList;
    Map testMap;
    ListSelectionModel rowSM;

    private javax.swing.JButton jButton1;
    private javax.swing.JTable jTable;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JButton jButton4;
    private javax.swing.JTextField jtextField;
    private javax.swing.JLabel jLabel1,jLabel2;
    private javax.swing.JScrollPane jScrollPane1;

    String masterConfigFileName=null;

    private sctConf.Configuration config;


    /** Creates new form test */
    public ConfigFileLister(sctConf.Configuration config) {
        super("Add new module");
        this.config=config;
        initComponents();
        try {
           String ISObject = "ConfigurationServer.Filename";
           if(Sct.IS.SctNames.getISRepository().contains(ISObject)) {
                is.AnyInfo theValue = new is.AnyInfo();
                Sct.IS.SctNames.getISRepository().getValue(ISObject, theValue);
                masterConfigFileName = (String)theValue.getAttribute(0);
               System.out.println("Filename="+masterConfigFileName);
                }
        }catch(Exception e) {}

    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {
       
        java.awt.GridBagConstraints gridBagConstraints;

        jButton2 = new javax.swing.JButton();
        jButton2.setFont(displayTextFont);
        jButton4 = new javax.swing.JButton();
        jButton4.setFont(displayTextFont);

        jtextField = new javax.swing.JTextField(14);
        jtextField.setFont(displayTextFont);
        jtextField.setBackground(backgroundColor);

        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        dataList = new DataList();
        jTable = new javax.swing.JTable(dataList);
        jTable.setFont(tableFont);
        jTable.setSelectionMode(ListSelectionModel.SINGLE_INTERVAL_SELECTION);
        rowSM = jTable.getSelectionModel();
        rowSM.addListSelectionListener(this);
        jScrollPane1 = new javax.swing.JScrollPane(jTable);
        jScrollPane1.setBackground(new java.awt.Color(255, 255, 255));
        jScrollPane1.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED));
        jScrollPane1.setMinimumSize(new java.awt.Dimension(300, 150));
        jScrollPane1.setPreferredSize(new java.awt.Dimension(300, 200));
        jButton1 = new javax.swing.JButton();
        jButton1.setFont(displayTextFont);
        jButton3 = new javax.swing.JButton();
        jButton3.setFont(displayTextFont);

        getContentPane().setLayout(new java.awt.GridBagLayout());

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        jButton2.setText("Use Selected Config File");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        getContentPane().add(jButton2, gridBagConstraints);
        jButton2.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                       int selectedRow = rowSM.getMinSelectionIndex();
                       String parent = (masterConfigFileName!=null) ? (new java.io.File(masterConfigFileName)).getParent() :  null;   
                       String child = "module"+dataList.getValueAt(selectedRow,0)+".xml";                      
                       java.io.File outputFile = (parent!=null) ? new java.io.File(parent,child) : new java.io.File(child);
                       try {
                          Vector theData = GeneralUtilities.getRawData((String)GeneralUtilities.testNumberList.elementAt(selectedRow));
                          if(theData.size()<2) {
                              System.err.println("No config file available!!!");
                              return;
                              }
                          java.io.BufferedWriter out = new java.io.BufferedWriter(new java.io.FileWriter(outputFile));
                          out.write((String)theData.elementAt(1));
                          out.close();

                          config.configureModuleFromFile(outputFile.toString());

                          javax.swing.JOptionPane.showMessageDialog(null,"Added "+dataList.getValueAt(selectedRow,0));

                       }catch(Exception e) {
                          javax.swing.JOptionPane.showMessageDialog(null,"Failed to download configuration file:\n"+e.toString());
                          }
                        
                     }
             });
        jButton2.setEnabled(false);

        jButton4.setText("View Selected Config File");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHEAST;
        getContentPane().add(jButton4, gridBagConstraints);
        jButton4.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                       int selectedRow = rowSM.getMinSelectionIndex();
                       try {
                         Vector theData = GeneralUtilities.getRawData((String)GeneralUtilities.testNumberList.elementAt(selectedRow));
                         if(theData.size()>=2) guiUtilities.RawDataViewer.getInstance().showNewData(theData,"Module Condiguration Data");
                        }catch(Exception e4) {System.err.println("ERROR: Exception downloading raw data: "+e4.toString());};

                        
                     }
             });
        jButton4.setEnabled(false);


        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(jtextField, gridBagConstraints);

        jLabel1.setText("Module Serial No:");
        jLabel1.setFont(displayTextFont);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 0.2;
        getContentPane().add(jLabel1, gridBagConstraints);

        jLabel2.setText("No Data listed...");
        jLabel2.setFont(displayScaleFont);  
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new java.awt.Insets(2, 5, 0, 5);
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
//        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        getContentPane().add(jLabel2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
        gridBagConstraints.weighty = 0.6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        getContentPane().add(jScrollPane1, gridBagConstraints);

        jButton1.setText("List Available Config Files");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.weighty = 0.2;
        getContentPane().add(jButton1, gridBagConstraints);
        jButton1.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
  
                      String sn = jtextField.getText();
                      if(sn.length()!=14) {
                            javax.swing.JOptionPane.showMessageDialog(null,"Invalid serial number (not 14 digits)");
                            return;
                            }
                       try {
                           Long l = Long.valueOf(sn);
                       }catch(Exception ee) {
                            javax.swing.JOptionPane.showMessageDialog(null,"Invalid serial number (not 14 digits)");
                            return;
                            }

                       try { 
                         dataList.reTable(GeneralUtilities.getRodList(sn));
                         jLabel2.setText(dataList.getRowCount()+" configurations are available.");
                       }catch(Exception e){javax.swing.JOptionPane.showMessageDialog(null,"Failed to retrieve config files - "+e.toString());} 
                    }
             });




        jButton3.setText("Close");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHEAST;
        gridBagConstraints.weighty = 0.1;
        getContentPane().add(jButton3, gridBagConstraints);
        jButton3.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                     exitForm(null);
                     }
             });
        getContentPane().setBackground(new java.awt.Color(255, 255, 255));

        pack();
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        java.awt.Dimension WSize = getSize();
        setLocation((screenSize.width-(int)WSize.getWidth())/2,(screenSize.height-(int)WSize.getHeight())/2);
    }

    /** method required by ListSelectionListener interface */
    public void valueChanged(ListSelectionEvent e) {

              if (e.getValueIsAdjusting()) return;

              ListSelectionModel lsm = (ListSelectionModel)e.getSource();
 
        
              if (lsm.isSelectionEmpty()) {
                   jButton2.setEnabled(false);
                   jButton4.setEnabled(false);
                   return;
                   }

              jButton2.setEnabled(true);
              jButton4.setEnabled(true);
              }
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {
       setVisible(false);
    }
    



public class DataList extends javax.swing.table.AbstractTableModel {
    private String[] columnNames = {"SerialNo","Location","Date","Temperature"};
    List rows;

    public DataList() {
         rows=new ArrayList();
         }


    public void reTable(List rows) {
         this.rows=rows;
         fireTableChanged(null); // Tell the listeners a new table has arrived.
         return ;
    }



    //  Now the Implementation of the TableModel Interface
   
    public String getColumnName(int column) {
        if (columnNames[column] != null) {
            return columnNames[column];
        } else {
            return "";
        }
    }

    public Class getColumnClass(int column) {
            return getValueAt(0, column).getClass();

   }

    public boolean isCellEditable(int row, int column) {
            return false; 
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public int getRowCount() {
        return rows.size();
    }

    public Object getValueAt(int aRow, int column) {

        List theRow = (ArrayList)rows.get(aRow);
        return theRow.get(column);
    }


    public void setValueAt(Object value, int row, int column) {
        List dataRow = (List)rows.get(row);
        dataRow.set(column, value);
    }



}

    
    

    
}
