package DisplayGUI;

import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.swing.*;
import java.awt.Graphics2D.*;
import java.awt.geom.*;
import java.util.Hashtable;
import java.util.Enumeration;
import java.util.Vector;

class ColorScalePane extends JPanel implements displayParams {
    gui guiControl;
 
        FontMetrics metrics;

	int maxWidth,maxHeight;
        Dimension dim;
        Rectangle area;
        Rectangle2D.Double drawRect;
        GradientPaint colorGradient;
        boolean firstTime=true;
        int x,y;
        
        ColorScale colorScale;
        String scaleDescription;

        JMenu dataPopupMenu;
        ColorScaleManager csm;

        ColorScaleChooser colorScaleChooser;

        public ColorScalePane(gui parent){
          guiControl=parent;
          colorScale=null;
          setBackground(backgroundColor);
          dim = getSize();
          maxWidth = (int)dim.getWidth();

          setMinimumSize(new Dimension(300,60));
          setPreferredSize(new Dimension(300,60));
          setBorder(new javax.swing.border.TitledBorder(null, "Display Colour Scale", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Arial", 0, 11), new java.awt.Color(0, 0, 153)));

          csm = ColorScaleManager.getInstance();

          getColorEditorMenu();
          addMouseListener(new colorScaleMouseAdapter());

    }


    public void setColorScale() {
        TestSelection testSelection = guiControl.tablesDisplayPane.getTestSelection();
        int testIndex = (testSelection!=null) ? testSelection.getTestIndex() : -1;
        int noScans = (testSelection!=null) ? testSelection.getNoScans() : 0;
        String selectedParam = guiControl.selectorPane.getDisplayParameter();
        if(selectedParam!=null && selectedParam.equals("Analysed Data")) noScans=1;
        int parameterIndex = guiControl.selectorPane.getDisplayParameterIndex();
        int mouseOption = guiControl.selectorPane.getMouseClickIndex();
        int displayOption = guiControl.displayPane.getDisplayOption();
        int display = guiControl.displayStatus.getStatus();

        colorScale = csm.getColorScale(guiControl.displayStatus.getStatus(),testIndex,parameterIndex,mouseOption,displayOption);

        if(colorScale!=null && display==DisplayStatus.IS_MONITOR) {
          switch(noScans) {
            case 0:
               colorScale=null;
               break;
            case 1:
               colorScale.setLastPoint(1);
               colorScale.setGradientPaint(false);
               break;
            default:
               colorScale.setLastPoint(noScans);
               colorScale.setGradientPaint(true);
               }
            }


        repaint();
     }
    public void setColorScale(ColorScale colorScale) {
        this.colorScale=colorScale;
        repaint();
        } 
    public ColorScale getColorScale() {
         return colorScale;
        } 
    
    // Handles the event of the user pressing down the mouse button.
    public void mousePressed(MouseEvent e){   
    }

    // Handles the event of a user dragging the mouse while holding
    // down the mouse button.
    public void mouseDragged(MouseEvent e){
    }

    // Handles the event of a user releasing the mouse button.
    public void mouseReleased(MouseEvent e){

    }
       
     // This method is required by MouseListener.
     public void mouseMoved(MouseEvent e){ 

     }

     // These methods are required by MouseMotionListener.
     public void mouseClicked(MouseEvent e){
       }

     public void mouseExited(MouseEvent e){}
     public void mouseEntered(MouseEvent e){}
                         
     // Updates the coordinates representing the location of the current rectangle.


    public void paintComponent(Graphics g){

        super.paintComponent(g);
        

        
        Graphics2D g2 = (Graphics2D)g;
	g2.setStroke(new BasicStroke(1.0f));

        if ( firstTime ) {
            dim = getSize();
            area = new Rectangle(dim);
            maxWidth = (int)dim.getWidth();
            maxHeight = (int)dim.getHeight();
            firstTime = false;
            g2.setFont(displayTextFont);
            metrics = g2.getFontMetrics();
            x = (int)(maxWidth/2.)-colorBoxWidth/2;
            y = (int)(maxHeight/2.)-colorBoxHeight/2;


        }
        // Clears the rectangle that was previously drawn.
        g2.setPaint(Color.white);
        g2.fill(area);
        
        if(colorScale!=null) {
           colorScale.drawColorScale(g2, x, y);
           scaleDescription = colorScale.getTitle();
           g2.setFont(displayScaleFont);
           g2.setPaint(darkBlueColor);
           metrics = g2.getFontMetrics();
           String thisString = "Scale: "+scaleDescription;
           int stringWidth = metrics.stringWidth(thisString);
           int stringHeight = metrics.getHeight();
           int thisX = (int)(maxWidth/2.)-stringWidth/2;
           int thisY = (int)(maxHeight/2.)+ colorBoxHeight/2 + stringHeight + 2;
           g2.drawString(thisString,thisX,thisY);
           }


    }

    class colorScaleMouseAdapter extends java.awt.event.MouseAdapter {
            public void mouseClicked(java.awt.event.MouseEvent e) {
               switch(e.getModifiers()) {
                 case java.awt.event.InputEvent.BUTTON2_MASK:
                 case java.awt.event.InputEvent.BUTTON3_MASK:             
                   JPopupMenu pMenu = dataPopupMenu.getPopupMenu();
                   pMenu.show(e.getComponent(),e.getX(),e.getY());
                   pMenu.setInvoker(dataPopupMenu);
                 break;
                 default:
                 }
            }
    }

   private void getColorEditorMenu() {
       dataPopupMenu = new JMenu("Color Editor");
       dataPopupMenu.setFont(menuFont);

       JMenuItem item1 = new JMenuItem("Edit Display Colours/Scale...");
       item1.setFont(menuFont);
       dataPopupMenu.add(item1);
       item1.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
               if(colorScale==null) return;
               if(colorScaleChooser==null) {
                      colorScaleChooser = new ColorScaleChooser(guiControl, colorScale);
                      colorScaleChooser.setLocationRelativeTo(guiControl);
                      }
               else colorScaleChooser.showNewScale(colorScale);
               colorScaleChooser.setVisible(true);

                     }

          });  

       }

 
}
