/*
 * CalibrationControllerPanel.java
 *
 * Created on 30 July 2003, 23:01
 */

package DisplayGUI;

import javax.swing.*;
import Sct_CalibrationController.*;
import Sct.IS.SctNames;
import is.*;

/**
 *
 * @author  palmer
 * adapted for use in new GUI by Dave
 */
public class CalibrationControllerPanel2 extends javax.swing.JPanel implements InfoListener, displayParams {
    
    gui guiControl;
    CalibrationControllerStatus status;
    int currentBin=-1;
    int maxBin=-1;

    public CalibrationControllerPanel2(gui parent) {
        guiControl=parent;
        setBackground(new java.awt.Color(255, 255, 255));
        is = GuiComponents.System.ISInterface.getInstance();
        initComponents();
        myInitComponents();
        addMouseListener(new ccMouseAdapter());
    }
    
    private void myInitComponents() {     
        //Get Status from IS if it is there
        try {
            status = new CalibrationControllerStatus();
            is.getRepository().getValue(SctNames.getControlISServer() + ".Status", status);
            updateStatus();
        } catch (RuntimeException e) {
            status=null;
            System.err.println("Couldn't get CalibrationController Status: " + e.getMessage());
            updateStatus();
        }
        
        //Now subscribe to IS server
        try {
            is.subscribe(SctNames.getControlISServer(), "Status", false, this);
        } catch (RuntimeException e) {
            System.err.println("Couldn't subscribe to ControlData IS Server: " + e.getMessage());
        }

        try {
           is.subscribe("SCTAPIServer","currentBin",false,this);
           is.subscribe("SCTAPIServer","maxBin",false,this);
        } catch (RuntimeException e2) {
            System.err.println("Couldn't subscribe to SCTAPIServer: " + e2.getMessage());
        }

    }
    
    /**
     * Call this to get rid of any connections etc
     */
    void close() {
        //Unsubscribe from IS
        try {
            is.unsubscribe(SctNames.getControlISServer(), "Status");
        } catch (RuntimeException e) {
            System.err.println("Couldn't unsubscribe from ControlData IS Server: " + e.getMessage());
        }
        try {
            is.unsubscribe("SCTAPIServer","currentBin");
            is.unsubscribe("SCTAPIServer","maxBin");
        } catch (RuntimeException e2) {
            System.err.println("Couldn't unsubscribe from SCTAPIServer: " + e2.getMessage());
        }
    }
    

    private void initComponents() {//GEN-BEGIN:initComponents

        jLabel1 = new javax.swing.JLabel();
        statusField = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        testField = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        sequenceField = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        scanIndexField = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
//        currentBinField = new javax.swing.JTextField();
        progressBar = new javax.swing.JProgressBar();
//        progressBar.setIndeterminate(true);
        progressBar.setStringPainted(true);
        progressBar.setString("");
        progressBar.setMaximum(100);
        progressBar.setValue(0);
//        progressBar.setString("50 out of 100");
        progressBar.setForeground(darkBlueColor);

        setLayout(new java.awt.GridLayout(5, 2));

        setBackground(backgroundColor);
        jLabel1.setFont(displayCCBoldFont);
        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel1.setText("CalibrationController Status : ");
        add(jLabel1);

        statusField.setBackground(backgroundColor);
        statusField.setColumns(15);
        statusField.setEditable(false);
        statusField.setFont(displayCCFont);
        statusField.addMouseListener(new ccMouseAdapter());
        statusField.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(1, 1, 1, 1)));
        statusField.setDisabledTextColor(new java.awt.Color(255, 255, 255));
        add(statusField);

        jLabel2.setFont(displayCCBoldFont);
        jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel2.setText("Current Test : ");
        add(jLabel2);

        testField.setBackground(backgroundColor);
        testField.setColumns(15);
        testField.setEditable(false);
        testField.setFont(displayCCFont);
        testField.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(1, 1, 1, 1)));
        testField.setDisabledTextColor(new java.awt.Color(255, 255, 255));
        testField.addMouseListener(new ccMouseAdapter());
        add(testField);

        jLabel3.setFont(displayCCBoldFont);
        jLabel3.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel3.setText("Current Sequence : ");
        add(jLabel3);

        sequenceField.setBackground(backgroundColor);
        sequenceField.setColumns(15);
        sequenceField.setEditable(false);
        sequenceField.setFont(displayCCFont);
        sequenceField.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(1, 1, 1, 1)));
        sequenceField.setDisabledTextColor(new java.awt.Color(255, 255, 255));
        sequenceField.addMouseListener(new ccMouseAdapter());
        add(sequenceField);

        jLabel4.setFont(displayCCBoldFont);
        jLabel4.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel4.setText("Current Scan Index : ");
        add(jLabel4);

        scanIndexField.setBackground(backgroundColor);
        scanIndexField.setColumns(15);
        scanIndexField.setEditable(false);
        scanIndexField.setFont(displayCCFont);
        scanIndexField.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(1, 1, 1, 1)));
        scanIndexField.setDisabledTextColor(new java.awt.Color(255, 255, 255));
        scanIndexField.addMouseListener(new ccMouseAdapter());
        add(scanIndexField);

        jLabel5.setFont(displayCCBoldFont);
        jLabel5.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel5.setText("Scan Progress : ");
        add(jLabel5);

//        currentBinField.setBackground(backgroundColor);
//        currentBinField.setColumns(15);
//        currentBinField.setEditable(false);
//        currentBinField.setFont(displayCCFont);
//        currentBinField.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(1, 1, 1, 1)));
//        currentBinField.setDisabledTextColor(new java.awt.Color(255, 255, 255));
//        currentBinField.addMouseListener(new ccMouseAdapter());
//        add(currentBinField);
        progressBar.setBackground(backgroundColor);
//        progressBar.setEditable(false);
        progressBar.setFont(displayCCFont);
        progressBar.setBorderPainted(false);
        progressBar.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(1, 1, 1, 1)));
//        currentBinField.setDisabledTextColor(new java.awt.Color(255, 255, 255));
        progressBar.addMouseListener(new ccMouseAdapter());
        add(progressBar);



       setBorder(new javax.swing.border.TitledBorder(null, "Scan Status", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Arial", 0, 11), new java.awt.Color(0, 0, 153)));
        
    }
    
//***********************************************************************************    
    void updateStatus() {
// run this in the eventDispatching thread, because it changes the gui display
       javax.swing.SwingUtilities.invokeLater(new Runnable() {
          public void run() {  

        if (status == null) {
            statusField.setText("UNAVAILABLE");
            statusField.setForeground(java.awt.Color.red);
            guiControl.menuBar.enableCCMenuItems(false);
        } else {
            switch (status.status) {
                case CalibrationControllerStatus.LOADED:
                    statusField.setText("LOADED");
                    statusField.setForeground(darkGreenColor); // dark green
                    guiControl.menuBar.enableCCMenuItems(false);
                    break;
                case CalibrationControllerStatus.INCONTROL:
                    statusField.setText("INCONTROL");
                    statusField.setForeground(darkGreenColor);
                    guiControl.menuBar.enableCCMenuItems(true);
                    break;
                case CalibrationControllerStatus.BUSY:
                    statusField.setText("BUSY");
                    statusField.setForeground(java.awt.Color.orange);
                    guiControl.menuBar.enableCCMenuItems(false);
                    break;
		case CalibrationControllerStatus.ERROR:
                    statusField.setText("ERROR");
                    statusField.setForeground(java.awt.Color.orange);
                    guiControl.menuBar.enableCCMenuItems(false);
                    break;
                default:
                    statusField.setText("UNKNOWN");
                    statusField.setForeground(java.awt.Color.red);
                    guiControl.menuBar.enableCCMenuItems(false);
            }
            sequenceField.setText(status.currentSequence);
            testField.setText(status.currentTest);
            scanIndexField.setText(Integer.toString(status.currentScanIndex));
            guiControl.menuBar.checkCCUpdateMode(); // update status indicators
        }
          }
        });
    }

    void updateProgressBar() {
// run this in the eventDispatching thread, because it changes the gui display
       javax.swing.SwingUtilities.invokeLater(new Runnable() {
          public void run() { 
            if(maxBin==-1) progressBar.setMaximum(1000);
            else progressBar.setMaximum(maxBin);
            if(currentBin==-1) {
               progressBar.setValue(0);
               progressBar.setString("");
               }
            else {
               progressBar.setValue(currentBin);
               if(maxBin==-1) progressBar.setString(Integer.toString(currentBin));
               else {
                     progressBar.setString(Integer.toString(currentBin)+" out of "+Integer.toString(maxBin)+" bins");
                     if(maxBin==currentBin) progressBar.setForeground(darkGreenColor);
                     else progressBar.setForeground(darkBlueColor);
                    }
            }
          }
        });
    }

    
    public void infoCreated(is.InfoEvent infoEvent) {
       String objectName = infoEvent.getName();
       if(objectName.equals(SctNames.getControlISServer() + ".Status")) {
         try {
            status = new CalibrationControllerStatus();
            infoEvent.getValue(status);
            updateStatus();
            } catch (InfoNotCompatibleException e) {
            System.err.println("Unable to read IS object - not a CalibrationControllerStatus: " + e.getMessage());
            }
        }
        else { // SCTAPIServer
          try {
            is.AnyInfo theValue = new is.AnyInfo();
            infoEvent.getValue(theValue);
	    if(objectName.equals("SCTAPIServer.currentBin")) currentBin=((Integer) theValue.getAttribute(0)).intValue();
            else if(objectName.equals("SCTAPIServer.maxBin")) maxBin=((Integer) theValue.getAttribute(0)).intValue();
            updateProgressBar();
           }catch(Exception e2){ 
            System.err.println("Unable to update progressBar - "+e2.toString());
            }
           
           }
      

    }
    
    public void infoDeleted(is.InfoEvent infoEvent) {
        if(infoEvent.getName().equals(SctNames.getControlISServer() + ".Status")) {
           status=null;
           updateStatus();
           }
        else {
         currentBin=-1;
         maxBin=-1;
         updateProgressBar();
         }
    }
    
    //Pass to infoCreated
    public void infoUpdated(is.InfoEvent infoEvent) {
        infoCreated(infoEvent);
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables

    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JTextField scanIndexField;
    private javax.swing.JTextField sequenceField;
    private javax.swing.JTextField statusField;
    private javax.swing.JTextField testField;
//    private javax.swing.JTextField currentBinField;
    private javax.swing.JProgressBar progressBar;

     private GuiComponents.System.ISInterface is;

    class ccMouseAdapter extends java.awt.event.MouseAdapter {
            public void mouseClicked(java.awt.event.MouseEvent e) {
               switch(e.getModifiers()) {
                 case java.awt.event.InputEvent.BUTTON2_MASK:
                 case java.awt.event.InputEvent.BUTTON3_MASK:             
                 guiControl.menuBar.showCCPopupMenu(e);
                 break;
                 default:
                 }
            }
    }
 
}


