#ifndef SCTCONF_MARSHALLING_H
#define SCTCONF_MARSHALLING_H

#include "sctConf.hh"
#include "sctConf/configuration.h"
#include "CommonWithDsp/sctStructure.h"

ABCDModule copyILUToABCDModule(const sctConf_T_ABCDModule& iluModule) {
  ///This fails if sctStructure has been updated without updating the definition of ABCDModule in configuration.idl
  assert(sizeof(ABCDModule) == sizeof(sctConf_T_ABCDModule));
  
  return ABCDModule(reinterpret_cast<const ABCDModule&>(iluModule));
}

sctConf_T_ABCDModule* copyABCDModuleToILU(const ABCDModule &module) {

  ///This fails if sctStructure has been updated without updating the definition of ABCDModule in configuration.idl
  assert(sizeof(ABCDModule) == sizeof(sctConf_T_ABCDModule));
    
  return new sctConf_T_ABCDModule(reinterpret_cast<const sctConf_T_ABCDModule&>(module)) ;
}

SctConfiguration::SlaveConfig copyILUToSlaveConfig(sctConf_T_SlaveConfig *iluConfig) {
  SctConfiguration::SlaveConfig realConfig;

  realConfig.ipramFile = iluConfig->ipramFile;
  realConfig.idramFile = iluConfig->idramFile;
  realConfig.extFile = iluConfig->extFile;

  return realConfig;
}

SctConfiguration::RodConfig copyILUToRodConfig(sctConf_T_RodConfig *iluConfig) {
  SctConfiguration::RodConfig realConfig;

  realConfig.baseAddress = iluConfig->baseAddress;
/*   realConfig.mapSize = iluConfig->mapSize; */
  realConfig.resetLevel = iluConfig->resetLevel;
/*   realConfig.numSlaves = iluConfig->numSlaves; */

  if(iluConfig->slaves->Length() != 4) {
    throw SctConfiguration::ConfigurationException("RodConfig must contain 4 slaves!");
  }

  for(int i=0; i<4; i++) {
    realConfig.slaves[i] = copyILUToSlaveConfig(iluConfig->slaves->Nth(i));
  }

  return realConfig;
}

sctConf_T_SlaveConfig *copySlaveConfigToILU(const SctConfiguration::SlaveConfig &config) {
  sctConf_T_SlaveConfig *result = new sctConf_T_SlaveConfig;

  result->ipramFile = (char *)malloc((config.ipramFile.length()+1) * sizeof(char));
  strncpy(result->ipramFile, config.ipramFile.c_str(), config.ipramFile.length());
  result->ipramFile[config.ipramFile.length()] = 0;

  result->idramFile = (char *)malloc((config.idramFile.length()+1) * sizeof(char));
  strncpy(result->idramFile, config.idramFile.c_str(), config.idramFile.length());
  result->idramFile[config.idramFile.length()] = 0;

  result->extFile = (char *)malloc((config.extFile.length()+1) * sizeof(char));
  strncpy(result->extFile, config.extFile.c_str(), config.extFile.length());
  result->extFile[config.extFile.length()] = 0;

  return result;
}

sctConf_T_RodConfig *copyRodConfigToILU(const SctConfiguration::RodConfig &config) {
  sctConf_T_RodConfig *result = new sctConf_T_RodConfig;

  result->baseAddress = config.baseAddress;
  result->resetLevel = config.resetLevel;
/*   result->mapSize = config.mapSize; */
/*   result->numSlaves = config.numSlaves; */

  result->slaves = _sctConf_T_SlaveList_sequence::Create(4, NULL);
  result->slaves->Clear(0);

  for(int i=0; i<4; i++) {
    sctConf_T_SlaveConfig *slave = new sctConf_T_SlaveConfig;

    const SctConfiguration::SlaveConfig &conf = config.slaves[i];

    slave->ipramFile = (char *)malloc((conf.ipramFile.length()+1) * sizeof(char));
    strncpy(slave->ipramFile, conf.ipramFile.c_str(), conf.ipramFile.length());
    slave->ipramFile[conf.ipramFile.length()] = 0;

    slave->idramFile = (char *)malloc((conf.idramFile.length()+1) * sizeof(char));
    strncpy(slave->idramFile, conf.idramFile.c_str(), conf.idramFile.length());
    slave->idramFile[conf.idramFile.length()] = 0;

    slave->extFile = (char *)malloc((conf.extFile.length()+1) * sizeof(char));
    strncpy(slave->extFile, conf.extFile.c_str(), conf.extFile.length());
    slave->extFile[conf.extFile.length()] = 0;

    result->slaves->Append(slave);
  }

  return result;
}

SctConfiguration::BOCChannelConfig copyILUToBOCChannelConfig(sctConf_T_BOCChannelConfig *iluConfig) {
  SctConfiguration::BOCChannelConfig newConf;

  newConf.current = iluConfig->current;
  newConf.delay = iluConfig->delay;
  newConf.markSpace = iluConfig->markSpace;

  newConf.threshold0 = iluConfig->threshold0;
  newConf.delay0 = iluConfig->delay0;

  newConf.threshold1 = iluConfig->threshold1;
  newConf.delay1 = iluConfig->delay1;

  return newConf;
}

sctConf_T_BOCChannelConfig *copyBOCChannelConfigToILU(const SctConfiguration::BOCChannelConfig &config) {
  sctConf_T_BOCChannelConfig *res = new sctConf_T_BOCChannelConfig;

  res->current = config.current;
  res->delay = config.delay;
  res->markSpace = config.markSpace;

  res->threshold0 = config.threshold0;
  res->delay0 = config.delay0;

  res->threshold1 = config.threshold1;
  res->delay1 = config.delay1;

  return res;
}

SctConfiguration::BOCGlobalConfig copyILUToBOCGlobalConfig(sctConf_T_BOCGlobalConfig *iluConfig) {
  SctConfiguration::BOCGlobalConfig newConf;

  newConf.validMask = iluConfig->validMask;
  newConf.clockControl = iluConfig->clockControl;
  newConf.rxDataMode = iluConfig->rxDataMode;
  newConf.rxDacClear = iluConfig->rxDacClear;
  newConf.txDacClear = iluConfig->txDacClear;
  newConf.vernierFinePhase = iluConfig->vernierFinePhase;
  newConf.vernierClockPhase0 = iluConfig->vernierClockPhase0;
  newConf.vernierClockPhase1 = iluConfig->vernierClockPhase1;
  newConf.bpmClockPhase = iluConfig->bpmClockPhase;
  newConf.bregClockPhase = iluConfig->bregClockPhase;

  return newConf;
}

sctConf_T_BOCGlobalConfig *copyBOCGlobalConfigToILU(const SctConfiguration::BOCGlobalConfig &config) {
  sctConf_T_BOCGlobalConfig *res = new sctConf_T_BOCGlobalConfig;

  res->validMask = config.validMask;
  res->clockControl = config.clockControl;
  res->rxDataMode = config.rxDataMode;
  res->rxDacClear = config.rxDacClear;
  res->txDacClear = config.txDacClear;
  res->vernierFinePhase = config.vernierFinePhase;
  res->vernierClockPhase0 = config.vernierClockPhase0;
  res->vernierClockPhase1 = config.vernierClockPhase1;
  res->bpmClockPhase = config.bpmClockPhase;
  res->bregClockPhase = config.bregClockPhase;

  return res;
}

SctConfiguration::TimConfig copyILUToTimConfig(sctConf_T_TimConfig *iluConfig) {
  SctConfiguration::TimConfig result;

  result.baseAddress = iluConfig->baseAddress;
/*   result.mapSize = iluConfig->mapSize; */
  result.trigFrequency = iluConfig->trigFrequency;
  result.resetFrequency = iluConfig->resetFrequency;

  return result;
}

sctConf_T_TimConfig *copyTimConfigToILU(const SctConfiguration::TimConfig &config) {
  sctConf_T_TimConfig *res = new sctConf_T_TimConfig;

  res->baseAddress = config.baseAddress;
/*   res->mapSize = config.mapSize; */
  res->trigFrequency = config.trigFrequency;
  res->resetFrequency = config.resetFrequency;

  return res;
}

#endif //SCTCONF_MARSHALLING_H
