#include <ipc/object.h>
#include <ipc/server.h>

#include "sctConf.hh"

#include "sctConf/configXMLImpl.h"

#include <is/isinfo.h>
#include <rc/RCStateInfo.h>
#include <memory>

class ConfigServer : public IPCObject, public virtual sctConf_T_Configuration {
  /// Implementation 
  ConfigurationXMLImpl config;
  std::auto_ptr<ISInfoReceiver> infoReceiver;     ///<IS InfoReceiver for RC events
  RCStateInfo::activity_E lastState;		  ///< previous RC state

 public:

  ConfigServer(const char* oid, IPCServer* server); //  : IPCObject(oid, server) {
  virtual ~ConfigServer();		// destructor
  
  void RCEvent(const RCStateInfo& info);	//Handle RC events

 // methods

  virtual sctConf_T_PartitionList listPartitions (sctConfStatus *_status);
  virtual sctConf_T_CrateList listCratesInPartition (sctConfStatus *_status, ilu_Cardinal partition);
  virtual ilu_Boolean isDummyCrate (sctConfStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate);
  virtual sctConf_T_RodList listRodsInCrate (sctConfStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate);
  virtual sctConf_T_MURList listMURSInRod (sctConfStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod);
  virtual sctConf_T_ModuleList listModulesInMUR (sctConfStatus *_status, ilu_Cardinal partition, ilu_Cardinal MUR);
  virtual sctConf_T_ModuleList listRModulesInMUR (sctConfStatus *_status, ilu_Cardinal partition, ilu_Cardinal MUR);
  virtual sctConf_T_ModuleList listAllModules (sctConfStatus *_status);
  virtual sctConf_T_ModuleList listUnusedModules (sctConfStatus *_status);
  virtual sctConf_T_ABCDModule * getModuleConfig (sctConfStatus *_status, ilu_T_CString mod);
  virtual ilu_ShortCardinal getModuleGroup (sctConfStatus *_status, ilu_T_CString mod);
  virtual void setModuleGroup (sctConfStatus *_status, ilu_T_CString mod, ilu_ShortInteger group);
  virtual sctConf_T_RodConfig * getRodConfig (sctConfStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod);
  virtual sctConf_T_SlaveConfig * getDefaultSlaveConfig (sctConfStatus *_status, ilu_Byte type);
  virtual sctConf_T_TimConfig * getTimConfig (sctConfStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate);
  virtual sctConf_T_CharBlock getFibreMappings (sctConfStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod);
  virtual void setFibreMapping (sctConfStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod, ilu_Cardinal channel, ilu_Cardinal tx, ilu_Cardinal rx0, ilu_Cardinal rx1);
  virtual sctConf_T_BOCChannelConfig * getBOCConfig (sctConfStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod, ilu_Cardinal channel);
  virtual sctConf_T_BOCGlobalConfig * getBOCGlobalConfig (sctConfStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod);
  virtual void printModuleConfig (sctConfStatus *_status, sctConf_T_ABCDModule * conf);
  virtual sctConf_T_MURType getMURType (sctConfStatus *_status, ilu_Cardinal MUR);
  virtual ilu_Cardinal getFreeMurId (sctConfStatus *_status);
  virtual void translateToROD (sctConfStatus *_status, ilu_Cardinal MUR, ilu_Cardinal mod, ilu_Cardinal * partition, ilu_Cardinal * crate, ilu_Cardinal * rod, ilu_Cardinal * channel);
  virtual void translateToRROD (sctConfStatus *_status, ilu_Cardinal MUR, ilu_Cardinal mod, ilu_Cardinal * partition, ilu_Cardinal * crate, ilu_Cardinal * rod, ilu_Cardinal * channel);
  virtual void translateToSN (sctConfStatus *_status, ilu_Cardinal MUR, ilu_Cardinal mod, ilu_T_CString * sn);
  virtual void translateToRMUR (sctConfStatus *_status, ilu_Cardinal RMUR, ilu_Cardinal rmod, ilu_Cardinal * MUR, ilu_Cardinal * mod);
  virtual void translateToBarrel (sctConfStatus *_status, ilu_Cardinal MUR, ilu_Cardinal mod, ilu_Cardinal * barrel, ilu_Cardinal * row, ilu_Integer * number);
  virtual void translateToEndcap (sctConfStatus *_status, ilu_Cardinal MUR, ilu_Cardinal mod, ilu_Integer * disk, ilu_Cardinal * ring, ilu_Cardinal * number);
  virtual void translateToPowerSupply (sctConfStatus *_status, ilu_Cardinal MUR, ilu_Cardinal mod, ilu_Cardinal * partition, ilu_Cardinal * crate, ilu_Cardinal * channel);
  virtual void translateFromROD (sctConfStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod, ilu_Cardinal channel, ilu_Cardinal * MUR, ilu_Cardinal * mod);
  virtual void translateFromRROD (sctConfStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod, ilu_Cardinal channel, ilu_Cardinal * MUR, ilu_Cardinal * mod);
  virtual void translateFromSN (sctConfStatus *_status, ilu_T_CString sn, ilu_Cardinal * MUR, ilu_Cardinal * mod);
  virtual void translateFromRMUR (sctConfStatus *_status, ilu_Cardinal MUR, ilu_Cardinal mod, ilu_Cardinal * RMUR, ilu_Cardinal * rmod);
  virtual void translateFromBarrel (sctConfStatus *_status, ilu_Cardinal barrel, ilu_Cardinal row, ilu_Integer number, ilu_Cardinal * MUR, ilu_Cardinal * mod);
  virtual void translateFromEndcap (sctConfStatus *_status, ilu_Integer disk, ilu_Cardinal ring, ilu_Cardinal number, ilu_Cardinal * MUR, ilu_Cardinal * mod);
  virtual void translateFromPowerSupply (sctConfStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal channel, ilu_Cardinal * MUR, ilu_Cardinal * mod);
  virtual void configureModuleFromStructure (sctConfStatus *_status, ilu_T_CString number, sctConf_T_ABCDModule * mConf);
  virtual void configureModuleFromFile (sctConfStatus *_status, ilu_T_CString filename);
  virtual void configureROD (sctConfStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod, sctConf_T_RodConfig * conf);
  virtual void configureTIM (sctConfStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, sctConf_T_TimConfig * conf);
  virtual void configureBOC (sctConfStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod, sctConf_T_BOCGlobalConfig * conf);
  virtual void clearAll (sctConfStatus *_status);
  virtual void namePartition (sctConfStatus *_status, ilu_Cardinal partition, ilu_T_CString name);
  virtual void mapRODMUR (sctConfStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod, ilu_Cardinal order, ilu_Cardinal number);
  virtual void unmapRODMUR (sctConfStatus *_status, ilu_Cardinal MUR);
  virtual void mapBarrelMUR (sctConfStatus *_status, ilu_Cardinal MUR, ilu_Cardinal barrel, ilu_Cardinal row, ilu_Integer position);
  virtual void unmapBarrelMUR (sctConfStatus *_status, ilu_Cardinal MUR);
  virtual void mapEndcapMUR (sctConfStatus *_status, ilu_Cardinal MUR, ilu_Integer disk, ilu_Cardinal quadrant, ilu_Cardinal position);
  virtual void unmapEndcapMUR (sctConfStatus *_status, ilu_Cardinal MUR);
  virtual void mapPowerChannel (sctConfStatus *_status, ilu_Cardinal MUR, ilu_Cardinal number, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal channel);
  virtual void unmapPowerChannel (sctConfStatus *_status, ilu_Cardinal MUR, ilu_Cardinal number);
  virtual void mapModuleMUR (sctConfStatus *_status, ilu_Cardinal MUR, ilu_Cardinal order, ilu_Cardinal RMUR, ilu_Cardinal rorder, ilu_T_CString sn);
  virtual void unmapModuleMUR (sctConfStatus *_status, ilu_Cardinal MUR, ilu_Cardinal order);
  virtual void getMapMURROD (sctConfStatus *_status, ilu_Cardinal MUR, ilu_Cardinal * partition, ilu_Cardinal * crate, ilu_Cardinal * rod, ilu_Cardinal * order);
  virtual void getMapRODMUR (sctConfStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod, ilu_Cardinal order, ilu_Cardinal * MUR);
  virtual sctConf_T_MURType getMapMURPhysical (sctConfStatus *_status, ilu_Cardinal MUR, ilu_Cardinal * plane, ilu_Cardinal * section, ilu_Cardinal * position);
  virtual void swapMURNames (sctConfStatus *_status, ilu_Cardinal MUR1, ilu_Cardinal MUR2);
  virtual void modifyDefaultPowerParam (sctConfStatus *_status, ilu_T_CString state, ilu_T_CString name, ilu_T_CString type, ilu_ShortReal value);
  virtual void modifyHVCardParam (sctConfStatus *_status, ilu_Cardinal crate, ilu_Cardinal card, ilu_T_CString name, ilu_T_CString type, ilu_ShortReal value);
  virtual void modifyLVCardParam (sctConfStatus *_status, ilu_Cardinal crate, ilu_Cardinal card, ilu_T_CString name, ilu_T_CString type, ilu_ShortReal value);
  virtual void modifyPowerParam (sctConfStatus *_status, ilu_Cardinal MUR, ilu_Cardinal number, ilu_T_CString state, ilu_T_CString name, ilu_T_CString type, ilu_ShortReal value);
  virtual void modifyPowerParamCC (sctConfStatus *_status, ilu_Cardinal crate, ilu_Cardinal channel, ilu_T_CString state, ilu_T_CString name, ilu_T_CString type, ilu_ShortReal value);
  virtual ilu_ShortReal getDefaultPowerParam (sctConfStatus *_status, ilu_T_CString state, ilu_T_CString name, ilu_T_CString type);
  virtual ilu_ShortReal getHVCardParam (sctConfStatus *_status, ilu_Cardinal crate, ilu_Cardinal card, ilu_T_CString name, ilu_T_CString type);
  virtual ilu_ShortReal getLVCardParam (sctConfStatus *_status, ilu_Cardinal crate, ilu_Cardinal card, ilu_T_CString name, ilu_T_CString type);
  virtual ilu_ShortReal getPowerParam (sctConfStatus *_status, ilu_Cardinal MUR, ilu_Cardinal number, ilu_T_CString state, ilu_T_CString name, ilu_T_CString type);
  virtual ilu_ShortReal getPowerParamCC (sctConfStatus *_status, ilu_Cardinal crate, ilu_Cardinal channel, ilu_T_CString state, ilu_T_CString name, ilu_T_CString type);
  virtual sctConf_T_NameList listDefaultPowerParams (sctConfStatus *_status);
  virtual ilu_ShortReal getCratePowerParam (sctConfStatus *_status, ilu_Cardinal crate, ilu_T_CString name);
  virtual sctConf_T_NameList listDCSChannelParams (sctConfStatus *_status);
  virtual sctConf_T_NameList listDCSCardParams (sctConfStatus *_status);
  virtual sctConf_T_NameList listDCSCrateParams (sctConfStatus *_status);
  virtual void configureBOCChannel (sctConfStatus *_status, ilu_Cardinal MUR, ilu_Cardinal position, sctConf_T_BOCChannelConfig * conf);
  virtual void loadConfiguration (sctConfStatus *_status, ilu_T_CString filename);
  virtual void saveConfiguration (sctConfStatus *_status, ilu_T_CString filename);
  virtual void saveModuleConfiguration (sctConfStatus *_status, ilu_T_CString sn, ilu_T_CString filename);
  virtual ilu_T_CString getModuleConfigurationString (sctConfStatus *_status, ilu_T_CString modsn, sctConf_T_ABCDModule * config);
  virtual void writePowerSupplyConfiguration (sctConfStatus *_status, ilu_T_CString directory);
};
