#ifndef SCTCONFIPC_CONFIGIPC_H
#define SCTCONFIPC_CONFIGIPC_H

#include <ipc/object.h>

#include "sctConf/configuration.h"
#include "sctConf.hh"

namespace SctConfiguration {

class ConfigIPC : public virtual Configuration {
  ConfigIPC(const ConfigIPC &);
  ConfigIPC &operator=(const ConfigIPC &);

/*   static Configuration *m_config; */

/*   xmlDocPtr document; */
/*   xmlXPathContextPtr xpathContext; */

/*   Log log; */

  IPCObjectVar<sctConf_T_Configuration> handle;
public:
  ConfigIPC();
  ~ConfigIPC();

  std::list<unsigned int> listPartitions();
  std::list<unsigned int> listCratesInPartition(unsigned int partition);
  std::list<unsigned int> listRodsInCrate(unsigned int partition, unsigned int crate);
  std::list<unsigned int> listMURSInRod(unsigned int partition, unsigned int crate, unsigned int rod);
  std::list<std::string> listModulesInMUR(unsigned int partition, unsigned int MUR);
  std::list<std::string> listRModulesInMUR(unsigned int partition, unsigned int MUR);
  std::list<std::string> listAllModules();
  std::list<std::string> listUnusedModules();

  bool isDummyCrate(unsigned int partition, unsigned int crate);

  ABCDModule getModuleConfig(const std::string module);
  short getModuleGroup(const std::string module);
  void setModuleGroup(const std::string module, short group);
  RodConfig getRodConfig(unsigned int partition, unsigned int crate, unsigned int rod);
  SlaveConfig getDefaultSlaveConfig(char type);
  BOCChannelConfig getBOCConfig(unsigned int partition, unsigned int crate, unsigned int rod, 
                                unsigned int channel);
  BOCGlobalConfig getBOCGlobalConfig(unsigned int partition, unsigned int crate, unsigned int rod);
  TimConfig getTimConfig(unsigned int partition, unsigned int crate);
  char *getFibreMappings(unsigned int partition, unsigned int crate, unsigned int rod);
  void setFibreMapping(unsigned int partition, unsigned int crate, unsigned int rod, 
                       unsigned int channel, unsigned int tx, unsigned int rx0, unsigned int rx1);
  void printModuleConfig(const ABCDModule &conf);
  MURType getMURType(unsigned int MUR);
  unsigned int getFreeMurId();
  void translateToROD(unsigned int MUR, unsigned int module,
		      unsigned int &partition, unsigned int &crate, 
		      unsigned int &rod, unsigned int &channel);
  void translateToRROD(unsigned int MUR, unsigned int module,
		       unsigned int &partition, unsigned int &crate, 
		       unsigned int &rod, unsigned int &channel);
  void translateToSN(unsigned int MUR, unsigned int module,
                     std::string &sn);
  void translateToRMUR (unsigned int, unsigned int, unsigned int &, unsigned int &);
  void translateToBarrel(unsigned int MUR, unsigned int module,
                         unsigned int &barrel, unsigned int &row, int &number);
  void translateToEndcap(unsigned int MUR, unsigned int module,
                         int &disk, unsigned int &ring, unsigned int &number);
  void translateToPowerSupply(unsigned int MUR, unsigned int module,
                              unsigned int &partition, 
                              unsigned int &crate, unsigned int &channel);
  void translateFromROD(unsigned int partition, unsigned int crate, 
                        unsigned int rod, unsigned int channel,
                        unsigned int &MUR, unsigned int &module);
  void translateFromRROD(unsigned int partition, unsigned int crate,
                         unsigned int rod, unsigned int channel,
                         unsigned int &MUR, unsigned int &module);
  void translateFromSN(const std::string sn,
                       unsigned int &MUR, unsigned int &module);
  void translateFromRMUR (unsigned int RMUR, unsigned int rmodule, unsigned int &MUR, unsigned int &module);
  void translateFromBarrel(unsigned int barrel, unsigned int row, int number,
                           unsigned int &MUR, unsigned int &module);
  void translateFromEndcap(int disk, unsigned int ring, unsigned int number,
                           unsigned int &MUR, unsigned int &module);
  void translateFromPowerSupply(unsigned int partition, 
                                unsigned int crate, unsigned int channel, 
                                unsigned int &MUR, unsigned int &module);
  void configureModuleFromStructure(const std::string module, const ABCDModule conf);
  void configureModuleFromFile(const std::string filename);
  void configureROD(unsigned int partition, unsigned int crate, unsigned int rod, RodConfig conf);
  void configureTIM(unsigned int partition, unsigned int crate, TimConfig conf);
  void configureBOC(unsigned int partition, unsigned int crate, unsigned int rod, const BOCGlobalConfig &conf);
  void clearAll();
  void namePartition(unsigned int partition, const std::string name);
  void configureBOCChannel(unsigned int MUR, unsigned int position, const BOCChannelConfig &conf);
  void mapModuleMUR(unsigned int MUR, unsigned int order, unsigned int RMUR, unsigned int rorder, std::string number);
  void unmapModuleMUR(unsigned int MUR, unsigned int order);
  void mapRODMUR(unsigned int partition, unsigned int crate, unsigned int rod, unsigned int order, unsigned int number);
  void unmapRODMUR(unsigned int MUR);
  void mapBarrelMUR(unsigned int MUR, unsigned int barrel, unsigned int row, int position);
  void unmapBarrelMUR(unsigned int MUR);
  void getMapMURROD(unsigned int number, unsigned int &partition, unsigned int &crate, unsigned int &rod, unsigned int &order);
  void getMapRODMUR(unsigned int partition, unsigned int crate, unsigned int rod, unsigned int order, unsigned int &number);
  void getMapMURPhysical (unsigned int, SctConfiguration::MURType &, int &, int &, int &);
  void swapMURNames(unsigned int MUR1, unsigned int MUR2);
  void mapEndcapMUR(unsigned int MUR, int disk, unsigned int quadrant, unsigned int position);
  void unmapEndcapMUR(unsigned int MUR);
  void mapPowerChannel(unsigned int MUR, unsigned int number, unsigned int partition, unsigned int crate, unsigned int channel);
  void unmapPowerChannel(unsigned int MUR, unsigned int order);

  void modifyDefaultPowerParam(std::string state, std::string name, std::string type, float value);
  void modifyHVCardParam(unsigned int crate, unsigned int card,
	                 std::string name, std::string type, float value);
  void modifyLVCardParam(unsigned int crate, unsigned int card,
	                 std::string name, std::string type, float value);
  void modifyPowerParam(unsigned int MUR, unsigned int number,
	                std::string state, std::string name, std::string type, float value);
  void modifyPowerParamCC(unsigned int crate, unsigned int channel,
	                  std::string state, std::string name, std::string type, float value);

  float getDefaultPowerParam(std::string state, std::string name, std::string type);
  float getHVCardParam(unsigned int crate, unsigned int card,
                       std::string name, std::string type);
  float getLVCardParam(unsigned int crate, unsigned int card,
                       std::string name, std::string type);
  float getPowerParam(unsigned int MUR, unsigned int number,
                      std::string state, std::string name, std::string type);
  float getPowerParamCC(unsigned int crate, unsigned int channel,
                        std::string state, std::string name, std::string type);

  std::list<std::string> listDefaultPowerParams();
  float getCratePowerParam(unsigned int crate, std::string name);
  std::list<std::string> listDCSChannelParams();
  std::list<std::string> listDCSCardParams();
  std::list<std::string> listDCSCrateParams();
  void loadConfiguration(const std::string &filename);
  void saveConfiguration(const std::string filename = "");
  void saveModuleConfiguration(const std::string modsn, const std::string filename);
  std::string getModuleConfigurationString(const std::string modsn, const ABCDModule config);
  void writePowerSupplyConfiguration(std::string filename);
};

}
#endif //SCTCONFIPC_CONFIGIPC_H
