#include <iostream>

#include <libxml/parser.h>
#include <libxml/xpath.h>
#include <libxml/xinclude.h>

static xmlDocPtr getDocument(char *fname);
static void findSomething(xmlDocPtr doc, char *exp);

int main(int argc, char **argv) {
  xmlXPathInit();

  xmlDocPtr document;
  if(argc > 2) {
    document = getDocument(argv[1]);
  } else {
    std::cout << "Usage: query xmlfile xpathQuery\n";
    throw "Goodbye";
  }

  std::cout << "Read file\n";

  if(document) {
    findSomething(document, argv[2]);
  } else {
    std::cout << "Document not parsed!\n";
  }
}

xmlDocPtr getDocument(char *filename) {
  xmlDocPtr document;

  document = xmlParseFile(filename);

  return document;
}

void findSomething(xmlDocPtr doc, char *expression) {
  xmlXPathContextPtr cntxt = xmlXPathNewContext(doc);

  std::cout << "Created xpath context\n";
  std::cout << "Expression: " << expression << std::endl;

  xmlXPathObjectPtr result 
    = xmlXPathEval((unsigned char *)expression, cntxt);

  if(result) {
    std::cout << "Got a result \n";

    if(result->type == XPATH_NODESET && result->nodesetval) {
      std::cout << "There are : " << result->nodesetval->nodeNr << " nodes\n";

      //      std::cout << "Names: \n";
      for(int i=0; i<result->nodesetval->nodeNr; i++) {
	xmlNodePtr curr = result->nodesetval->nodeTab[i];

	xmlElemDump(stdout, doc, curr);

//  	std::cout << curr->name << std::endl;
	//	std::cout << curr->content << std::endl;
      }
    } else if(result->type == XPATH_NUMBER) {
      std::cout << "number: " << result->floatval << std::endl;

//     XPATH_UNDEFINED = 0,
//     XPATH_NODESET = 1,
//     XPATH_BOOLEAN = 2,
//     XPATH_NUMBER = 3,
//     XPATH_STRING = 4,
//     XPATH_POINT = 5,
//     XPATH_RANGE = 6,
//     XPATH_LOCATIONSET = 7,
//     XPATH_USERS = 8,
//     XPATH_XSLT_TREE = 9  /* An XSLT value tree, non modifiable */

    } else {
      std::cout << "Bad type or no data\n";
      std::cout << "Type is: " << (int)result->type << std::endl;
      std::cout << "nodesetval: " << result->nodesetval << std::endl;
      std::cout << "boolval: " << result->boolval << std::endl;
      std::cout << "floatval: " << result->floatval << std::endl;
      std::cout << "stringval: " << (result->stringval?(const char *)result->stringval:"null") << std::endl;
      std::cout << "user: " << result->user << std::endl;
      std::cout << "index: " << result->index << std::endl;
      std::cout << "user2: " << result->user2 << std::endl;
      std::cout << "index2: " << result->index2 << std::endl;
    }

    xmlXPathFreeObject(result);
  } else {
    std::cout << "No result\n";
  }
}

