#include <fstream>
#include <iostream>
#include <string>

#include <libxml/parser.h>
#include <libxml/xpath.h>
#include <libxml/xinclude.h>

static xmlDocPtr getDocument(char *fname);
static void findSomething(xmlDocPtr doc, int argc, char **argv);
void printProc();
#if USE_MY_INCLUDE_MECHANISM
static void processFileLinks(xmlDocPtr doc);
#endif 

int main(int argc, char **argv) {
  xmlXPathInit();

  xmlDocPtr document;
  if(argc > 1) {
    document = getDocument(argv[1]);
  } else {
    document = getDocument("config.xml");
  }

  std::cout << "Read file\n";

  if(document) {
    printProc();

    //    processFileLinks(document);
    int includeCount = xmlXIncludeProcess(document);

    printProc();

    std::cout << "XIncludes : " << includeCount << std::endl; //processFileLinks(document);
    std::cout << "Processed hierarchy\n";
    xmlSaveFormatFile("temp.xml", document, 1);

    findSomething(document, argc-2, argv+2);
  } else {
    std::cout << "Document not parsed!\n";
  }
}

xmlDocPtr getDocument(char *filename) {
  xmlDocPtr document;

  document = xmlParseFile(filename);

  return document;
}

int decodeCommand(std::string command) {
  int type = -1;

  if(command == "module") {
    type = 0;
  } else if(command == "MUR") {
    type = 1;
  } else if(command == "rod") {
    type = 2;
  } else if(command == "MURList") {
    type = 3;
  } else if(command == "rodList") {
    type = 4;
  } else {
    std::cerr << "Unknown command type " << command << std::endl;
  }

  return type;
}

void findSomething(xmlDocPtr doc, int argc, char **argv) {
  xmlXPathContextPtr cntxt = xmlXPathNewContext(doc);

  std::cout << "Created xpath context\n";

  int type = 0;

  if(argc > 0) {
    std::string command(argv[0]);

    type = decodeCommand(command);
    std::cout << "Query type: " << type << std::endl;
  } else {
    type = 10000;
  }
  char expression[1000];

  enum {CONTENT, ATTR, XML} responseType;

  // If attr then need attribute name
  std::string responseName;

  switch(type) {
  case 0:
    // Find a module with serial number 
    sprintf(expression, "/configuration/partition/crate/rod/MUR/module[sn=\"%s\"]", argv[1]);
    responseType = XML;
    break;
  case 1:
    // Find MUR with module serial number
    sprintf(expression, "/configuration/partition/crate/rod/MUR/module[sn=\"%s\"]/ancestor::MUR", argv[1]);
    responseType = ATTR;
    responseName = "id";
    break;
  case 2:
    // Find Rod with module serial number
    sprintf(expression, "/configuration/partition/crate/rod/MUR/module[sn=\"%s\"]/ancestor::rod", argv[1]);
    responseType = ATTR;
    responseName = "id";
    break;
  case 3:
    // Get list of module serial numbers in mur number
    sprintf(expression, "/configuration/partition/crate/rod/MUR[@id=%s]/module/sn/text()", argv[1]);
    responseType = CONTENT;
    break;
  case 4:
    // Get list of module serial numbers in rod number
    sprintf(expression, "/configuration/partition/crate/rod[@id=%s]/MUR/module/sn/text()", argv[1]);
    responseType = CONTENT;
    break;
  case -1:
    sprintf(expression, "/configuration/partition/crate/rod[@id=%d]/MUR/module[@id=%d]/sn/text()", 0, 4);
    responseType = CONTENT;
    break;
  default:
    // Find the whole document
    sprintf(expression, "/configuration");
    responseType = XML;
    break;
  }

  xmlXPathObjectPtr result 
    = xmlXPathEval((unsigned char *)expression, cntxt);

  if(result) {
    std::cout << "Got a result \n";

    std::cout << "Type is: " << (int)result->type << std::endl;

    if(result->type == XPATH_NODESET && result->nodesetval) {
      std::cout << "There are : " << result->nodesetval->nodeNr << " nodes\n";

      std::cout << "Names: \n";
      for(int i=0; i<result->nodesetval->nodeNr; i++) {
	xmlNodePtr curr = result->nodesetval->nodeTab[i];

	switch(responseType) {
	case CONTENT:
	  std::cout << curr->content << std::endl;
	  break;
	case XML:
	  xmlElemDump(stdout, doc, curr);
	  break;
	case ATTR:
	  std::cout << xmlGetProp(curr, (unsigned char *)responseName.c_str()) << std::endl;
	  break;
	}

      }
    } else {
      std::cout << "Bad type or no data\n";
    }

    xmlXPathFreeObject(result);
  } else {
    std::cout << "No result\n";
  }
}

void printProc() {
  std::ifstream status("/proc/self/status");

  while(status) {
    std::string line;
    getline(status, line);

    std::cout << line << std::endl;
  }
}

#if USE_MY_INCLUDE_MECHANISM

void processFileLinks(xmlDocPtr doc) {
  static xmlXPathCompExprPtr compExp = 0; 

  xmlXPathContextPtr cntxt = xmlXPathNewContext(doc);

  if(!compExp) {
    compExp = xmlXPathCompile((unsigned char *)"//include/href");
  }

  xmlXPathObjectPtr result 
    = xmlXPathCompiledEval(compExp, cntxt);

  if(result) {
    if(result->type == XPATH_NODESET) {
      for(int i=0; i<result->nodesetval->nodeNr; i++) {
	xmlNodePtr curr = result->nodesetval->nodeTab[i];
	xmlDocPtr xmlInsert = getDocument((char*)curr->children->content);

	processFileLinks(xmlInsert);

	xmlNodePtr copyOfInsert = xmlDocCopyNode(xmlInsert->children, doc, 1);

	xmlReplaceNode(curr, copyOfInsert);

	xmlFreeDoc(xmlInsert);
      }
    }

    xmlXPathFreeObject(result);
  } else {
    std::cout << "No result\n";
  }
}

#endif
