#include <oks/class.h>
#include <oks/object.h>
#include <oks/kernel.h>

int main() {
  OksKernel kernel;

  int length = strlen(getenv("TDAQ_DB_PATH"));
  const char *schema_file = "/online/schema/online.schema.xml";
  char *schema_path = new char[length + strlen(schema_file)];

  strcpy(schema_path, getenv("TDAQ_DB_PATH"));
  strcpy(schema_path+length, schema_file);

  kernel.LoadSchema(schema_path);

  // create new OKS data file
  if( kernel.NewData("newConf.xml") != OksSuccess ) return 0;

  OksClass *part_class = kernel.FindClass ("Partition"); // , kernel);

  // create new computer object and save it
  OksObject *part_obj = new OksObject(part_class, "SCTBarrelA");
//    OksData d("lnxtb01"), d2("linux");
//    host_obj->SetAttributeValue("Name", &d);
//    host_obj->SetAttributeValue("OsType", &d2);

  OksClass *det_class = kernel.FindClass("Detector");
  OksObject *det_obj = new OksObject(det_class, "SCTDetector");

  OksClass *cr_class = kernel.FindClass("Crate");
  OksObject *cr_obj = new OksObject(cr_class, "RODCrate1");

  det_obj->AddRelationshipValue("Contains", cr_obj);

  OksClass *comp_class = kernel.FindClass ("Computer"); // , kernel);

  // create new computer object and save it
  OksObject *host_obj = new OksObject(comp_class, "myPC");
  OksData d("lnxtb01"), d2("linux");
  host_obj->SetAttributeValue("Name", &d);
  host_obj->SetAttributeValue("OsType", &d2);

  kernel.SaveAllData();

  return 0;
}
