#This is an example setup script for both building from source and running the
#binary release.  

###############################
#Required variables for running
###############################

###### External Software ######

#Change this if you use gcc295
setenv CMTCONFIG i686-rh73-gcc32

# Initialise the online software
setenv TDAQ_JAVA_HOME /usr/local/j2sdk1.4.1_02 #Or set JAVA_HOME instead
setenv PATH ${TDAQ_JAVA_HOME}/bin:${PATH}
source /usr/local/atlas/tdaq/cmt/online-00-19-01/installed/setup.csh

# Setup the DataFlow software
setenv DF_INST_PATH /usr/local/atlas/tdaq/DataFlow/DF-00-05-00/installed
setenv PATH ${DF_INST_PATH}/${CMTCONFIG}/bin:${DF_INST_PATH}/share/bin:${PATH}
setenv LD_LIBRARY_PATH ${LD_LIBRARY_PATH}:${DF_INST_PATH}/${CMTCONFIG}/lib

# Setup the PVSS libraries - may not be necessary
setenv PVSS_PATH /usr/local/atlas/tdaq/dcs/pvss2_v2.12
setenv LD_LIBRARY_PATH ${LD_LIBRARY_PATH}:${PVSS_PATH}/bin
setenv PATH ${PATH}:${PVSS_PATH}/bin

#Setup ROOT
setenv ROOTSYS /usr/local/atlas/root
setenv PATH ${ROOTSYS}/bin:${PATH}
setenv LD_LIBRARY_PATH ${LD_LIBRARY_PATH}:${ROOTSYS}/lib

# Unfortunatley the online software people chose to bundle their own c++ library with their software and put it right at the beginning of LD_LIBRARY_PATH so that distros without the necessary c++ lib at CERN would still work.  However, this breaks everybody else's installation if they already have their own library which should be used in preference.  To get around this stupid stupid bug we need to kludge by adding the dir containing our libstdc++ (in our case /usr/local/lib) to the front of the search path:
setenv LD_LIBRARY_PATH /usr/local/lib:${LD_LIBRARY_PATH}

######## Our Software #########

# The following should set SCT_DAQ_ROOT to the directory this script is run from
setenv SCT_DAQ_ROOT /usr/local/atlas/SctRodDaq

#Set this to your rod configuration (or nothing for the test setup)
setenv SCTDAQ_ROD_CONFIGURATION_PATH ${SCT_DAQ_ROOT}/sctConf/newRod.xml

#Only necessary if you share your online software installation
setenv IPC_REF_FILE ${SCT_DAQ_ROOT}/ipc.ref.file

# Directory to put IS proxy files
setenv SCT_SCRATCH_DIR ${SCT_DAQ_ROOT}/scratch

# Directory to permanently save data
setenv SCT_PERSISTENT_DIR ${SCT_DAQ_ROOT}/saved_data

###############################
#Required variables for building
################################

#Add junit.jar to CLASSPATH.  You can get junit.jar from www.junit.org
#setenv CLASSPATH /my_path/to/junit.jar:$CLASSPATH

# Point to external programs 
setenv BOOSTDIR ${SCT_DAQ_ROOT}/boost/boost_1_30_2
setenv NAGDIR ${SCT_DAQ_ROOT}/Nag_C

# Point to external java jar files
setenv SCT_DAQ_EXT ${SCT_DAQ_ROOT}/ext

#####################################
#And finally, source the setup script
#####################################
cd ${SCT_DAQ_ROOT}
source setup.csh
