package is;

import java.sql.Date;
import java.sql.Time;
import java.lang.*;
import java.util.Hashtable;

/**
 * Ostream provides interface for writing of all of the mapped information attribute type to the stream.
 * @author Sergei Kolos
 */
public class Ostream
{
    private String name;
    private String type;
    private StringBuffer data;
    
    Ostream( String name, String type )
    {
	this.name = name;
	this.type = type;
	data = new StringBuffer();	
    }
    
    String getData( )
    { 
	return ( "<o c=\"" + type + "\" i=\"" + name + "\">\n" + data + "</o>" );
    }
    
    /**
     * Writes a single boolean value to this stream.
     * @param v the boolean to be written
     * @return reference to this stream object
     */
    public Ostream put( boolean v )
    {
	data.append("<a t=\"bool\">" + ( v == true ? "1" : "0" ) + "</a>\n");
	return this;
    }
    /**
     * Writes a single byte value to this stream.
     * @param v the byte to be written
     * @param sign if true the v will be interpreted as signed byte; otherwise as unsigned
     * @return reference to this stream object
     */
    public Ostream put( byte v, boolean sign )
    {
	data.append("<a t=\"" + (sign ? "s8" : "u8") + "\">" + v + "</a>\n");
	return this;
    }
    
    /**
     * Writes a single short value to this stream.
     * @param v the short to be written
     * @param sign if true the v will be interpreted as signed short; otherwise as unsigned
     * @return reference to this stream object
     */
    public Ostream put( short v, boolean sign )
    {
	data.append("<a t=\"" + (sign ? "s16" : "u16") + "\">" + v + "</a>\n");
	return this;
    }
    
    /**
     * Writes a single integer value to this stream.
     * @param v the int to be written
     * @param sign if true the v will be interpreted as signed int; otherwise as unsigned
     * @return reference to this stream object
     */
    public Ostream put( int v, boolean sign )
    {
	data.append("<a t=\"" + (sign ? "s32" : "u32") + "\">" + v + "</a>\n");
	return this;
    }
    
    /**
     * Writes a single float value to this stream.
     * @param v the float to be written
     * @return reference to this stream object
     */
    public Ostream put( float v )
    {
	data.append("<a t=\"float\">" + v + "</a>\n");
	return this;
    }
    
    /**
     * Writes a single double value to this stream.
     * @param v the double to be written
     * @return reference to this stream object
     */
    public Ostream put( double v )
    {
	data.append("<a t=\"double\">" + v + "</a>\n");
	return this;
    }

    /**
     * Writes a single string value to this stream.
     * @param v the String to be written
     * @return reference to this stream object
     */
    public Ostream put( String v )
    {
	data.append("<a t=\"string\">" + ( v == null ? "" : Util.validate( v ) ) + "</a>\n");
	return this;
    }    

    /**
     * Writes a single date value to this stream.
     * @param v the Date to be written
     * @return reference to this stream object
     */
    public Ostream put( Date v )
    {
	data.append("<a t=\"date\">" + ( v == null ? 0 : v.getTime()/1000 ) + "</a>\n");
	return this;
    }
    
    /**
     * Writes a single time value to this stream.
     * @param v the Time to be written
     * @return reference to this stream object
     */
    public Ostream put( Time v )
    {
	data.append("<a t=\"time\">" + ( v == null ? 0 : v.getTime()/1000 ) + "</a>\n");
	return this;
    }    
    
    
    /**
     * Writes an array of boolean values to this stream.
     * @param v the array of booleans to be written
     * @return reference to this stream object
     */
    public Ostream put( boolean[] v )
    {
	int length = ( v == null ? 0 : v.length );
	data.append("<a t=\"bool\" s=\"" + length + "\">");
	for( int i = 0; i < length; i++ )
	{
	    data.append(v[i] == true ? "1 " : "0 ");
	}
	data.append("</a>\n");
	return this;
    }
    
    /**
     * Writes an array of byte values to this stream.
     * @param v the array of bytes to be written
     * @param sign if true any alement of the v will be interpreted as signed byte; otherwise as unsigned
     * @return reference to this stream object
     */
    public Ostream put( byte[] v, boolean sign )
    {
	int length = ( v == null ? 0 : v.length );
	data.append("<a t=\"" + (sign ? "s8" : "u8") + "\" s=\"" + length + "\">");
	for( int i = 0; i < length; i++ )
	{
	    data.append(v[i] + " ");
	}
	data.append("</a>\n");
	return this;
    }
	
    /**
     * Writes an array of short values to this stream.
     * @param v the array of shorts to be written
     * @param sign if true any alement of the v will be interpreted as signed short; otherwise as unsigned
     * @return reference to this stream object
     */
    public Ostream put( short[] v, boolean sign )
    {
	int length = ( v == null ? 0 : v.length );
	data.append("<a t=\"" + (sign ? "s16" : "u16") + "\" s=\"" + length + "\">");
	for( int i = 0; i < length; i++ )
	{
	    data.append(v[i] + " ");
	}
	data.append("</a>\n");
	return this;
    }
    
    /**
     * Writes an array of int values to this stream.
     * @param v the array of ints to be written
     * @param sign if true any alement of the v will be interpreted as signed int; otherwise as unsigned
     * @return reference to this stream object
     */
    public Ostream put( int[] v, boolean sign )
    {
	int length = ( v == null ? 0 : v.length );
	data.append("<a t=\"" + (sign ? "s32" : "u32") + "\" s=\"" + length + "\">");
	for( int i = 0; i < length; i++ )
	{
	    data.append(v[i] + " ");
	}
	data.append("</a>\n");
	return this;
    }
    
    /**
     * Writes an array of float values to this stream.
     * @param v the array of floats to be written
     * @return reference to this stream object
     */
    public Ostream put( float[] v )
    {
	int length = ( v == null ? 0 : v.length );
	data.append("<a t=\"float\" s=\"" + length + "\">");
	for( int i = 0; i < length; i++ )
	{
	    data.append(v[i] + " ");
	}
	data.append("</a>\n");
	return this;
    }
    
    /**
     * Writes an array of double values to this stream.
     * @param v the array of doubles to be written
     * @return reference to this stream object
     */
    public Ostream put( double[] v )
    {
	int length = ( v == null ? 0 : v.length );
	data.append("<a t=\"double\" s=\"" + length + "\">");
	for( int i = 0; i < length; i++ )
	{
	    data.append(v[i] + " ");
	}
	data.append("</a>\n");
	return this;
    }

    /**
     * Writes an array of string values to this stream.
     * @param v the array of Strings to be written
     * @return reference to this stream object
     */
    public Ostream put( String[] v )
    {
	int length = ( v == null ? 0 : v.length );
	data.append("<a t=\"string\" s=\"" + length + "\">");
	for( int i = 0; i < length; i++ )
	{
	    data.append("\"" + Util.validate( v[i] ) + "\" ");
	}
	data.append("</a>\n");
	return this;
    }
    
    /**
     * Writes an array of date values to this stream.
     * @param v the array of Dates to be written
     * @return reference to this stream object
     */
    public Ostream put( Date[] v )
    {
	int length = ( v == null ? 0 : v.length );
	data.append("<a t=\"date\" s=\"" + length + "\">");
	for( int i = 0; i < length; i++ )
	{
	    data.append(v[i].getTime()/1000 + " ");
	}
	data.append("</a>\n");
	return this;
    }
    
    /**
     * Writes an array of time values to this stream.
     * @param v the array of Times to be written
     * @return reference to this stream object
     */
    public Ostream put( Time[] v )
    {
	int length = ( v == null ? 0 : v.length );
	data.append("<a t=\"time\" s=\"" + length + "\">");
	for( int i = 0; i < length; i++ )
	{
	    data.append(v[i].getTime()/1000 + " ");
	}
	data.append("</a>\n");
	return this;
    }
}
