#!/usr/bin/perl -w

my $libprefix = "lib";
my $libsuffix = ".so";
my $separator = "/";
my @dirs;
my @libs;

sub main() {
	handle_args();
	form_depends();
	return 0;
}

sub handle_args() {
	if (@ARGV < 1) {print_help();}
	foreach $element (split(/ /, $ARGV[0])) {
		if ($element =~ /^-L(.*)/) {
			push @dirs, $1;
		} elsif ($element =~ /^-l(.*)/) {
			push @libs, ${libprefix}.${1}.${libsuffix};
		} #ignore everything else
	}	
}

sub form_depends() {
	my $s = "";
	foreach $mylib (@libs) {
		$s .= " " . search_lib($mylib);	
	}
	print "$s\n";
}

sub search_lib() {
	foreach $mydir (@dirs) {
		if (-e ${mydir}.${separator}.${_[0]}) {return ${mydir}.${separator}.${_[0]};}
	}
	#print "Library $_[0] not found in path\n";
	#exit(2);
}

sub print_help() {
	print "Generates a list of library dependancies by finding where the libraries included are.
It takes 1 argument - the contents of the LDLIBS variable and outputs on standard out
Example, given:
	dependlibs.pl '-L/path -ldostuff'
Output might be:
	/path/libdostuff.so
";
	exit(1);
}

main();

