#include <iostream>
#include "SctData/FitScanResult.h"
#include "SctData/ScanHeader.h"
#include "SctData/ScanPoints.h"
#include "SctData/ModuleConfiguration.h"
#include "SctData/mVThresholdVariable.h"
#include "SctData/FitObject.h"
#include "Sct/IS/IOManagerIS.h"
#include "Sct/IS/IONameIS.h"
#include "Sct/SctNames.h"

/**
 * @author Alan Barr 
 * @date 6 December 2002
 * A very simple test of the FitObject Class
 */

using namespace std;
using namespace SctData;
using namespace Sct;
using namespace Sct::IS;

int main(int argc, char** argv) {

	try {
  // create a Scan object, with scan Number, run number, module number and scantype.
  ScanHeader* scan = new ScanHeader(100, 1000, "TestFitScanResult", mVThresholdVariable::instance());
	cout << "Scan: "<< scan << endl;
	ModuleConfiguration* config = new ModuleConfiguration();
	ScanPoints pts;
	for (int i=0; i<64; ++i) {
		pts.addPoint(i, 10000, 0);
	}
  {
    // create a FitScanResult object from this Scan object
    FitScanResult data(*scan, *config, pts);
    
    cout <<" scanheader named: " << data.getHeader().getUniqueID()<<endl;
    cout <<" data named: " << data.getUniqueID()<<endl;
    
    data.getLinkFit(0)->setParameter(0,0.5555);
    data.getLinkFit(1)->setParameter(1,0.452);
    data.getLinkFit(1)->setParName(2,"Sig");
    
    for (int i=0 ; i<12 ; ++i ){
      data.getChipFit(i)->setParameter(0,i);
      data.getChipFit(i)->setParameter(1,0.5*i);
      
    }
    
    cout << "linkfit 1 (1) = " <<data.getLinkFit(1)->getParameter(1)<<endl;
    
    // This should not compile: private constructor
    //FitScanResult datatwo(*scan, *config);
    
    // publish the object:
    IOManagerIS::instance().write(data);
    //ISInfo::Status result = data.publish("FittedData");
    //if (result != ISInfo::Success) cout << "Error publishing object "
	//				<< data.getName()<<endl;
    cout << "publishing done!" << endl;
  }
  
  // all previous stuff out of scope...
  {
    
    
    string s = FitScanResult::getUniqueID(*scan);
    IONameIS name ("FitScanResult", s, SctNames::getFittedDataName());
    cout <<"Retrieving "<<s<<endl;
    
    //delete scan;

    Serializable* ob = IOManagerIS::instance().read(name.getName());
    
    if (!ob) {
      cerr<<"couldn't retrieve from IS."<<endl;
      return -2;
    }
    
    FitScanResult* f = dynamic_cast<FitScanResult*>(ob);
    
    if (f == 0) {
      cerr <<"The object you asked for wasn't a FitScanResult!"<<endl;
      delete ob;
      return -1;
    }
    
    //Do stuff with f
    
    cout << "Found scan:" << (*f) << endl;
    cout << "linkfit 1 (1) = " <<f->getLinkFit(1)->getParameter(1)<<endl; 
  }
  } catch (exception &e) {
	  cout << "Exception: " << e.what() << endl;
  } catch (...) {
	 cout <<"Um, got here" << endl;
  }	  
	 
  return 0;
}
