#include "Archiving.h"
#include "SctData/RawScanResult.h"
#include <vector>
#include <string>
#include <is/isinfo.h>
#include <fstream>
#include <iostream>
#include <TSystem.h>
#include <TH1.h>
#include <TH2.h> 
#include <TObjString.h>
#include <TDirectory.h>
#include <TList.h>
#include <TFile.h>
#include "SctData/ModuleConfiguration.h"
#include "Sct/IS/IOManagerIS.h"
#include "Sct/SctNames.h"
//#include "Sct/shared_ptr_utility.h"
//#include "ArchTestNames.h"
#include "ArchScanNames.h"
#include <sys/types.h>
#include <sys/dir.h>
#include <stdio.h>
#include <sys/param.h>
#include <unistd.h>


using namespace SctData;
using namespace Sct;
using namespace Sct::IS;
using namespace boost;
using namespace std;


/********************************** Archiving Methods Definitions ************************/




Archiving::Archiving() {

  //cout << " I am in Archiving Default Constructor" << endl;
  
    //Prevent ROOT stealing our histograms!
    TH1::AddDirectory(kFALSE);
}


Archiving::~Archiving() {

  //cout << " I am in Archiving Destructor" << endl;
  
}


void Archiving::SetUNIXDir()  {
  
  
  cout <<"Making DataArchive UNIX dir" <<endl;
  char *path = "DataArchive";
  //const char *currentDir = gSystem->pwd();
  //OLD gSystem->cd("../");
  string archivingDirName = getenv("SCT_DAQ_ROOT");
  archivingDirName = archivingDirName + "/archiving";
  gSystem->cd(archivingDirName.c_str());
  
  const char *ArchDir =gSystem->pwd();
  
  char* DirTest = strstr(ArchDir,path);
  if(DirTest != NULL) { return; }

  int okdir;
  bool okcd;
  okcd = gSystem->cd(path);
  //cout<< "okcd = " << okcd  <<  endl;
  if (okcd == 0) {
	 cout<< " Dir "<< *path << " doesn't exists" <<  endl;
  	 okdir = gSystem->mkdir(path);
	 okcd = gSystem->cd(path);
  }
  //this_path = gSystem->pwd();
  
  
}



void Archiving::DeleteISObj(char* objName) {

	
        IPCPartition& p = SctNames::getPartition();
	ISInfoDictionary    id(p);
	ISInfo::Status result;

	cout << "About to DELETE obj " <<  objName <<endl;


	bool myresult=id.contains(objName);
	//cout<<"myresult = "<<myresult<<endl;;
        if (myresult != true) {
	  cout << "!!!!Obj Not Found in Dictionary" << endl;
	  return;
	}
	if (myresult == true) {
	  cout << "))))))Obj Found in Dictionary" << endl;
	  result = id.remove(objName);
          if (result != ISInfo::Success) {
	    cout << "!!!!ERROR deleting object:" << endl;
	    if (result == ISInfo::NotFound) {
	      cout << "!!!!Obj Not Found in Dictionary" << endl;
	    }else{
	      cout << "!!!!Unrecognised error" << endl;
	    }
	  }
	  if (result == ISInfo::Success) cout << "))))))OBJ DELETED" << endl;
	  
	}
	
  

}



void Archiving::ListISObj() {

  
  IPCPartition& p = SctNames::getPartition();
  
  

  ISInfoIterator iter1(p, SctNames::getEventDataName().c_str(), "SctData::RawScanResult.*");
  int count=0;
  //cout<< " " << SctNames::getEventDataName() << " Partition: " <<endl;
  while ( iter1++ ) {
        cout << "IS RawScanResult Object in EventData server " << iter1.name( ) << " created at" <<
        iter1.time( ).c_str( ) << "... " << endl;
        count++;
  }
  cout<<count<<" RawScanResult Objects in IS server"<<endl;


  ISInfoIterator iter3(p, SctNames::getFittedDataName().c_str(), "SctData::FitScanResult.*");
  count=0;
  //cout<< " " << SctNames::getFittedDataName() << " Partition: " <<endl;
  while ( iter3++ ) {
    cout << "IS FitScanResult Object in FittedData server " << iter3.name( ) << " created at" <<
      iter3.time( ).c_str( ) << "... " << endl;
    count++;
  }
  cout<<count<<" FitScanResult Objects in IS FittedData server"<<endl;


  
  //------------- NoiseOccupancyTestResult ------------------------------------
  ISInfoIterator iter4(p, SctNames::getTestDataName().c_str(), "SctData::NoiseOccupancyTestResult.*");
  count=0;
  while ( iter4++ ) {
    cout << "IS NoiseOccupancyTestResult Object in TestData server " << iter4.name( ) << " created at" <<
      iter4.time( ).c_str( ) << "... " << endl;
    count++;
  }
  cout<<count<<" NoiseOccupancyTestResult Objects in IS TestData server"<<endl;
  
 
  
  //--------------------- NPtGainTestResult --------------------------------------
  ISInfoIterator iter5(p, SctNames::getTestDataName().c_str(), "SctData::NPtGainTestResult.*");
  count=0;
  //cout<< " " << SctNames::getTestDataName() << " Partition: " <<endl;
  while ( iter5++ ) {
    cout << "IS NPtGainTestResult Object in TestData server " << iter5.name( ) << " created at" <<
      iter5.time( ).c_str( ) << "... " << endl;
    count++;
  }
  cout<<count<<" NPtGainTestResult Objects in IS TestData server"<<endl;



 //--------------------- TrimRangeTestResult --------------------------------------
  ISInfoIterator iter6(p, SctNames::getTestDataName().c_str(), "SctData::TrimRangeTestResult.*");
  count=0;
  //cout<< " " << SctNames::getTestDataName() << " Partition: " <<endl;
  while ( iter6++ ) {
    cout << "IS TrimRangeTestResult Object in TestData server " << iter6.name( ) << " created at" <<
      iter6.time( ).c_str( ) << "... " << endl;
    count++;
  }
  cout<<count<<" TrimRangeTestResult Objects in IS TestData server"<<endl;



 //--------------------- PipelineTestResult --------------------------------------
  ISInfoIterator iter7(p, SctNames::getTestDataName().c_str() , "SctData::PipelineTestResult.*");
  count=0;
  //cout<< " " << SctNames::getTestDataName() << " Partition: " <<endl;
  while ( iter7++ ) {
    cout << "IS PipelineTestResult Object in TestData server " << iter7.name( ) << " created at" <<
      iter7.time( ).c_str( ) << "... " << endl;
    count++;
  }
  cout<<count<<" PipelineTestResult Objects in IS TestData server"<<endl;


 //--------------------- TimeWalkTestResult --------------------------------------
  ISInfoIterator iter8(p, SctNames::getTestDataName().c_str() , "SctData::TimeWalkTestResult.*");
  count=0;
  //cout<< " " << SctNames::getTestDataName() << " Partition: " <<endl;
  while ( iter8++ ) {
    cout << "IS TimeWalkTestResult Object in TestData server " << iter8.name( ) << " created at" <<
      iter8.time( ).c_str( ) << "... " << endl;
    count++;
  }
  cout<<count<<" TimeWalkTestResult Objects in IS TestData server"<<endl;

 
//--------------------- FullBypassTestResult --------------------------------------
  ISInfoIterator iter9(p, SctNames::getTestDataName().c_str(), "SctData::FullBypassTestResult.*");
  count=0;
  //cout<< " " << SctNames::getTestDataName() << " Partition: " <<endl;
  while ( iter9++ ) {
    cout << "IS FullBypassTestResult Object in TestData server " << iter9.name( ) << " created at" <<
      iter9.time( ).c_str( ) << "... " << endl;
    count++;
  }
  cout<<count<<" FullBypassTestResult Objects in IS TestData server"<<endl;


//--------------------- NMaskTestResult --------------------------------------
  ISInfoIterator iter10(p, SctNames::getTestDataName().c_str(), "SctData::NMaskTestResult.*");
  count=0;
  //cout<< " " << SctNames::getTestDataName() << " Partition: " <<endl;
  while ( iter10++ ) {
    cout << "IS NMaskTestResult Object in TestData server " << iter10.name( ) << " created at" <<
      iter10.time( ).c_str( ) << "... " << endl;
    count++;
  }
  cout<<count<<" NMaskTestResult Objects in IS TestData server"<<endl;



}



ISInfoIterator* Archiving::SetupRawIS() {

  cout << " I am SETtingUP Raw IS "<<endl; 
  IPCPartition& p = SctNames::getPartition();
  //cout << SCTNames::getEventDataName() << endl;
  ISInfoIterator iter(p, SctNames::getEventDataName().c_str(),"SctData::RawScanResult.*" ) ;
  cout << iter.entries() << " entries in SetupIS() for "<<"SctData::RawScanResult.*" << endl;
  
  ISInfoIterator *it;
  it=&iter;
  return it ;

}

ISInfoIterator* Archiving::SetupFitIS() {

  cout << " I am SETtingUP Fit IS "<<endl; 
  IPCPartition& p = SctNames::getPartition();
  //cout << SCTNames::getFittedDataName() << endl;
  ISInfoIterator iter(p, SctNames::getFittedDataName().c_str(), "FitScanResult.*") ;
  cout << iter.entries() << " entries in SetupIS() for "<< "FitScanResult.*" << endl;
  
  ISInfoIterator *it;
  it=&iter;
  return it ;

}



ISInfoIterator* Archiving::SetupNoiseOccupancyTestIS() {

  cout << " I am SETtingUP NoiseOccupancyTest IS "<<endl; 
  IPCPartition& p = SctNames::getPartition();
  ISInfoIterator iter(p, SctNames::getTestDataName().c_str(),"SctData::NoiseOccupancyTestResult.*" ) ;
  cout << iter.entries() << " entries in SetupIS() for "<< "SctData::NoiseOccupancyTestResult.*" << endl;
  
  ISInfoIterator *it;
  it=&iter;
  return it ;

}


ISInfoIterator* Archiving::SetupNPtGainTestIS() {

  cout << " I am SETtingUP NPtGainTest IS "<<endl; 
  IPCPartition& p = SctNames::getPartition();
  ISInfoIterator iter(p, SctNames::getTestDataName().c_str(),"SctData::NPtGainTestResult.*" ) ;
  cout << iter.entries() << " entries in SetupIS() for "<< "SctData::NPtGainTestResult.*" << endl;
  
  ISInfoIterator *it;
  it=&iter;
  return it ;

}


ISInfoIterator* Archiving::SetupStrobeDelayTestIS() {

  cout << " I am SETtingUP StrobeDelayTest IS "<<endl; 
  IPCPartition& p = SctNames::getPartition();
  ISInfoIterator iter(p, SctNames::getTestDataName().c_str(),"SctData::StrobeDelayTestResult.*" ) ;
  cout << iter.entries() << " entries in SetupIS() for "<< "SctData::StrobeDelayTestResult.*" << endl;
  
  ISInfoIterator *it;
  it=&iter;
  return it ;

}


ISInfoIterator* Archiving::SetupTrimRangeTestIS() {

  cout << " I am SETtingUP TrimRangeTest IS "<<endl; 
  IPCPartition& p = SctNames::getPartition();
  ISInfoIterator iter(p, SctNames::getTestDataName().c_str(),"SctData::TrimRangeTestResult.*" ) ;
  cout << iter.entries() << " entries in SetupIS() for "<< "SctData::TrimRangeTestResult.*" << endl;
  
  ISInfoIterator *it;
  it=&iter;
  return it ;

}


ISInfoIterator* Archiving::SetupPipelineTestIS() {

  cout << " I am SETtingUP PipelineTest IS "<<endl; 
  IPCPartition& p = SctNames::getPartition();
  ISInfoIterator iter(p, SctNames::getTestDataName().c_str(),"SctData::PipelineTestResult.*" ) ;
  cout << iter.entries() << " entries in SetupIS() for "<< "SctData::PipelineTestResult.*" << endl;
  
  ISInfoIterator *it;
  it=&iter;
  return it ;

}


ISInfoIterator* Archiving::SetupTimeWalkTestIS() {

  cout << " I am SETtingUP TimeWalkTest IS "<<endl; 
  IPCPartition& p = SctNames::getPartition();
  ISInfoIterator iter(p, SctNames::getTestDataName().c_str(),"SctData::TimeWalkTestResult.*" ) ;
  cout << iter.entries() << " entries in SetupIS() for "<< "SctData::TimeWalkTestResult.*" << endl;
  
  ISInfoIterator *it;
  it=&iter;
  return it ;

}

ISInfoIterator* Archiving::SetupFullBypassTestIS() {

  cout << " I am SETtingUP FullBypassTest IS "<<endl; 
  IPCPartition& p = SctNames::getPartition();
  ISInfoIterator iter(p, SctNames::getTestDataName().c_str(),"SctData::FullBypassTestResult.*" ) ;
  cout << iter.entries() << " entries in SetupIS() for "<< "SctData::FullBypassTestResult.*" << endl;
  
  ISInfoIterator *it;
  it=&iter;
  return it ;

}


ISInfoIterator* Archiving::SetupNMaskTestIS() {

  cout << " I am SETtingUP NMaskTest IS "<<endl; 
  IPCPartition& p = SctNames::getPartition();
  ISInfoIterator iter(p, SctNames::getTestDataName().c_str(),"SctData::NMaskTestResult.*" ) ;
  cout << iter.entries() << " entries in SetupIS() for "<< "SctData::NMaskTestResult.*" << endl;
  
  ISInfoIterator *it;
  it=&iter;
  return it ;

}


IPCPartition* Archiving::GetPartition() {

  IPCPartition& p = SctNames::getPartition();
  return &p;

}



string Archiving::GetRawISUniqueID(unsigned int runNumber, unsigned int scanNumber, const string& moduleName) {

  ScanHeader s;
  string tmp_rawISname = s.getUniqueID(runNumber, scanNumber, moduleName);
  string rawISname = SctNames::getEventDataName();// + "SctData::RawScanResult."; 
  string str_rawdata = ".SctData::RawScanResult.";
  rawISname = rawISname + str_rawdata;
  rawISname = rawISname + tmp_rawISname;

  return rawISname;

}



string Archiving::GetFitISUniqueID(unsigned int runNumber, unsigned int scanNumber, const string& moduleName) {

  ScanHeader s;
  string tmp_fitISname = s.getUniqueID(runNumber, scanNumber, moduleName);
  string fitISname = SctNames::getFittedDataName();// + "SctData::FitScanResult.";
  string str_fitdata = ".SctData::FitScanResult.";
  fitISname = fitISname + str_fitdata;
  fitISname = fitISname + tmp_fitISname;
  return fitISname;

}



shared_ptr<Serializable> Archiving::ISRetrieveObj(ISInfoIterator& it) {

  cout << "IS obj name = " << it.name() <<endl;
  cout << "IS obj type = "<< it.type().name() << endl;
  cout << it.entries() << " objects in IS server" << endl;
  //ISInfo::Status result;
  cout <<"About to RETRIEVE Serializable obj From IS " <<endl;
  shared_ptr<Serializable> ob = IOManagerIS::instance().read(it);
  cout<<"I am here" <<endl;
  //Serializable* ob2 = shared_ptr_release(ob);
  cout<<"I am here" <<endl;
  
  return ob;
}


shared_ptr<Serializable> Archiving::ISRetrieveObj(const string& SerISName) {
   
  cout <<"About to RETRIEVE Serializable obj From IS : " << SerISName << endl;
  shared_ptr<Serializable> ob = IOManagerIS::instance().read(SerISName);
  //shared_ptr<Serializable> ob2 = shared_ptr_release(ob);
  cout<<"Obj succesfully retrieved"<<endl;
  return ob;
}


shared_ptr<ScanResult> Archiving::ISRetrieveScanResult(const string& ScanISName) {

  shared_ptr<Serializable> ob = ISRetrieveObj(ScanISName);
  shared_ptr<ScanResult> scan = boost::dynamic_pointer_cast<ScanResult>(ob);  //If not ScanResult type => scan=0
  
  
  return scan;
}

shared_ptr<ScanResult> Archiving::ISRetrieveScanResult(ISInfoIterator& it) {
  shared_ptr<Serializable> ob = ISRetrieveObj(it);
  shared_ptr<ScanResult> scan = boost::dynamic_pointer_cast<ScanResult>(ob);  //If not ScanResult type => scan=0
  return scan;
}


shared_ptr<RawScanResult> Archiving::ISRetrieveRawScanResult(const string& RawISName) {
    shared_ptr<Serializable> ob = ISRetrieveObj(RawISName);      
  shared_ptr<RawScanResult> raw = boost::dynamic_pointer_cast<RawScanResult>(ob); //If not RawScanResult type => raw=0  
  return raw;
}

shared_ptr<RawScanResult> Archiving::ISRetrieveRawScanResult(ISInfoIterator& it) {
  shared_ptr<Serializable> ob = ISRetrieveObj(it);  
   shared_ptr<RawScanResult> raw = boost::dynamic_pointer_cast<RawScanResult>(ob); //If not RawScanResult type => raw=0
  return raw;
}


shared_ptr<FitScanResult> Archiving::ISRetrieveFitScanResult(const string& FitISName) {
  shared_ptr<Serializable> ob = ISRetrieveObj(FitISName);
  shared_ptr<FitScanResult> fit =boost::dynamic_pointer_cast<FitScanResult>(ob); //If not FitScanResult type => fit=0
  return fit;
}


shared_ptr<FitScanResult> Archiving::ISRetrieveFitScanResult(ISInfoIterator& it) {
  shared_ptr<Serializable> ob = ISRetrieveObj(it);
  shared_ptr<FitScanResult> fit = boost::dynamic_pointer_cast<FitScanResult>(ob); //If not FitScanResult type => fit=0  
  return fit;
}


void Archiving::ISSendPersScanResult(RawScanResult & r) {
	

  if( &r == 0) {
    cout<<" Error in publishing RawScanResult obj " <<endl;
    return;
  }
  
  cout << "About to PUBLISH obj "<<r.getClassName().c_str()<<"."<< r.getHeader().getUniqueID().c_str()  << endl;
  //Publish the object
  IPCPartition& p = SctNames::getPartition(); 
  ISInfoDictionary id(p);
  string tmp_thisobjName;
  tmp_thisobjName = SctNames::getEventDataName();
  tmp_thisobjName = tmp_thisobjName + ".";
  //string tmp_thisobjName = "EventData.";                           
  const string thisobjName = tmp_thisobjName + r.getClassName() + "." + r.getHeader().getUniqueID();
  bool myresult=id.contains(thisobjName.c_str()); 
  cout<< "UniqueID = " << thisobjName.c_str() <<endl;
  cout<<" myresult = "<< myresult <<endl;
  
  if (myresult == 1) {
    cout << "!!!!!Obj "<<r.getClassName().c_str()<<"."<<r.getHeader().getUniqueID().c_str() << " Not Published: already in Dictionary" << endl;
    return;
  }
  if (myresult == 0) {
    IOParamsIS params(SctNames::getEventDataName());
    IOManagerIS::instance().write(r, &params);
    cout << ")))))) PUBLISHED Obj "<<r.getClassName().c_str()<<"."<<r.getHeader().getUniqueID().c_str()  << endl;
  }
  

}


void Archiving::ISSendPersScanResult(FitScanResult& f) {

  
  if( &f == 0) {
    cout<<" Error in publishing FitScanResult obj " <<endl;
    return;
  }
	
  cout << "About to PUBLISH obj "<<f.getClassName().c_str()<<"."<<f.getHeader().getUniqueID().c_str()  << endl;
  //Publish the object
  IPCPartition& p = SctNames::getPartition();
  ISInfoDictionary id(p);
  string tmp_thisobjName; 
  tmp_thisobjName = SctNames::getFittedDataName();
  tmp_thisobjName = tmp_thisobjName + ".";
  //string tmp_thisobjName = "FittedData.";                          
  const string thisobjName = tmp_thisobjName + f.getClassName() + "." + f.getHeader().getUniqueID();
  cout<< "thisobjName = " <<thisobjName.c_str()<<endl;
  bool myresult=id.contains(thisobjName.c_str()); 
  cout<< "UniqueID = " << thisobjName.c_str() <<endl;
  cout<<" myresult = "<< myresult <<endl;

  if (myresult == 1) {
    cout << "!!!!!Obj " <<f.getClassName().c_str()<<"."<<f.getHeader().getUniqueID().c_str()<< " Not Published: already in Dictionary" << endl;
    return;
  }
  if (myresult == 0 ) {
    IOParamsIS params(SctNames::getFittedDataName());
    IOManagerIS::instance().write(f, &params);
    cout << ")))))) PUBLISHED Obj "<<f.getClassName().c_str()<<"."<<f.getHeader().getUniqueID().c_str()  << endl;
  }
  
  
} 


bool Archiving::IsTestInIndex(unsigned int runNumber, string moduleName, string testType) {

  /* Check if the Test is in the Index: if it is -> TRUE
                                        if it is not -> FALSE   */

  cout << "I am in IsTestInIndex() " << endl;
  ArchTestNames names(runNumber,moduleName,testType);
  string index = names.getIndexFileName(); 
  ifstream index_file;
  //MJP: ios::nocreate is non-standard, but presumably as we are reading, this
  //will just fail if the file isn't there
  index_file.open(index.c_str()); 

  string indexTestName = names.getRunID() + ".";
  indexTestName = indexTestName + names.getModuleID();
  indexTestName = indexTestName + ".";
  indexTestName = indexTestName + names.getTestType();

  int sz = 100; // Buffer size;
  char buf[sz];
  string tmp_buf;
  //int line = 0;
  while(index_file.getline(buf, sz)) {
    //line++;
    tmp_buf = buf;
    //cout << "Line = " << line << " " << tmp_buf << endl;
    int i = tmp_buf.find(indexTestName.c_str());
    if(  i != tmp_buf.npos  ) {
      cout << "Test " << indexTestName << " found in Index" <<endl;
      return true;
    }
    
  }
   cout << "Test " << indexTestName << " NOT found in Index" <<endl;
  return false;


}

bool Archiving::IsTestInIndex(string runID, string moduleID, string testType) {

  /* Check if the Test is in the Index: if it is -> TRUE
                                        if it is not -> FALSE   */

  cout << "I am in IsTestInIndex() " << endl;
  ArchTestNames names;
  string index = names.getIndexFileName(); 
  ifstream index_file;
  //MJP: ios::nocreate is non-standard, but presumably as we are reading, this
  //will just fail if the file isn't there
  index_file.open(index.c_str()); 


  string indexTestName = runID + ".";
  indexTestName = indexTestName + moduleID;
  indexTestName = indexTestName + ".";
  indexTestName = indexTestName + testType;

  int sz = 100; // Buffer size;
  char buf[sz];
  string tmp_buf;
  //int line = 0;
  while(index_file.getline(buf, sz)) {
    //line++;
    tmp_buf = buf;
    //cout << "Line = " << line << " " << tmp_buf << endl;
    int i = tmp_buf.find(indexTestName.c_str());
    if(  i != tmp_buf.npos  ) {
      cout << "Test " << indexTestName << " found in Index" <<endl;
      return true;
    }
    
  }
   cout << "Test " << indexTestName << " NOT found in Index" <<endl;
  return false;


}


bool Archiving::IsScanInIndex(unsigned int runNumber, string moduleName, string testType, unsigned int scanNumber) {

  /* Check if the Scan is in the Index: if it is -> TRUE
                                        if it is not -> FALSE   */

  cout << "I am in IsScanInIndex() " << endl;
  ArchTestNames names(runNumber,moduleName,testType);
  string index = names.getIndexFileName(); 
  ifstream index_file;
  //MJP: ios::nocreate is non-standard, but presumably as we are reading, this
  //will just fail if the file isn't there
  index_file.open(index.c_str()); 


  string scanID;
  char tmp_scanID[40];
  sprintf(tmp_scanID,"Scan%i",scanNumber);
  scanID = tmp_scanID;

  string indexScanName = names.getRunID() + ".";
  indexScanName = indexScanName + names.getModuleID();
  indexScanName = indexScanName + ".";
  indexScanName = indexScanName + names.getTestType();
  indexScanName = indexScanName + ".";
  indexScanName = indexScanName + scanID;

  int sz = 100; // Buffer size;
  char buf[sz];
  string tmp_buf;
  //int line = 0;
  while(index_file.getline(buf, sz)) {
    //line++;
    tmp_buf = buf;
    //cout << "Line = " << line << " " << tmp_buf << endl;
    int i = tmp_buf.find(indexScanName.c_str());
    if( i != tmp_buf.npos ) {
      cout << "Scan " << indexScanName << " found in Index" <<endl;
      return true;
    }
    
  }
   cout << "Scan " << indexScanName << " NOT found in Index" <<endl;
  return false;


}


bool Archiving::IsScanInIndex(string runID, string moduleID, string testType, string scanID) {

  /* Check if the Scan is in the Index: if it is -> TRUE
                                        if it is not -> FALSE   */

  cout << "I am in IsScanInIndex() " << endl;
  
  ArchTestNames names;
  string index = names.getIndexFileName(); 
  ifstream index_file;
  //MJP: ios::nocreate is non-standard, but presumably as we are reading, this
  //will just fail if the file isn't there
  index_file.open(index.c_str()); 


  

  string indexScanName = runID + ".";
  indexScanName = indexScanName + moduleID;
  indexScanName = indexScanName + ".";
  indexScanName = indexScanName + testType;
  indexScanName = indexScanName + ".";
  indexScanName = indexScanName + scanID;

  int sz = 100; // Buffer size;
  char buf[sz];
  string tmp_buf;
  //int line = 0;
  while(index_file.getline(buf, sz)) {
    //line++;
    tmp_buf = buf;
    //cout << "Line = " << line << " " << tmp_buf << endl;
    int i = tmp_buf.find(indexScanName.c_str());
    if( i != tmp_buf.npos ) {
      cout << "Scan " << indexScanName << " found in Index" <<endl;
      return true;
    }
    
  }
   cout << "Scan " << indexScanName << " NOT found in Index" <<endl;
  return false;


}


vector<string> Archiving::ListOfModulesWithinTestInIndex(string testType) {
  //cout << "I am in ListOfModulesWithinTestInIndex() " << endl;

  vector<string> ModuleList;

  ArchTestNames names;
  string index = names.getIndexFileName(); 
  ifstream index_file;
  //MJP: ios::nocreate is non-standard, but presumably as we are reading, this
  //will just fail if the file isn't there
  index_file.open(index.c_str()); 
  

  int sz = 100; // Buffer size;
  char buf[sz];
  string tmp_buf;
  int line = 0;
  while(index_file.getline(buf, sz)) {
    line++;
    tmp_buf = buf;
    //cout << "Line = " << line << " " << tmp_buf << endl;
    int i = tmp_buf.find(testType.c_str());
    //cout<<"i= "<<i<<endl;
    if (i>=0) {
      string this_ModuleName = getModuleNameFromIndex(buf);
      //cout <<"ModuleList ="<<this_ModuleName<<endl;
      ModuleList.push_back(this_ModuleName);
    }
    
    
  }
  //cout<<" ListOfModulesWithinTestInIndex is done "<<endl;
  return ModuleList;


}
vector<string> Archiving::ListOfModulesWithinTestInIndex(unsigned int runNumber, string testType) {
  //cout << "I am in ListOfModulesWithinTestInIndex() " << endl;

  vector<string> RunList;
  vector<string> ModuleList;

  ArchTestNames names(runNumber);
  string index = names.getIndexFileName(); 
  ifstream index_file;
  string runID = names.getRunID();

  //MJP: ios::nocreate is non-standard, but presumably as we are reading, this
  //will just fail if the file isn't there
  index_file.open(index.c_str()); 
  

  int sz = 100; // Buffer size;
  char buf[sz];
  string tmp_buf;
  int line = 0;
  while(index_file.getline(buf, sz)) {
    line++;
    tmp_buf = buf;
    cout << "Line = " << line << " " << tmp_buf << endl;
    int i = tmp_buf.find(runID.c_str());
    cout<<"i= "<<i<<endl;
    if (i>=0) {
      string this_runNumber = getRunNumberFromIndex(buf);
      cout <<"RunNumberList ="<<this_runNumber<<endl;
      //RunList.push_back(this_runNumber);
      int ii = tmp_buf.find(testType.c_str());
      if (ii>=0) {
	string this_ModuleName = getModuleNameFromIndex(buf);
	cout <<"ModuleList ="<<this_ModuleName<<endl;
	ModuleList.push_back(this_ModuleName);
      }
    }
    
    
  }

  
  cout<<" ListOfModulesWithinTestInIndex is done "<<endl;
  return ModuleList;


}


string Archiving::getModuleNameFromIndex(string indexLine) {

  //cout << "I am in getModuleNameFromIndex() " << endl;

  int size = indexLine.size();
  int first_dot = indexLine.find('.');
  string tmp_line = indexLine.substr(first_dot+1, size);
  int second_dot = tmp_line.find('.');
  string moduleName = tmp_line.substr(0,second_dot);
  //cout << "ModuleName = " << moduleName<<endl;
  return moduleName;

}

string Archiving::getRunNumberFromIndex(string indexLine) {

  //cout << "I am in getRunNumberFromIndex() " << endl;

  
  int first_dot = indexLine.find('.');
  string runNumber = indexLine.substr(0,first_dot);
  //cout << "RunNumber = " << runNumber<<endl;
  return runNumber;

}




vector<string> Archiving::ListOfRunsInIndex() {


  cout << "I am in ListOfRunsInIndex() " << endl;

  vector<string> RunList;

  ArchTestNames names;

  string index = names.getIndexFileName(); 
  ifstream index_file;
  //MJP: ios::nocreate is non-standard, but presumably as we are reading, this
  //will just fail if the file isn't there
  index_file.open(index.c_str()); 
  

  int sz = 100; // Buffer size;
  char buf[sz];
  string tmp_buf;
  int line = 0;
  while(index_file.getline(buf, sz)) {
    line++;
    tmp_buf = buf;
    cout << "Line = " << line << " " << tmp_buf << endl;
    string this_RunName = getRunNumberFromIndex(buf);
    cout <<"RunName ="<<this_RunName<<endl;
    if (line==1) { RunList.push_back(this_RunName); }
    vector<string> ::iterator it=RunList.begin();
    do { 
      it++ ;
      cout<<"I am here" <<endl;
      if ( (*it) == this_RunName ) {cout <<"I am breaking"<<endl; break;}
      if (it == RunList.end()) { cout <<"I am at the end-point, Run added to RunList"<<endl;RunList.push_back(this_RunName); }
    }while(it != RunList.end());
      
  }
  cout<<" ListOfTunsInIndex is done "<<endl;
  return RunList;





}


void Archiving::AddTestToIndex(string runID, string moduleID, string testTypeID)  {
  
  /* Append current Test to the Index */

  cout << "I am in AddTestToIndex() " << endl;
  ArchTestNames names;
  string index = names.getIndexFileName(); 
  ofstream index_file;
  index_file.open(index.c_str(),ios::app);  //append the Index File
  //assure(out, "Strfile.out");  //TO DO

  string indexTestName = runID + ".";
  indexTestName = indexTestName + moduleID;
  indexTestName = indexTestName + ".";
  indexTestName = indexTestName + testTypeID + ".";
  cout << indexTestName <<endl;
  //if(TestIsPersisted()) {
   index_file << indexTestName <<endl;
   cout << "Test appended to Index"<<endl;    
  //} else {
  //  cout<<"Test NOT correctly saved in the archive...test NOT added to the Index"<<endl;
  //}
  
  index_file.close(); 
  
}



void Archiving::AddScanToIndex(string runID, string moduleID, string testTypeID, string scanID )  {
  
  /* Append current Test to the Index  */

  cout << "I am in AddScanToIndex() " << endl;
  ArchTestNames names;
  string index = names.getIndexFileName(); 
  ofstream index_file;
  index_file.open(index.c_str(),ios::app);  //append the Index File
  //assure(index_file,index.c_str());  //TO DO
 
  string indexScanName = runID + ".";
  indexScanName = indexScanName + moduleID;
  indexScanName = indexScanName + ".";
  indexScanName = indexScanName + testTypeID + ".";
  indexScanName = indexScanName + scanID;
  cout << indexScanName <<endl;
  //if(ScanIsPersisted()) {
    index_file << indexScanName <<endl;
    cout << "Scan appended to Index"<<endl;    
  //} else {
  //  cout<<"Scan NOT correctly saved in the archive...test NOT added to the Index"<<endl;
  //}
  
  index_file.close(); 
  
}





void Archiving::UpdateScanIndex() {

  /* Looks into the archive and checks whether all tests have been added in the Index, if not updates the index */

  
  ArchScanNames names;
   
  //Select .root files on Unix dir
  const char* filename = NULL;
  const char *currentDir = gSystem->pwd();
  void* dirptr = gSystem->OpenDirectory(currentDir);
  bool alwaystrue = true;
  while(alwaystrue == true ){
    const char* tmp_filename = gSystem->GetDirEntry(dirptr);
    //cout << "Dir Entry : " << tmp_filename <<endl;
    if(tmp_filename == NULL) break;
    char* Runname = strstr(tmp_filename,"Run");
    char* Rootname = strstr(tmp_filename,".root");
    if(Runname != NULL && Rootname != NULL) {
      filename = tmp_filename;
      
      
      
      //Opening File
      TFile *archive_file = new TFile(filename,"read");
      if (archive_file->IsZombie() == true) {
	cout << "Problem in opening file... "<<filename<<endl; 
	exit(0);
      }
      //cout<<" File found!!"<<endl;
      
      //TDirectory *gRunDir = new TDirectory();
      TDirectory *gModuleDir = new TDirectory();
      TDirectory *gtestTypeDir = new TDirectory();
      TDirectory *gvariableDir = new TDirectory();
      TDirectory *gscanDir = new TDirectory();
      
      
      //gDirectory->ls();
      TList* runsList = gDirectory->GetListOfKeys();
      TListIter itruns(runsList);
      while (TObject *runsobj = itruns.Next()) { 
	string runID = runsobj->GetName();
	if (runsobj->GetTitle() == runID ) {
	  if (gDirectory->cd(runID.c_str())==1) {
	    
	    gModuleDir = gDirectory;
	    TList* modulesList = gDirectory->GetListOfKeys();
	    TListIter itmodules(modulesList); 
	    while (TObject *modulesobj = itmodules.Next()) { 
	      string moduleID = modulesobj->GetName();
	      string modulesobjID = modulesobj->GetTitle(); 
	      //!!if (modulesobjID.find("module") != modulesobjID.npos ) {
	      if (modulesobj->GetTitle() == moduleID ) {
		gModuleDir->cd();
		if (gDirectory->cd(moduleID.c_str())== 1) {
		  
		  gtestTypeDir = gDirectory;
		  TList* testTypeList = gDirectory->GetListOfKeys();
		  TListIter ittestType(testTypeList); 
		  while (TObject *testTypeobj = ittestType.Next()) { 
		    string testTypeID = testTypeobj->GetName();
		    if (testTypeobj->GetTitle() == testTypeID ) {
		      gtestTypeDir->cd();
		      if (gDirectory->cd(testTypeID.c_str())==1 ) {
			
			
			gvariableDir = gDirectory;
			TList* variableList = gDirectory->GetListOfKeys();
			TListIter itvariable(variableList); 
			while (TObject *variableobj = itvariable.Next()) { 
			  string variableID = variableobj->GetName();
			  if (variableobj->GetTitle() == variableID ) {
			    gvariableDir->cd();
			    if (gDirectory->cd(variableID.c_str())==1 ) {
			      gDirectory->Print();
			      
			      gscanDir = gDirectory;
			      TList* scanList = gDirectory->GetListOfKeys();
			      TListIter itscan(scanList); 
			      while (TObject *scanobj = itscan.Next()) { 
				string scanID = scanobj->GetName();
				if (scanobj->GetTitle() == scanID ) {
				  gscanDir->cd();
				  if (gDirectory->cd(scanID.c_str())==1 ) {
				    
				    
				    if ( !IsScanInIndex(runID, moduleID, testTypeID, scanID) ) {
				      AddScanToIndex(runID, moduleID, testTypeID, scanID );
				    }	
				  }
				}
			      }
			    }
			  }
			}
		      }
		    }
		  }
		}
	      }
	    }
	  }
	}
      }
      
      
   

    }
  }
    

  return;
  
  

}






void Archiving::UpdateTestIndex() {

  /* Looks into the archive and checks whether all tests have been added in the Index, if not updates the index */
  
  //Select .root files on Unix dir
  const char* cfilename = NULL;
  const char *currentDir = gSystem->pwd();
  void* dirptr = gSystem->OpenDirectory(currentDir);
  bool alwaystrue = true;
  while(alwaystrue == true ){
    const char* tmp_cfilename = gSystem->GetDirEntry(dirptr);
    //cout << "Dir Entry : " << tmp_filename <<endl;
    if(tmp_cfilename == NULL) break;
    char* Runname = strstr(tmp_cfilename,"Run");
    char* Rootname = strstr(tmp_cfilename,".root");
    if(Runname != NULL && Rootname != NULL) {
      cfilename = tmp_cfilename;
      
      
      //Open file 
      string runNo = Runname;  //  !!!!!!! just temporarly
      //string filename = "Run" + runNo + ".root"; //!!!!!!! just temporarly
      string filename = tmp_cfilename;
      
      ArchScanNames names;
      
  
      
      TFile *archive_file = new TFile(filename.c_str(),"read");
      if (archive_file->IsZombie() == true) {
	cout << "Problem in opening file..."<<endl; 
	exit(1);
      }
      cout<<" File found!!"<<endl;
      
      //TDirectory *gRunDir = new TDirectory();
      TDirectory *gModuleDir = new TDirectory();
      TDirectory *gtestTypeDir = new TDirectory();
      
      
      //gDirectory->ls();
      TList* runsList = gDirectory->GetListOfKeys();
      TListIter itruns(runsList);
      while (TObject *runsobj = itruns.Next()) { 
	//runsobj->Print();
	//cout<< "Run OBJ Name = " << runsobj->GetName() <<endl;
	string runID = runsobj->GetName();
	if (runsobj->GetTitle() == runID ) {
	  if (gDirectory->cd(runID.c_str())==1) {
	    
	    gModuleDir = gDirectory;
	    TList* modulesList = gDirectory->GetListOfKeys();
	    TListIter itmodules(modulesList); 
	    while (TObject *modulesobj = itmodules.Next()) { 
	      string moduleID = modulesobj->GetName();
	      string modulesobjID = modulesobj->GetTitle(); 
	      //!!if (modulesobjID.find("module") != modulesobjID.npos ) {
	      if (modulesobj->GetTitle() == moduleID ) {
		gModuleDir->cd();
		if (gDirectory->cd(moduleID.c_str())== 1) {
		  
		  gtestTypeDir = gDirectory;
		  TList* testTypeList = gDirectory->GetListOfKeys();
		  TListIter ittestType(testTypeList); 
		  while (TObject *testTypeobj = ittestType.Next()) { 
		    string testTypeID = testTypeobj->GetName();
		    if (testTypeobj->GetTitle() == testTypeID ) {
		      gtestTypeDir->cd();
		      if (gDirectory->cd(testTypeID.c_str())==1 ) {
			
			if ( !IsTestInIndex(runID, moduleID, testTypeID) ) {
			  AddTestToIndex(runID, moduleID, testTypeID);
			}
		      }
		    }
		  }
		}
	      }
	    }
	  }
	}
      }
    

  
    }
  }
  

  return;



}




    
/* !!!!TO DO!!!!
string* Archiving::getData(string moduleName,string runNo,string scanNo,string testName,string testParameter = "Delay") {

  string* resultParam;
  string filename = "Run" + runNo + ".root";
  string runID = "Run" + runNo;
  string scanID = "Scan" + scanNo;
  
  //Set data Archiving Unix Directory
  SetUNIXDir();

  //Look for the File
  TFile *inspect_file = new TFile(filename.c_str(),"read");
  if (inspect_file->IsZombie() == true) {
    cout << "Problem in opening file..."<<endl; 
    cout << "Such Run Number does NOT exist"<<endl;
    cout << "exiting getData..."<<endl;
    return 0;
  }
  cout<<" File found!!"<<endl;

  
  // Looking for RunNo
  TDirectory *this_run = (TDirectory*) gDirectory->Get(runID.c_str());
  cout<<"The RUN is "<< runNo <<endl;
  if (!this_run) {
    cout<<"This Run " << runNo << " deos NOT exist in  file "<< filename <<endl;
    return 0;
  }
  inspect_file->GetListOfKeys()->Print();
  this_run->cd();  //make this_run the current directory
  cout<<" Run Number found!!"<<endl;


  // Looking for ModuleName
  TDirectory* this_module = (TDirectory*) gDirectory->Get(moduleName.c_str()); 
  cout<<"The MODULE is "<< moduleName <<endl;
  if (!this_module) {
    cout<<"This Module "<< moduleName <<" does NOT exist with this Run Number"<<endl;
    return 0;
  }
  this_module->cd();  
  cout<<" Module Name found!!"<<endl;


  // Looking for Test Name  
  TDirectory* this_testType = (TDirectory*) gDirectory->Get(testName.c_str());
  cout<<"The Test is "<< testName <<endl;
  if (!this_testType) {
    cout<<"This Test "<< testName <<" does NOT exist with this Run Number and Module name"<<endl;
    return 0;
  }
  this_testType->cd();
  cout<<" Test Name found!!"<<endl;


  TDirectory* gvariableDir = gDirectory;
  TList* variableList = gDirectory->GetListOfKeys();
  TListIter itvariable(variableList); 
  while (TObject *variableobj = itvariable.Next()) { 
    string variableID = variableobj->GetName();
    if (variableobj->GetTitle() == variableID ) {
      gvariableDir->cd();
      if (gDirectory->cd(variableID.c_str())==1 ) {
	cout << gDirectory->GetPath()<<endl;
	
	// Looking for Test Name  
	TDirectory* this_scan = (TDirectory*) gDirectory->Get(scanID.c_str());
	cout<<"The Scan is "<< scanID <<endl;
	if (!this_scan) {
	  cout<<"This Scan "<< scanID <<" does NOT exist with this Run Number, Module Name and Test Name"<<endl;
 	  return 0;
	}
	this_scan->cd();
	cout<<" Scan Number found!!"<<endl;

	//!!!!To DO:Check the the first scanNumber in the test to identify uniquely the test
	
	//Looking for the Test Parameter
	if (testParameter == "Delay") {
	  

	}else {
	  cout<<"Error in input string Test Parameter: "<< testParameter <<" NOT valid"<<endl;
	  return 0;
	}


	return resultParam;

      }
    }
  }



  

}

*/



string Archiving::getTestSummaryFromArchive(unsigned int runNumber, string moduleName, string testType) {

 
  ArchTestNames *names = new  ArchTestNames(runNumber, moduleName, testType) ;
  string testSummary;
  string runID = names->getRunID();
  string moduleID = names->getModuleID();
  string filename = names->getfilename();
 

  //Set data Archiving Unix Directory
  //SetUNIXDir();


  //Look for the File
  TFile *inspect_file = new TFile(filename.c_str(),"read");
  if (inspect_file->IsZombie() == true) {
    cout << "Problem in opening file..."<<endl; 
    cout << "Such Run Number does NOT exist"<<endl;
    cout << "exiting getData..."<<endl;
    return 0;
  }
  cout<<" File found!!"<<endl;

  
  // Looking for RunNo
  TDirectory *this_run = (TDirectory*) gDirectory->Get(runID.c_str());
  cout<<"The RUN is "<< runID <<endl;
  if (!this_run) {
    cout<<"This Run " << runID << " deos NOT exist in  file "<< filename <<endl;
    return 0;
  }
  //inspect_file->GetListOfKeys()->Print();
  this_run->cd();  //make this_run the current directory
  cout<<" Run Number found!!"<<endl;


  // Looking for ModuleName
  TDirectory* this_module = (TDirectory*) gDirectory->Get(moduleID.c_str()); 
  cout<<"The MODULE is "<< moduleID <<endl;
  if (!this_module) {
    cout<<"This Module "<< moduleID <<" does NOT exist with this Run Number"<<endl;
    return 0;
  }
  this_module->cd();  
  cout<<" Module Name found!!"<<endl;


  // Looking for TestType  
  TDirectory* this_testType = (TDirectory*) gDirectory->Get(testType.c_str());
  cout<<"The Test is "<< testType <<endl;
  if (!this_testType) {
    cout<<"This Test "<< testType <<" does NOT exist with this Run Number and Module name"<<endl;
    return 0;
  }
  this_testType->cd();
  cout<<" Test Name found!!"<<endl;


 
  // Looking forTestSummery  
  TObject* pers_testSummary = gDirectory->FindObjectAny(names->getTestSummaryID().c_str());
  if (!pers_testSummary) {
    cout<<"TestSummary NEVER SAVED!!!!"<<endl;
    return 0;
  }
  TObjString* tmp_testSummary = dynamic_cast<TObjString*>(pers_testSummary);
  testSummary = tmp_testSummary->GetString().Data();
  //cout << "testSummary = " << testSummary<< endl;

  return testSummary;


}  





string Archiving::getTestSummaryFromArchive(string runID, string moduleID, string testType) {


  ArchTestNames* names;

  string testSummary;
  string filename = runID + ".root";
  
  

  //Set data Archiving Unix Directory
  //SetUNIXDir();


  //Look for the File
  TFile *inspect_file = new TFile(filename.c_str(),"read");
  if (inspect_file->IsZombie() == true) {
    cout << "Problem in opening file..."<<endl; 
    cout << "Such Run Number does NOT exist"<<endl;
    cout << "exiting getData..."<<endl;
    return 0;
  }
  cout<<" File found!!"<<endl;

  
  // Looking for RunNo
  TDirectory *this_run = (TDirectory*) gDirectory->Get(runID.c_str());
  cout<<"The RUN is "<< runID <<endl;
  if (!this_run) {
    cout<<"This Run " << runID << " deos NOT exist in  file "<< filename <<endl;
    return 0;
  }
  //inspect_file->GetListOfKeys()->Print();
  this_run->cd();  //make this_run the current directory
  cout<<" Run Number found!!"<<endl;


  // Looking for ModuleName
  TDirectory* this_module = (TDirectory*) gDirectory->Get(moduleID.c_str()); 
  cout<<"The MODULE is "<< moduleID <<endl;
  if (!this_module) {
    cout<<"This Module "<< moduleID <<" does NOT exist with this Run Number"<<endl;
    return 0;
  }
  this_module->cd();  
  cout<<" Module Name found!!"<<endl;


  // Looking for TestType  
  TDirectory* this_testType = (TDirectory*) gDirectory->Get(testType.c_str());
  cout<<"The Test is "<< testType <<endl;
  if (!this_testType) {
    cout<<"This Test "<< testType <<" does NOT exist with this Run Number and Module name"<<endl;
    return 0;
  }
  this_testType->cd();
  cout<<" Test Name found!!"<<endl;


 
  // Looking forTestSummery  
  TObject* pers_testSummary = gDirectory->FindObjectAny(names->getTestSummaryID().c_str());
  if (!pers_testSummary) {
    cout<<"TestSummary NEVER SAVED!!!!"<<endl;
    return 0;
  }
  
  TObjString* tmp_testSummary = dynamic_cast<TObjString*>(pers_testSummary);
  testSummary = tmp_testSummary->GetString().Data();
  //cout << "testSummary = " << testSummary<< endl;

  return testSummary;


}
