#ifndef ArchTestResult_H
#define ArchTestResult_H

#include <vector>
#include <is/isinfo.h>
#include <boost/shared_ptr.hpp>
#include "SctData/TestResult.h"
#include "SctData/ModuleDefect.h"
#include "Sct/SctNames.h"
#include "Archiving.h"
#include "ArchRawScanResult.h"
#include "ArchFitScanResult.h"
#include "TObjString.h"

class TVectorD;


using namespace SctData;
using namespace Sct;
using boost::shared_ptr;

class ArchTestResult: public Archiving  {
  
 protected:
     
  unsigned int runNumber;
  string moduleName; 
  string testType;
  unsigned int NScans;

  ArchTestNames* names;

  vector<shared_ptr<RawScanResult> > rawScans;
  vector<shared_ptr<FitScanResult> > fitScans;
  DefectCollection defects; 
  vector<unsigned int> scanNumbers ;
  TObjString* testSummary;

  ArchTestResult(shared_ptr<TestResult>);

 public:
    
    ArchTestResult(); 
    ~ArchTestResult();
    virtual shared_ptr<ArchTestResult> clone(shared_ptr<TestResult> test) =0;
    //void SetTest(TestResult & );

    void SetRawScans();    //Stores in the vector<RawScanResult*> rawScans the Raw Scans;
    void SetFitScans();    //Stores in the vector<FitScanResult*> fitScans the Fitted Scans;

    vector<shared_ptr<const ModuleDefect> >  DeleteRepetedDefects( vector<shared_ptr<const ModuleDefect> >  defect );
    void Save();
    void RetrieveRawFitScans(); 
    void SaveRawScans();
    void SaveFitScans();
    //bool TestIsPersisted(); 
    //bool TestIsPersisted(RawScanResult& );
    //bool TestIsPersisted(string testName, long runNumber, string moduleName);
    
    void AddTestToIndex();
    //virtual void TestSummary(TestResult &) =0;

    //TestResult* CreateTestResult();
    //TestResult* CreateTestResult(RawScanResult&);
    //TestResult* CreateTestResult(long scanNumber, long runNumber, string moduleName, const ScanType& scanType);

    // void SaveFileComment();
    // void SaveRunComment();
    // void SaveModuleComment();
    // void SaveTestComment();
    // void SaveScanComment();


    

};


#endif
