#ifndef ARCHTESTHNAMES_H
#define ARCHTESTNAMES_H

#include <string>
#include "Sct/SctNames.h"

using namespace std;

/**
Thi Class provides all the names for the TestResult archiving
*/
class ArchTestNames {

 protected:
        //ArchTestNames();		//Prevent anyone making one!
	string runID ;
	string moduleID ;
	string testType;
	


 public:
	ArchTestNames();	
	ArchTestNames(const long runNumber, const string moduleName = "Undefined", const string tType = "Stand-AloneScans");    
	

	const string getfilename();
	const string getIndexFileName();
	void setModuleName(string moduleName);
	void setTestType(string tType); 
	
	static inline const string getModuleDefectsID() {return "ModuleDefects";}
	const string getDefectID(unsigned int firstChannel, unsigned int NChannels);
	static inline const string getTestSummaryID() {return "TestSummary";}

	static inline const string getThresholdID() {return "Threshold";}
	static inline const string getDefectsID() {return "ModuleDefects";}
	static inline const string getSpecialPointValueID() {return "SpecialPointValue";}
	static inline const string getSpecialPointID() {return "SpecialPoint";}
	static inline const string getChipNONoiseID() {return "AllChipsNoise";}
	static inline const string getChipNOFitID() {return "ChipNOFit";}
	static inline const string getChipNOGraphID() {return "ChipNOGraph";}
	const string getChipNOFitID(unsigned int chipN);
	const string getChipNOGraphID(unsigned int chipN);

	static inline const string getChipDataID() {return "ChipData";}
	const string getChipFitID(unsigned int chipN);
	const string getChipGraphID(unsigned int chipN);
	static inline const string getChipGainID() {return "AllChipsGain";}
	static inline const string getChipOffsetID() {return "AllChispOffset";}
	static inline const string getChipNoiseID() {return "AllChipsNoise";}
	static inline const string getChannelDataID() {return "ChannelData";}
	const string getChannelFitID(unsigned int channelN);
	const string getChannelGraphID(unsigned int channelN);
	static inline const string getChannelGainID() {return "AllChannelsGain";}
	static inline const string getChannelNoiseID() {return "AllChannelsNoise";}
	static inline const string getChannelOffsetID() {return "AllChannelsOffset";}

	static const string getChipTrimID(int ); 
	static const string getChipTrimFitID(int );

	inline const string getFractionID() {return "OptimumEfficiencyFraction";}
	inline const string getOptimaID() {return "OptimumChipDelays";}

	const string getFBChipN(unsigned int chipN);
	inline const string getStatus_directID() {return "status_direct";}
	inline const string getVdd_directID() {return "vdd_direct";}
	inline const string getStatus_bypassID() {return "status_bypass";}
	inline const string getVdd_bypassID() {return "vdd_bypass";}

	inline const string getTimewalkID() {return "timewalk";}
	inline const string getCalibrationID() {return "calibration";}
	const string getTimewalkID(unsigned int chipN);
	const string getCalibrationID(unsigned int chipN);
	

	inline const string getRunID() {return runID;}
	inline const string getModuleID() {return moduleID;}
	inline const string getTestType() {return testType;}
};


#endif //#ifndef ARCHTESTNAMES_H
