#include "ArchStrobeDelayTestResult.h"
#include "ArchivingManager.h"
#include <TFile.h>
#include <TKey.h>
#include <TDirectory.h>
#include <TSystem.h>
#include <TNamed.h>
#include <TObject.h>
#include <TObjArray.h>
#include <TString.h>
#include <TObjString.h>
#include <TVector.h>
#include <TVectorD.h>
#include <TH1.h>
#include <TH2.h>
#include <TCanvas.h>
#include <TROOT.h>
#include <is/isinfo.h>
#include <iostream>
#include <vector>
#include "SummaryWriter/SummaryWriter.h"
#include "SummaryWriter/SummaryManager.h"


bool ArchStrobeDelayTestResult::inMap = ArchivingManager::instance().addTestArchiver("SctData::StrobeDelayTestResult", shared_ptr<ArchTestResult>(new ArchStrobeDelayTestResult()));  


/***********************  Constructor  *************** */

ArchStrobeDelayTestResult::ArchStrobeDelayTestResult(): ArchTestResult()  {

  //cout<< "I am in the ArchStrobeDelayTestResult Default Constructor"<< endl;
  
  
  
}


ArchStrobeDelayTestResult::ArchStrobeDelayTestResult(shared_ptr<StrobeDelayTestResult> SDtest): ArchTestResult(SDtest)  {

  //cout<< "I am in the ArchStrobeDelayTestResult Constructor"<< endl;
  
  /*--- Initialisation ---*/

  fraction = SDtest->getFraction();

  for (unsigned int i = 0; i<SDtest->getNOptima();i++) { 
    optima.push_back(SDtest->getOptimum(i));
  }


  //Save fraction as TVectorD's      
  vfraction = new TVectorD(1,1,fraction,"END");
      
  //Save optima as TVectorD's  
  double x[12];
  for(unsigned int i=0;i<SDtest->getNOptima();++i) {
    x[i] = SDtest->getOptimum(i) ;
  }
  voptima = new TVectorD(SDtest->getNOptima(),x);



  //Retrieve Test Summary from IS
  try{
    TestSummary(SDtest);
  } catch(...) {
    cout<<" ERROR in retrieving Test Summary from IS" <<endl;
  }



}



/**********************  Other Member Functions  *********************/


ArchStrobeDelayTestResult::~ArchStrobeDelayTestResult()  {
  
  //cout << "I am in the ArchStrobeDelayTestResult destructor" << endl;
  

  
}



void ArchStrobeDelayTestResult::SaveStrobeDelayTestDataOnly() {

  cout<<"Saving StrobeDelayTestData "<<endl;
  //TO DO : Save time and date of first and last saving  

  string filename = names->getfilename();
  string moduleID = names->getModuleID(); 
  string testType  = names->getTestType(); 
  string runID = names->getRunID();
  string vfractionID = names->getFractionID();
  string voptimaID = names->getOptimaID();
  

  
  /* OPENING TEST FILE  */
  //cout << "Opening file..."<<endl; 
 
  TFile *storage_file = new TFile(filename.c_str(),"update");
  //storage_file->ls();
  //cout << "The file .root succesfully open"<<endl; 

  


  /* CREATING DIRECTORIES and SAVING DATA  */
  
    
    /* Making RunNumber   */
    //cout<<"I am making RunNumber Dir"<<endl;
    //storage_file->GetListOfKeys()->Print();
    TDirectory *this_run = (TDirectory*) gDirectory->Get(runID.c_str());
    //cout<<"The RUN is "<< runID <<endl;
    
    if (!this_run) {
      //cout<<"This NEW run "<< runID <<" doesn't exist"<<endl;
      this_run = storage_file->mkdir(runID.c_str());
      //cout<<"New RunNumber Dir made "<<endl;
    }
    storage_file->GetListOfKeys()->Print();
    this_run->cd();  //make this_run the current directory
    
   
    /* Saving RunNumber as a TVector: it is saved only once, just the first time   */
    TObject* pers_runnumber = gDirectory->FindObjectAny(runID.c_str()); 
    if (!pers_runnumber) {
      double frunNumber = runNumber;
      TVector run(1,1,frunNumber, "END");
      run.Write(runID.c_str());
    }
    
    
    /* Making moduleNumber   */
    
    TDirectory* this_module = (TDirectory*) gDirectory->Get(moduleID.c_str()); //Can be made using FindAnyObject
    //cout<<"The MODULE is "<< moduleID <<endl;
    if (!this_module) {
      //cout<<"This NEW module "<< moduleID <<" doesn't exist"<<endl;
      this_module =gDirectory ->mkdir(moduleID.c_str());
    }
    
    
    /* Making TestType   */
    //cout<<"I am making TestType Dir "<<endl;
    this_module->cd();  //make this_module the current directory 
    TDirectory* this_testType = (TDirectory*) gDirectory->Get(testType.c_str());
    //cout<<"The test Type is "<< testType <<endl;
    
    if (!this_testType) {
      //cout<<"This NEW test "<< testType <<" doesn't exist"<<endl;
      this_testType = gDirectory->mkdir(testType.c_str());
    }
    this_testType->cd();


    
    
    /* Saving vfraction and voptima  as a TVector */
    //cout << "I am Saving vfraction as  TVectorD's" << endl;
    TObject* pers_vfraction = gDirectory->FindObjectAny(vfractionID.c_str()); 
    if (!pers_vfraction) {
      //cout << "The vfraction never saved before...saving now"<<endl;
      vfraction->Write(vfractionID.c_str());
    }
    
    //cout << "I am Saving voptima as  TVectorD's" << endl;
    TObject* pers_voptima = gDirectory->FindObjectAny(voptimaID.c_str()); 
    if (!pers_voptima) {
      //cout << "The voptima never saved before...saving now"<<endl;
      voptima->Write(voptimaID.c_str());
    }

    

    //Save TestSummery (if it has been retrieved)
    if(testSummary != NULL) {
      //cout<<"testSummary != NULL...";
      TObject* pers_testSummary = gDirectory->FindObjectAny(names->getTestSummaryID().c_str());
      if (!pers_testSummary) {
	testSummary->Write(names->getTestSummaryID().c_str());
	//cout<<"testSummary SAVED"<<endl;
      }
    }




    /* CLOSING FILE  */
    //cout << "I am Closing File " << endl;
    storage_file->Close();
    delete storage_file;
    //cout << "File closed " << endl;







}





void ArchStrobeDelayTestResult::Save() {

  ArchTestResult::Save();
  SaveStrobeDelayTestDataOnly();
  //SaveRawScans();
  //SaveFitScans();
  AddTestToIndex();

}



void ArchStrobeDelayTestResult::TestSummary(shared_ptr<StrobeDelayTestResult> SDtest) {
  
  ostringstream datastream;
  shared_ptr<const SctData::TestSummary::SummaryWriter> writer = 
    SctData::TestSummary::SummaryManager::instance().getWriter(SDtest->getClassName());
  writer->writeHeader(*(SDtest.get()), datastream);
  writer->write(*(SDtest.get()), datastream);
  string myString = datastream.str();
  //cout<< "TestSummary = " << myString;

  testSummary = new TObjString(myString.c_str());

  


  return;


}

