#ifndef ARCCSCANTXTNAMES_H
#define ARCHSCANTXTNAMES_H

#include "ArchScanNames.h"
#include "Sct/SctNames.h"
//#include "SCTData/ScanType.h"
#include "SctData/ConfigurationVariable.h"
#include <string>

/**
Thsi Class provides all the names for the ScanResult archiving
*/

using namespace SctData;
using namespace Sct;


class ArchScanTxtNames: public ArchScanNames {

 private:
        

 public:
	ArchScanTxtNames();    
	ArchScanTxtNames(const long runNumber,const string moduleName, long scanNumber, const ConfigurationVariable& sVariable , unsigned int cycle=0); 
	
	inline const string getTxtCommentAllFilesName() {return "TxtComment.AllFiles.dat";}
	inline const string getTxtCommentRunName() {return "TxtComment." + getRunID() + ".dat"; }
	inline const string getTxtCommentModuleName() {return "TxtComment." + getModuleID() + ".dat"; }
	inline const string getTxtCommentTestName() {return "TxtComment." + getTestType() + ".dat"; }
	inline const string getTxtCommentVariableName() {return "TxtComment." + getVariable() + ".dat";}
	inline const string getTxtCommentScanNumberName() {return "TxtComment." + getScanID() + ".dat";}
	inline const string getTxtCommentRODName() {return "TxtComment." + getRODID() + ".dat";}
	inline const string getTxtCommentRawName() {return "TxtComment." + getRawID() + ".dat";}
	inline const string getTxtCommentFitName() {return "TxtComment." + getFitID() + ".dat";}


	const string getAllFilesTxtComment(int commentN); 
	const string getRunTxtComment(int commentN);
	const string getModuleTxtComment(int commentN);
	const string getTestTxtComment(int commentN);
	const string getVariableTxtComment(int commentN);
	const string getScanNumberTxtComment(int commentN);
	const string getRODTxtComment(int commentN);
	const string getRawTxtComment(int commentN);
	const string getFitTxtComment(int commentN);
	
};


#endif //#ifndef ARCHSCANTXTNAMES_H
