#ifndef ArchScan_H
#define ArchScan_H

#include <vector>
#include <string>

#include <is/isinfo.h>
#include "SctData/ConfigurationVariable.h"
#include "SctData/RawScanResult.h"
#include "SctData/FitScanResult.h"
#include "SctData/ModuleConfiguration.h"
#include "SctData/ScanResult.h"
#include "SctData/ScanResultIOHelper.h"
#include "SctData/ScanHeader.h"
#include "SctData/ScanHeaderIOHelper.h"
#include "Sct/SctNames.h"
#include <TGraph.h>
#include <TObjString.h>
#include "Archiving.h"
#include "ArchScanTxtNames.h"



class TFile;
class TDirectory;
class TObject;
class TVector;
class TVectorD;
class TSystem;
class TNamed;
class TString;
class TObjString;
class TH1;
class TH2;


using namespace SctData;
using namespace Sct;


class ArchScanResult: public Archiving  {
  
 protected:

    const ScanResult* Archscan;
    const ScanHeader* Archheader;
    const ModuleConfiguration* ArchmoduleConfig;
    const ScanPoints* Archpoints;	
    const ConfigurationVariable* Archvariable;

    const ABCDModule ABCDModuleConfig; 

    TGraph* gpoints;   //ScanPoints data
    TVector* vpoints;
    TVector* vNEvents;
    TVector* vNErrorEvents;
    
    
    string moduleName; 
    unsigned int scanNumber;
    unsigned int  runNumber;
    double threshold; 
    ArchScanTxtNames* names;
    vector <string> SavedScansList;  //to be deleted
    string objName;  //To be deleted

    
    TObjString getModuleConfigTObjString();

    ArchScanResult(shared_ptr<const ScanResult> scan);

  public:
    
    ArchScanResult(); 
    ~ArchScanResult();
    virtual shared_ptr<ArchScanResult> clone(shared_ptr<ScanResult> scan) = 0;

    void SetScan(shared_ptr<const ScanResult>  );

    void SetTestType(string );
    
    const vector <string>& getAllSavedScansList();
    void AddScanToIndex();
    
    
    void SaveFileComment();
    void SaveRunComment();
    void SaveModuleComment();
    void SaveTestComment();
    void SaveScanTypeComment();
    void SaveScanNumberComment();
    void SaveRODComment();
    void SaveVariableComment();

    virtual void Save();  
 
    //void SaveScan(ScanResult & s);
    //bool ScanIsPersisted();
    //bool ScanIsPersisted(ScanResult &);
    //void DeletePersObj();
    //ScanResult* CreateScanResult();
    //ScanResult* CreateScanResult(ScanResult &);

    



};


#endif
