#include "ArchScanResult.h"
#include <TFile.h>
#include <TKey.h>
#include <TDirectory.h>
#include <TSystem.h>
#include <TNamed.h>
#include <TObject.h>
#include <TObjArray.h>
#include <TString.h>
#include <TObjString.h>
#include <TVector.h>
#include <TVectorD.h>
#include <TH1.h>
#include <TH2.h>
#include <TCanvas.h>
#include <TROOT.h>
#include <is/isinfo.h>
#include <fstream>
#include <iostream>
#include <vector>

#include "sctConfIPC/configipc.h"

using namespace SctConfiguration;


/********************************** ArchScan Methods Definitions ************************/


/***********************  Constructor  *************** */

ArchScanResult::ArchScanResult()  {

  //cout<< "I am in the ArchScanResult Default Constructor"<< endl;
  

  /*--- Initialisation ---*/
  Archheader = NULL;
  ArchmoduleConfig = NULL;
  Archpoints = NULL;
  Archvariable = NULL;
  //TABCDModuleConfig = NULL;

  runNumber = 0;
  scanNumber = 0;
  //threshold = 0;

  names = new ArchScanTxtNames();

  

  gpoints = NULL;
  vpoints = NULL;
  vNEvents = NULL;
  vNErrorEvents = NULL;

}
  
  
ArchScanResult::ArchScanResult(shared_ptr<const ScanResult>  scan)  {

  //cout<< "I am in the ArchScanResult Constructor"<< endl;
  
  

  /*--- SCTData Initialisation ---*/
    Archheader = &scan->getHeader();          //These might me deleted at some point
    ArchmoduleConfig = &scan->getConfiguration();
    Archpoints = &scan->getPoints();
    Archvariable = &Archheader->getVariable();
    

    // Initialise ModuleConfiguration    
    const ABCDModule ABCDModuleConfig = ArchmoduleConfig->getABCDModule();
    
    



  /*--- Archiving Variables Initialisation ---*/

    runNumber = Archheader->getRunNumber() ;
    scanNumber = Archheader->getScanNumber() ;
    moduleName = Archheader->getModuleName();

//    threshold = ArchmoduleConfig->threshold;

    //cout<< "runNumber = " <<runNumber<<endl;
    //cout<< "scanNumber = " <<scanNumber<<endl;
//    cout<< "threshold = " <<threshold<<endl;


    names = new ArchScanTxtNames(runNumber, Archheader->getModuleName(), scanNumber, *Archvariable );
    objName = scan->getUniqueID();   //!!! To be deleted


    
    float x[Archpoints->getNPoints()], y[Archpoints->getNPoints()],err[Archpoints->getNPoints()] ;
    for(unsigned int i=0;i<Archpoints->getNPoints();++i) {
      x[i] = Archpoints->getPoint(i);
      y[i] = Archpoints->getNEvents(i);
      err[i] = Archpoints->getNErrorEvents(i);
    }
    gpoints = new TGraph(Archpoints->getNPoints(),x,y);


    
    //Save points as TVector's    
    vpoints = new TVector(0, Archpoints->getNPoints(),x);
    vNEvents = new TVector(0, Archpoints->getNPoints(),y);
    vNErrorEvents = new TVector(0, Archpoints->getNPoints(),err);
    
    



}





/**********************  Other Member Functions  *********************/

ArchScanResult::~ArchScanResult()  {
  
  //cout << "I am in the ArchScanResult Destructor" << endl;
  
  
  

  
}





TObjString ArchScanResult::getModuleConfigTObjString() {
  /*
    Gets the current ABCDModule Comfiguration from sctConfig, through IPC, as an xml file, 
    and converts it into a TObjString
  **/
  ConfigIPC config;
  string tmp_ModuleConfig = config.getModuleConfigurationString(moduleName, ABCDModuleConfig);
  const char* tmp_char = tmp_ModuleConfig.c_str();
  TObjString ABCDModuleTObjString(tmp_char);
  TString tmp_string = ABCDModuleTObjString.String();
  cout<< "Module Configuration :" << endl << tmp_string.Data()<<endl;
  
  return ABCDModuleTObjString;
  


}
    





void ArchScanResult::SetScan(shared_ptr<const ScanResult>  scan) {

  /* This functions sets all the ArchScanResult member data*/


/*--- SctData Initialisation ---*/
    Archheader = &scan->getHeader();          //These might me deleted at some point
    ArchmoduleConfig = &scan->getConfiguration();
    Archpoints = &scan->getPoints();
    Archvariable = &Archheader->getVariable();


  /*--- Archiving Variables Initialisation ---*/

    runNumber = Archheader->getRunNumber() ;
    scanNumber = Archheader->getScanNumber() ;
//    threshold = ArchmoduleConfig->threshold;

    //cout<< "runNumber = " <<runNumber<<endl;
    //cout<< "scanNumber = " <<scanNumber<<endl;
//    cout<< "threshold = " <<threshold<<endl;

    
    names = new ArchScanTxtNames(runNumber, Archheader->getModuleName(), scanNumber, *Archvariable );
    objName = scan->getUniqueID();   //!!! To be deleted


    
    float x[Archpoints->getNPoints()], y[Archpoints->getNPoints()],err[Archpoints->getNPoints()];
    for(unsigned int i=0;i<Archpoints->getNPoints();++i) {
      x[i] = Archpoints->getPoint(i);
      y[i] = Archpoints->getNEvents(i);
      err[i] = Archpoints->getNErrorEvents(i);
    }
    gpoints = new TGraph(Archpoints->getNPoints(),x,y);
    

    vpoints = new TVector(0, Archpoints->getNPoints(),x);
    vNEvents = new TVector(0, Archpoints->getNPoints(),y);
    vNErrorEvents = new TVector(0, Archpoints->getNPoints(),err);






}





void ArchScanResult::SetTestType(string tType) {

  names->setTestType( tType );
  //cout <<" TestType = " << names->getTestType()<<endl;
}


const vector <string>& ArchScanResult::getAllSavedScansList() {

 /* Check if the current RawScanResult of the current Test has been persisted*/
   

 
  //TO DO: Extend to all files in DataArchive dir and loop over all of them
  string filename = names->getfilename(); 
  TFile *inspect_file = new TFile(filename.c_str(),"read");
  if (inspect_file->IsZombie() == true) {
    cout << "Problem in opening file"<<endl; 
    return SavedScansList;
    
  } 
  
  //TDirectory *gRunDir = new TDirectory();
  TDirectory *gModuleDir = new TDirectory();
  TDirectory *gRODDir = new TDirectory();
  TDirectory *gtestTypeDir = new TDirectory();
  TDirectory *gvariableDir = new TDirectory();
  TDirectory *gscanDir = new TDirectory();


  //gDirectory->ls();
  TList* runsList = gDirectory->GetListOfKeys();
  TListIter itruns(runsList);
  while (TObject *runsobj = itruns.Next()) { 
    //runsobj->Print();
    //cout<< "Run OBJ Name = " << runsobj->GetName() <<endl;
    string runID = runsobj->GetName();
    if (runsobj->GetTitle() == runID ) {
      if (gDirectory->cd(runID.c_str())==1) {
	
	gModuleDir = gDirectory;
	TList* modulesList = gDirectory->GetListOfKeys();
	TListIter itmodules(modulesList); 
	while (TObject *modulesobj = itmodules.Next()) { 
	  string moduleID = modulesobj->GetName();
	  string modulesobjID = modulesobj->GetTitle(); 
	  //!!if (modulesobjID.find("module") != modulesobjID.npos ) {
	  if (modulesobj->GetTitle() == moduleID ) {
	    gModuleDir->cd();
	    if (gDirectory->cd(moduleID.c_str())== 1) {

	      gtestTypeDir = gDirectory;
	      TList* testTypeList = gDirectory->GetListOfKeys();
	      TListIter ittestType(testTypeList); 
	      while (TObject *testTypeobj = ittestType.Next()) { 
		string testTypeID = testTypeobj->GetName();
		if (testTypeobj->GetTitle() == testTypeID ) {
		  gtestTypeDir->cd();
		  if (gDirectory->cd(testTypeID.c_str())==1 ) {
		    
		    gvariableDir = gDirectory;
		    TList* variableList = gDirectory->GetListOfKeys();
		    TListIter itvariable(variableList); 
		    while (TObject *variableobj = itvariable.Next()) { 
		      string variableID = variableobj->GetName();
		      if (variableobj->GetTitle() == variableID ) {
			gvariableDir->cd();
			if (gDirectory->cd(variableID.c_str())==1 ) {
			  gDirectory->Print();

			  gscanDir = gDirectory;
			  TList* scanList = gDirectory->GetListOfKeys();
			  TListIter itscan(scanList); 
			  while (TObject *scanobj = itscan.Next()) { 
			    string scanID = scanobj->GetName();
			    if (scanobj->GetTitle() == scanID ) {
			      gscanDir->cd();
			      if (gDirectory->cd(scanID.c_str())==1 ) {
				
				if (gDirectory->cd(names->getDCSID().c_str())==1 ) {    // TO BE DONE
				  
				  gDirectory->cd("../");
				  if (gDirectory->cd(names->getRODID().c_str())==1 ) {
				    
				    
				    gRODDir = gDirectory;
				    if (gDirectory->cd(names->getRawID().c_str())==1 ) {
				      string tmp_SavedScan = gDirectory->GetPath();
				      SavedScansList.push_back(tmp_SavedScan);
				      
				    }  
			
				    gRODDir->cd();
				    if (gDirectory->cd(names->getFitID().c_str())==1 ) {
				      string tmp_SavedScan = gDirectory->GetPath();
				      SavedScansList.push_back(tmp_SavedScan);
		       
				    }  
				  }
				}
			      }
			    }
			  }
			}
		      }
		    }
		  }
		}
	      }
	    }
	  }
	}
      }
    }
  }
  
  

  return SavedScansList;

}




void ArchScanResult::AddScanToIndex()  {
  
  /* Append current Test to the Index  */

  //cout << "I am in AddScanToIndex() " << endl;
  string index = names->getIndexFileName(); 
  ofstream index_file;
  index_file.open(index.c_str(),ios::app);  //append the Index File
  //assure(index_file,index.c_str());  //TO DO
 
  string indexScanName = names->getRunID() + ".";
  indexScanName = indexScanName + names->getModuleID();
  indexScanName = indexScanName + ".";
  indexScanName = indexScanName + names->getTestType() + ".";
  indexScanName = indexScanName + names->getScanID();
  cout << indexScanName <<endl;
  //if(ScanIsPersisted()) {
    index_file << indexScanName <<endl;
    cout << "Scan appended to Index"<<endl;    
  //} else {
  //  cout<<"Scan NOT correctly saved in the archive...test NOT added to the Index"<<endl;
  //}
  
  index_file.close(); 
  
}


void ArchScanResult::SaveFileComment() {

  // Saving Txt Comments at the Fun level

  string filename = names->getfilename();
  
  TFile *file = new TFile(filename.c_str(),"update");
  if (file->IsZombie() == true) {
    cout << "The ScanResult has NOT been saved in any file"<<endl; 
    return ;
  }
  

  //...Opening TxtComment file 
  ifstream in;
  in.open(names->getTxtCommentAllFilesName().c_str());

  int commentN;
    int sz = 1000; // Buffer size;
    char buf[sz];
    
    //char FileTxtComment[40];
    int nlines = 0;
    while (1) {
      in >> commentN;
      in.get(buf, sz);
      if (!in.good()) break;
      //cout<< " CommentN = "<< commentN << " String = "<< buf <<endl;
      TObjString FileComment(buf);
      //sprintf(FileTxtComment,"FileTxtComment_%i",commentN);
      TObject* pers_FileTxtCommentN = gDirectory->FindObjectAny(names->getAllFilesTxtComment(commentN).c_str());
      if (!pers_FileTxtCommentN) {
	//cout<<" FileTxtComment Never Persisted...persisting" <<endl;
	FileComment.Write(names->getAllFilesTxtComment(commentN).c_str());
      }
      nlines++;   
    }
    //printf(" found %d points \n",nlines);
    
    
    in.close();
    file->Close();

}



void ArchScanResult::SaveRunComment() {

  // Saving Txt Comments at the Fun level

  string filename = names->getfilename();
  string runID = names->getRunID();
  TFile *file = new TFile(filename.c_str(),"update");
  if (file->IsZombie() == true) {
    cout << "The ScanResult has NOT been saved in any file"<<endl; 
    return ;
  }
  /* Making RunNumber */
  TDirectory *this_run = (TDirectory*) gDirectory->Get(runID.c_str()); 
  if (!this_run) {
    //cout<<"This NEW run "<< runID <<" doesn't exist"<<endl;
    this_run = file->mkdir(runID.c_str());
    //cout<<"New RunNumber Dir made "<<endl;
  }
  this_run->cd();  //make this_run the current directory


  //...Opening TxtComment file 
  ifstream in;
  in.open(names->getTxtCommentRunName().c_str());

  int commentN;
    int sz = 1000; // Buffer size;
    char buf[sz];
    
    //char RunTxtComment[40];
    int nlines = 0;
    while (1) {
      in >> commentN;
      in.get(buf, sz);
      if (!in.good()) break;
      //cout<< " CommentN = "<< commentN << " String = "<< buf <<endl;
      TObjString RunComment(buf);
      //sprintf(RunTxtComment,"RunTxtComment_%i",commentN);
      TObject* pers_RunTxtCommentN = gDirectory->FindObjectAny(names->getRunTxtComment(commentN).c_str());
      if (!pers_RunTxtCommentN) {
	//cout<<" RunTxtComment Never Persisted...persisting" <<endl;
	RunComment.Write(names->getRunTxtComment(commentN).c_str());
      }
      nlines++;   
    }
    //printf(" found %d points \n",nlines);
    
    
    in.close();
    file->Close();

}


void ArchScanResult::SaveModuleComment() {

  // Saving Txt Comments at the Fun level
  
  string filename = names->getfilename();
  string runID = names->getRunID();
  string moduleID = names->getModuleID();

  TFile *file = new TFile(filename.c_str(),"update");
  if (file->IsZombie() == true) {
    cout << "The ScanResult has NOT been saved in any file"<<endl; 
    return ;
  }
  /* Making RunNumber */
  TDirectory *this_run = (TDirectory*) gDirectory->Get(runID.c_str()); 
  if (!this_run) {
    //cout<<"This NEW run "<< runID <<" doesn't exist"<<endl;
    this_run = file->mkdir(runID.c_str());
    //cout<<"New RunNumber Dir made "<<endl;
  }
  this_run->cd();  //make this_run the current directory

  /* Making moduleNumber   */
  
  TDirectory* this_module = (TDirectory*) gDirectory->Get(moduleID.c_str()); //Can be made using FindAnyObject
  if (!this_module) {
    //cout<<"This NEW module "<< moduleID <<" doesn't exist"<<endl;
    this_module =gDirectory ->mkdir(moduleID.c_str());
  }
  this_module->cd();

  
  
  //...Opening TxtComment file 
  ifstream in;
  in.open(names->getTxtCommentModuleName().c_str());
  

  int commentN;
    int sz = 1000; // Buffer size;
    char buf[sz];
    
    
    //char ModuleTxtComment[40];
    int nlines = 0;
    while (1) {
      in >> commentN;
      in.get(buf, sz);
      if (!in.good()) break;
      //cout<< " CommentN = "<< commentN << " String = "<< buf <<endl;
      TObjString Comment(buf);
      //sprintf(ModuleTxtComment,"TxtComment_%i",ModulecommentN);
      TObject* pers_ModuleTxtCommentN = gDirectory->FindObjectAny(names->getModuleTxtComment(commentN).c_str());
      if (!pers_ModuleTxtCommentN) {
	//cout<<" TxtComment Never Persisted...persisting" <<endl;
      Comment.Write(names->getModuleTxtComment(commentN).c_str());
      }
      nlines++;   
    }
    //printf(" found %d points \n",nlines);
    

    in.close();
    file->Close();
    

}



void ArchScanResult::SaveTestComment() {

  // Saving Txt Comments at the Fun level
  
  string filename = names->getfilename();
  string runID = names->getRunID();
  string moduleID = names->getModuleID();
  string testType = names->getTestType();
  TFile *file = new TFile(filename.c_str(),"update");
  if (file->IsZombie() == true) {
    cout << "The ScanResult has NOT been saved in any file"<<endl; 
    return ;
  }
  /* Making RunNumber */
  TDirectory *this_run = (TDirectory*) gDirectory->Get(runID.c_str()); 
  if (!this_run) {
    //cout<<"This NEW run "<< runID <<" doesn't exist"<<endl;
    this_run = file->mkdir(runID.c_str());
    //cout<<"New RunNumber Dir made "<<endl;
  }
  this_run->cd();  //make this_run the current directory

  /* Making moduleNumber   */
  
  TDirectory* this_module = (TDirectory*) gDirectory->Get(moduleID.c_str()); //Can be made using FindAnyObject
  if (!this_module) {
    //cout<<"This NEW module "<< moduleID <<" doesn't exist"<<endl;
    this_module =gDirectory ->mkdir(moduleID.c_str());
  }
  this_module->cd();


  /* Making TestType   */
  TDirectory* this_testType = (TDirectory*) gDirectory->Get(testType.c_str());
  if (!this_testType) {
    //cout<<"This NEW test "<< testType <<" doesn't exist"<<endl;
    this_testType = gDirectory->mkdir(testType.c_str());
  }
  this_testType->cd();



  //...Opening TxtComment file 
  ifstream in;
  in.open(names->getTxtCommentTestName().c_str());

  int commentN;
    int sz = 1000; // Buffer size;
    char buf[sz];
    
    //char TxtComment[40];
    int nlines = 0;
    while (1) {
      in >> commentN;
      in.get(buf, sz);
      if (!in.good()) break;
      //cout<< " CommentN = "<< commentN << " String = "<< buf <<endl;
      TObjString Comment(buf);
      //sprintf(TxtComment,"TxtComment_%i",commentN);
      TObject* pers_TxtCommentN = gDirectory->FindObjectAny(names->getTestTxtComment(commentN).c_str());
      if (!pers_TxtCommentN) {
	//cout<<" TxtComment Never Persisted...persisting" <<endl;
	Comment.Write(names->getTestTxtComment(commentN).c_str());
      }
      nlines++;   
    }
    //printf(" found %d points \n",nlines);
    
    
    in.close();
    file->Close();

}


void ArchScanResult::SaveVariableComment() {

  // Saving Txt Comments at the Fun level
  
  string filename = names->getfilename();
  string runID = names->getRunID();
  string moduleID = names->getModuleID();
  string testType = names->getTestType();
  string variable = names->getVariable();

  TFile *file = new TFile(filename.c_str(),"update");
  if (file->IsZombie() == true) {
    cout << "The ScanResult has NOT been saved in any file"<<endl; 
    return ;
  }
  /* Making RunNumber */
  TDirectory *this_run = (TDirectory*) gDirectory->Get(runID.c_str()); 
  if (!this_run) {
    //cout<<"This NEW run "<< runID <<" doesn't exist"<<endl;
    this_run = file->mkdir(runID.c_str());
    //cout<<"New RunNumber Dir made "<<endl;
  }
  this_run->cd();  //make this_run the current directory

  /* Making moduleNumber   */
  
  TDirectory* this_module = (TDirectory*) gDirectory->Get(moduleID.c_str()); //Can be made using FindAnyObject
  if (!this_module) {
    //cout<<"This NEW module "<< moduleID <<" doesn't exist"<<endl;
    this_module =gDirectory ->mkdir(moduleID.c_str());
  }
  this_module->cd();


  /* Making TestType   */
  TDirectory* this_testType = (TDirectory*) gDirectory->Get(testType.c_str());
  if (!this_testType) {
    //cout<<"This NEW test "<< testType <<" doesn't exist"<<endl;
    this_testType = gDirectory->mkdir(testType.c_str());
  }
  this_testType->cd();

  
  /* Making Variable   */
  TDirectory* this_variable = (TDirectory*) gDirectory->Get(variable.c_str());
  
  if (!this_variable) {
    //cout<<"This NEW test "<< variable <<" doesn't exist"<<endl;
    this_variable = gDirectory->mkdir(variable.c_str());
  }
  this_variable->cd();



  //...Opening TxtComment file 
  ifstream in;
  in.open(names->getTxtCommentVariableName().c_str());

  int commentN;
    int sz = 1000; // Buffer size;
    char buf[sz];
    
    //char TxtComment[40];
    int nlines = 0;
    while (1) {
      in >> commentN;
      in.get(buf, sz);
      if (!in.good()) break;
      //cout<< " CommentN = "<< commentN << " String = "<< buf <<endl;
      TObjString Comment(buf);
      //sprintf(TxtComment,"TxtComment_%i",commentN);
      TObject* pers_TxtCommentN = gDirectory->FindObjectAny(names->getVariableTxtComment(commentN).c_str());
      if (!pers_TxtCommentN) {
	//cout<<" TxtComment Never Persisted...persisting" <<endl;
	Comment.Write(names->getVariableTxtComment(commentN).c_str());
      }
      nlines++;   
    }
    //printf(" found %d points \n",nlines);
    
    
    in.close();
    file->Close();

}



void ArchScanResult::SaveScanNumberComment() {

  // Saving Txt Comments at the Fun level
  
  string filename = names->getfilename();
  string runID = names->getRunID();
  string moduleID = names->getModuleID();
  string testType = names->getTestType();
  string variable = names->getVariable();
  string scanID = names->getScanID();

  TFile *file = new TFile(filename.c_str(),"update");
  if (file->IsZombie() == true) {
    cout << "The ScanResult has NOT been saved in any file"<<endl; 
    return ;
  }
  /* Making RunNumber */
  TDirectory *this_run = (TDirectory*) gDirectory->Get(runID.c_str()); 
  if (!this_run) {
    //cout<<"This NEW run "<< runID <<" doesn't exist"<<endl;
    this_run = file->mkdir(runID.c_str());
    //cout<<"New RunNumber Dir made "<<endl;
  }
  this_run->cd();  //make this_run the current directory

  /* Making moduleNumber   */
  
  TDirectory* this_module = (TDirectory*) gDirectory->Get(moduleID.c_str()); //Can be made using FindAnyObject
  if (!this_module) {
    //cout<<"This NEW module "<< moduleID <<" doesn't exist"<<endl;
    this_module =gDirectory ->mkdir(moduleID.c_str());
  }
  this_module->cd();


  /* Making TestType   */
  TDirectory* this_testType = (TDirectory*) gDirectory->Get(testType.c_str());
  if (!this_testType) {
    //cout<<"This NEW test "<< testType <<" doesn't exist"<<endl;
    this_testType = gDirectory->mkdir(testType.c_str());
  }
  this_testType->cd();

  
  /* Making Variable   */
  TDirectory* this_variable = (TDirectory*) gDirectory->Get(variable.c_str());
  if (!this_variable) {
    //cout<<"This NEW test "<< variable <<" doesn't exist"<<endl;
    this_variable = gDirectory->mkdir(variable.c_str());
  }
  this_variable->cd();

  /* Making scanNumber   */
  TDirectory* this_scan = (TDirectory*) gDirectory->Get(scanID.c_str());
  if (!this_scan) {
    //cout<<"This NEW scan "<< scanID <<" doesn't exist"<<endl;
    this_scan =gDirectory ->mkdir(scanID.c_str());
  }
  this_scan->cd();   



  //...Opening TxtComment file 
  ifstream in;
  in.open(names->getTxtCommentScanNumberName().c_str());

  int commentN;
    int sz = 1000; // Buffer size;
    char buf[sz];
    
    //char TxtComment[40];
    int nlines = 0;
    while (1) {
      in >> commentN;
      in.get(buf, sz);
      if (!in.good()) break;
      //cout<< " CommentN = "<< commentN << " String = "<< buf <<endl;
      TObjString Comment(buf);
      //sprintf(TxtComment,"TxtComment_%i",commentN);
      TObject* pers_TxtCommentN = gDirectory->FindObjectAny(names->getScanNumberTxtComment(commentN).c_str());
      if (!pers_TxtCommentN) {
	//cout<<" TxtComment Never Persisted...persisting" <<endl;
	Comment.Write(names->getScanNumberTxtComment(commentN).c_str());
      }
      nlines++;   
    }
    //printf(" found %d points \n",nlines);
    
    
    in.close();
    file->Close();

}


void ArchScanResult::SaveRODComment() {

  // Saving Txt Comments at the Fun level
  
  string filename = names->getfilename();
  string runID = names->getRunID();
  string moduleID = names->getModuleID();
  string testType = names->getTestType();
  string variable = names->getVariable();
  string scanID = names->getScanID();
  string RODID = names->getRODID();

  TFile *file = new TFile(filename.c_str(),"update");
  if (file->IsZombie() == true) {
    cout << "The ScanResult has NOT been saved in any file"<<endl; 
    return ;
  }
  /* Making RunNumber */
  TDirectory *this_run = (TDirectory*) gDirectory->Get(runID.c_str()); 
  if (!this_run) {
    //cout<<"This NEW run "<< runID <<" doesn't exist"<<endl;
    this_run = file->mkdir(runID.c_str());
    //cout<<"New RunNumber Dir made "<<endl;
  }
  this_run->cd();  //make this_run the current directory

  /* Making moduleNumber   */
  
  TDirectory* this_module = (TDirectory*) gDirectory->Get(moduleID.c_str()); //Can be made using FindAnyObject
  if (!this_module) {
    //cout<<"This NEW module "<< moduleID <<" doesn't exist"<<endl;
    this_module =gDirectory ->mkdir(moduleID.c_str());
  }
  this_module->cd();


  /* Making TestType   */
  TDirectory* this_testType = (TDirectory*) gDirectory->Get(testType.c_str());
  if (!this_testType) {
    //cout<<"This NEW test "<< testType <<" doesn't exist"<<endl;
    this_testType = gDirectory->mkdir(testType.c_str());
  }
  this_testType->cd();

  
  /* Making Variable   */
  TDirectory* this_variable = (TDirectory*) gDirectory->Get(variable.c_str());
  if (!this_variable) {
    //cout<<"This NEW test "<< variable <<" doesn't exist"<<endl;
    this_variable = gDirectory->mkdir(variable.c_str());
  }
  this_variable->cd();

  /* Making scanNumber   */
  TDirectory* this_scan = (TDirectory*) gDirectory->Get(scanID.c_str());
  if (!this_scan) {
    //cout<<"This NEW scan "<< scanID <<" doesn't exist"<<endl;
    this_scan =gDirectory ->mkdir(scanID.c_str());
  }
  this_scan->cd();   

  /* Making ROD   */ 
  TDirectory* this_ROD = (TDirectory*) this_scan->Get(RODID.c_str());
  if (!this_ROD) {
    //cout<<"This NEW ROD  doesn't exist"<<endl;
    this_ROD = this_scan->mkdir(RODID.c_str());
  }
  this_ROD->cd();
 

  //...Opening TxtComment file 
  ifstream in;
  in.open(names->getTxtCommentRODName().c_str());

  int commentN;
    int sz = 1000; // Buffer size;
    char buf[sz];
    
    //char TxtComment[40];
    int nlines = 0;
    while (1) {
      in >> commentN;
      in.get(buf, sz);
      if (!in.good()) break;
      //cout<< " CommentN = "<< commentN << " String = "<< buf <<endl;
      TObjString Comment(buf);
      //sprintf(TxtComment,"TxtComment_%i",commentN);
      TObject* pers_TxtCommentN = gDirectory->FindObjectAny(names->getRODTxtComment(commentN).c_str());
      if (!pers_TxtCommentN) {
	//cout<<" TxtComment Never Persisted...persisting" <<endl;
	Comment.Write(names->getRODTxtComment(commentN).c_str());
      }
      nlines++;   
    }
    //printf(" found %d points \n",nlines);
    
    
    in.close();
    file->Close();

}











void ArchScanResult::Save() {


  //TO DO : Save time and date of first and last saving
 
  
  string ScanPointsID = names->getScanPointsID() ;
  string vpointsID = names->getvpointsID();
  string vNEventsID = names->getvNEventsID();
  string vNErrorEventsID = names->getvNErrorEventsID(); 
  string filename = names->getfilename();
  //string objName = ;  //To be deleted
  string variable = names->getVariable(); 
  string moduleID = names->getModuleID(); 
  string testType  = names->getTestType(); 
  string runID = names->getRunID();
  string scanID = names->getScanID();
  string RODID = names->getRODID();
  string DCSID = names->getDCSID();
  string ModuleConfigID = names->getModuleConfigID();



  /* OPENING TEST FILE  */
  cout << "Opening file..."<<endl; 
 

  /*
  TObject *storage_file = gROOT->FindObjectAny(filename) ;
  if (!storage_file) { 
    cout << "no such file " << endl;
    //TFile *storage_file = new TFile(filename,"update");
  }
  else {
    cout << "The file already exists " << endl;
    TFile *storage_file = new TFile(filename,"update");
  }
  */

  TFile *storage_file = new TFile(filename.c_str(),"update");
  //storage_file->ls();
  cout << "The file .root succesfully open"<<endl; 

  


  /* CREATING DIRECTORIES and SAVING DATA  */
  
    
    /* Making RunNumber   */
    //cout<<"I am making RunNumber Dir"<<endl;
    //storage_file->GetListOfKeys()->Print();
    TDirectory *this_run = (TDirectory*) gDirectory->Get(runID.c_str());
    //cout<<"The RUN is "<< runID <<endl;
    
    if (!this_run) {
      //cout<<"This NEW run "<< runID <<" doesn't exist"<<endl;
      this_run = storage_file->mkdir(runID.c_str());
      //cout<<"New RunNumber Dir made "<<endl;
    }
    //storage_file->GetListOfKeys()->Print();
    this_run->cd();  //make this_run the current directory
    
   
    /* Saving RunNumber as a TVector: it is saved only once, just the first time   */
    TObject* pers_runnumber = gDirectory->FindObjectAny(runID.c_str()); 
    if (!pers_runnumber) {
      double frunNumber = runNumber;
      TVector run(1,1,frunNumber, "END");
      run.Write(runID.c_str());
    }
    
    
    /* Making moduleNumber   */
    
    TDirectory* this_module = (TDirectory*) gDirectory->Get(moduleID.c_str()); //Can be made using FindAnyObject
    //cout<<"The MODULE is "<< moduleID <<endl;
    if (!this_module) {
      //cout<<"This NEW module "<< moduleID <<" doesn't exist"<<endl;
      this_module =gDirectory ->mkdir(moduleID.c_str());
    }
    


    
    /* Making TestType   */
    //cout<<"I am making TestType Dir "<<endl;
    this_module->cd();  //make this_module the current directory 
    TDirectory* this_testType = (TDirectory*) gDirectory->Get(testType.c_str());
    //cout<<"The test Type is "<< testType <<endl;
    
    if (!this_testType) {
      //cout<<"This NEW test "<< testType <<" doesn't exist"<<endl;
      this_testType = gDirectory->mkdir(testType.c_str());
    }

    
    /* Making ScanType   */
    //cout<<"I am making scanType Dir "<<endl;
    this_testType->cd();  //make this_testType the current directory 
    TDirectory* this_variable = (TDirectory*) gDirectory->Get(variable.c_str());
    //cout<<"The Scan Type is "<< variable <<endl;
    
    
    if (!this_variable) {
      //cout<<"This NEW test "<< variable <<" doesn't exist"<<endl;
      this_variable = gDirectory->mkdir(variable.c_str());
    }
     

    

    /* Making variable   */
    //cout<<"I am making variable Dir "<<endl;
    this_variable->cd();  //make this_test the current directory
    TDirectory* this_scan = (TDirectory*) gDirectory->Get(scanID.c_str());
    //cout<<"The SCAN is "<< scanID <<endl;
    
    if (!this_scan) {
      //cout<<"This NEW scan "<< scanID <<" doesn't exist"<<endl;
      this_scan =gDirectory ->mkdir(scanID.c_str());
    }
     

    /* Saving ScanNumber as a TVector: it is saved only once, just the first time   */
    this_scan->cd();
    TObject* pers_scannumber = gDirectory->FindObjectAny(scanID.c_str());
    if (!pers_scannumber) {
      double fscanNumber = scanNumber;
      TVector vscan(1,1,fscanNumber,"END");
      vscan.Write(scanID.c_str());
    }


    //Saving Module Configuration
    TObject* pers_ModuleConfig = gDirectory->FindObjectAny(ModuleConfigID.c_str());
    if (!pers_ModuleConfig) {
      cout<<"%%%%%%% Just about to save ABCDModule %%%%%%%"<<endl;
      TObjString ModuleConfigTObjString = getModuleConfigTObjString();
      //TString tmp_string = ModuleConfigTObjString.String();
      //cout<< "Module Configuration :" << endl << tmp_string.Data()<<endl;
      ModuleConfigTObjString.Write(ModuleConfigID.c_str()); 
      cout<<"%%%%%%% ABCDModule saved %%%%%%%"<<endl;
    }
    

    /* Threshold saved as a TVector: it is saved only once, just the first time */ 
/*    TObject* pers_Threshold = gDirectory->FindObjectAny(thresholdID.c_str());  
    if (!pers_Threshold) {
      cout << "The Threshold never saved before...saving now"<<endl;
      double fthreshold = threshold;
      TVectorD vthreshold(1,1,fthreshold,"END");
      vthreshold.Write(thresholdID.c_str());
    }
*/


    /* Saving ScanPoints as a TGraph: it is saved only once, just the first time  */
    //cout << "I am Saving ScanPoints as a TGraph" << endl;
    //TObject* pers_gscanpoints = gDirectory->FindObjectAny(ScanPointsID.c_str()); 
    //if (!pers_gscanpoints) {
      //cout << "The ScanPoints never saved before...saving now"<<endl;
      gpoints->Write(ScanPointsID.c_str());
    //}
    

    
    ///* Saving ScanPoints as a TVector: it is saved only once, just the first time  */
    //cout << "I am Saving ScanPoints as  TVector's" << endl;
    //TObject* pers_vscanpoints = gDirectory->FindObjectAny(vpointsID.c_str()); 
    //if (!pers_vscanpoints) {
      //cout << "The ScanPoints never saved before...saving now"<<endl;
      vpoints->Write(vpointsID.c_str());  
    //}
    //TObject* pers_vNEvents = gDirectory->FindObjectAny(vNEventsID.c_str()); 
    //if (!pers_vNEvents) {
      //cout<< "I am here " << endl;
      vNEvents->Write(vNEventsID.c_str());  
    //}
     //TObject* pers_vNErrorEvents = gDirectory->FindObjectAny(vNErrorEventsID.c_str()); 
    //if (!pers_vNErrorEvents) {
      vNErrorEvents->Write(vNErrorEventsID.c_str());  
    //}
      


    /* Making DCS   */
    //cout<<"I am making DCS Dir"<<endl;
      /*
    this_scan->cd();  //make this_scan the current directory
    TDirectory*  this_DCS = (TDirectory*) this_scan->Get(DCSID.c_str()); 
    //NB: DCS & ROD are at the same level. 
    if (!this_DCS) {
      //cout<<"This NEW DCS  doesn't exist"<<endl;
      this_DCS = this_scan->mkdir(DCSID.c_str());
    }
    
      */
   

    /* Saving DCS data members  */
      /*
    //cout << "I am Saving DCS RawScanResult Data Members" << endl;
    this_DCS->cd();  
      */


    /* Making ROD   */ 
    //cout<<"I am making ROD Dir"<<endl;
    this_scan->cd();  //make this_scan the current directory
    TDirectory* this_ROD = (TDirectory*) this_scan->Get(RODID.c_str());
    if (!this_ROD) {
      //cout<<"This NEW ROD  doesn't exist"<<endl;
      this_ROD = this_scan->mkdir(RODID.c_str());
    }
    
 
    
    

    /* CLOSING FILE  */
    cout << "I am Closing File " << endl;
    storage_file->Close();
    delete storage_file;
    cout << "File closed " << endl;





}
