#ifndef ARCCSCANNAMES_H
#define ARCHSCANNAMES_H

#include "ArchTestNames.h"
#include "Sct/SctNames.h"
#include "SctData/ConfigurationVariable.h"
#include <string>

/**
Thsi Class provides all the names for the ScanResultarchiving
*/

using namespace SctData;
using namespace Sct;

using std::string;

class ArchScanNames: public ArchTestNames {

 private:
        //ArchScanNames();
        string moduleID;
	string variable;
	string scanID;
	string ScanPointsID;
	string cycleStr;	

 public:
	ArchScanNames();	
	ArchScanNames(const long runNumber,const string moduleName, long scanNumber, const ConfigurationVariable& sVariable, unsigned int cycle=0 );	// For ScanResult's classes

	
	inline const string getVariable() {return variable;}
	inline const string getScanID() {return scanID;}
	static inline const string getRODID() {return "ROD";}
	static inline const string getDCSID() {return "DCS";}
	static inline const string getRawID() {return "RawData";}
	static inline const string getFitID() {return "FittedData";}
	static inline const string getChannelsID() {return "Channels";}
	static inline const string getChipsID() {return "Chips";}
	static inline const string getLinksID() {return "Links";}
	static inline const string getModuleConfigID() {return "ModuleConfiguration";}

	const string getTF1_AllLinkFits(unsigned linkN); 
	const string getTF1_AllChipFits(unsigned chipN); 
	const string getTF1_AllChannelFits(unsigned channelN); 

	inline const string getScanPointsID() {string tmp_ScanPointsID = "ScanPoints" + cycleStr; return tmp_ScanPointsID;}
	inline const string getvpointsID() {string tmp_vpointsID = ScanPointsID + "_points" + cycleStr; return tmp_vpointsID;}
	inline const string getvNEventsID() {string tmp_vNEventsID = ScanPointsID + "_NEvents" + cycleStr; return tmp_vNEventsID;}
	inline const string getvNErrorEventsID() {string tmp_NErrorEventsID = ScanPointsID + "_NErrorEvents" + cycleStr; return tmp_NErrorEventsID; }

	const string getTH2Dlink0() ;
	const string getTH2Dlink1() ;
	
};


#endif //#ifndef ARCHSCANNAMES_H
