#include "ArchScanNames.h"
#include <iostream>
#include <sstream>

using namespace std;

/********************************** ArchScan Methods Definitions ************************/


/***********************  Constructor  *************** */

ArchScanNames::ArchScanNames(): ArchTestNames()  {

 scanID = "Scan?";
 variable = "ConfigurationVariable?";
 cycleStr = "";
  
}
  
  
ArchScanNames::ArchScanNames(const long runNumber, const string moduleName, const long scanNumber,const ConfigurationVariable& sVariable, unsigned int cycle): ArchTestNames(runNumber, moduleName)   {

  char tmp_scanID[40];
  sprintf(tmp_scanID,"Scan%i",scanNumber);
  scanID = tmp_scanID;
  ScanPointsID = "ScanPoints";
  if (cycle > 0) {
    cycleStr = ";";
    ostringstream oss(cycleStr);
    oss << cycle;
  } 

  variable = sVariable.getVariableName() + "Scan";
  
}



const string ArchScanNames::getTH2Dlink0() {

  string TH2Dlink0;
  TH2Dlink0 = runID + "." + scanID + "." + moduleID  + "_link0" + cycleStr;
  return TH2Dlink0;

}


const string ArchScanNames::getTH2Dlink1() {

  string TH2Dlink1;
  TH2Dlink1 = runID + "." + scanID + "." + moduleID  + "_link1" + cycleStr;
  return TH2Dlink1;

}

const string ArchScanNames::getTF1_AllLinkFits(unsigned linkN) {

  string LinkN;
  char tmp_LinkN[40];
  sprintf(tmp_LinkN,"AllLinkFits%i",linkN);
  LinkN= tmp_LinkN;
  return LinkN;


}

const string ArchScanNames::getTF1_AllChipFits(unsigned chipN) {

  string ChipN;
  char tmp_ChipN[40];
  sprintf(tmp_ChipN,"AllChipFits%i",chipN);
  ChipN= tmp_ChipN;
  return ChipN;

}

const string ArchScanNames::getTF1_AllChannelFits(unsigned channelN) {

  string ChannelN;
  char tmp_ChannelN[40];
  sprintf(tmp_ChannelN,"ChannelFits%i",channelN);
  ChannelN= tmp_ChannelN;
  return ChannelN;

}
