#ifndef ArchRawScanResult_H
#define ArchRawScanResult_H

#include <vector>
#include <is/isinfo.h>
#include "SctData/ConfigurationVariable.h"
#include "SctData/RawScanResult.h"
#include "SctData/RawScanResultIOHelper.h"
#include "Sct/SctNames.h"
#include "ArchScanResult.h"




class TFile;
class TDirectory;
class TObject;
class TSystem;
class TNamed;
class TString;
class TObjString;
class TH1;
class TH1D;
class TH2;
class TGraph;


using namespace SctData;
using namespace Sct;
using namespace boost;

class ArchRawScanResult: public ArchScanResult {
  private:
    
  //RawScanResultIOHelper Archraw;  ?????

  
  //shared_ptr<TH2D> RawData_link0;
  //shared_ptr<TH2D> RawData_link1;
  shared_ptr<const RawScanResult> theRaw;
  
  static bool inMap;
   
  ArchRawScanResult(shared_ptr<const RawScanResult> raw); 

  public:
    
    ArchRawScanResult(); 
    ~ArchRawScanResult();
   
    virtual shared_ptr<ArchScanResult> clone(shared_ptr<ScanResult> scan) {
                                   cout<<"Before downcasting"<<endl;
                                   shared_ptr<RawScanResult> raw = dynamic_pointer_cast<RawScanResult>(scan);
			           cout<<"After downcasting"<<endl;	   
                                   return shared_ptr<ArchScanResult>(new ArchRawScanResult(raw));
    }

    void SetRawScan(shared_ptr<RawScanResult>  );

    void SaveRawScan();
    void SaveRawScan(shared_ptr<RawScanResult>  );
    void Save();
    void Save(shared_ptr<RawScanResult>  );
    bool RawScanIsPersisted(); 
    bool RawScanIsPersisted(shared_ptr<RawScanResult>  );
    bool RawScanIsPersisted(long scanNumber, long runNumber, string moduleName, const ConfigurationVariable& variable, unsigned int cycle=0);
    //void DeletePersRawObj(shared_ptr<RawScanResult> & );  //!!Problem  
    //void DeletePersRawObj();                 //!!Problem
    RawScanResult* CreateRawScanResult();
    RawScanResult* CreateRawScanResult(shared_ptr<RawScanResult> );
    RawScanResult* CreateRawScanResult(long scanNumber, long runNumber, string moduleName, const ConfigurationVariable& variable, unsigned int cycle);

    
     void SaveRawComment();

};


#endif
