#ifndef ArchNPtGainTestResult_H
#define ArchNPtGainTestResult_H

#include "Sct/SctNames.h"
#include "ArchTestResult.h"
#include "SctData/NPtGainTestResult.h"
#include "TVectorD.h"
#include <vector>
#include <boost/shared_ptr.hpp>


using boost::shared_ptr;
using namespace SctData;
using namespace Sct;


class ArchNPtGainTestResult: public ArchTestResult  {
  
 private:
  
  vector<const NPtGainTestResultData*>  chipData;     //The chip fits...maybe useless 
  vector<const NPtGainTestResultData*>  channelData;  //The channel fits...maybe useless 
  unsigned int NChipData;
  unsigned int NChannelData;
  
  vector<shared_ptr<TF1> > Chipfit; 
  vector<shared_ptr<TGraph> > ChipGraph;     //Graph of the points that were fitted. 
  TVectorD* vChipGain;             //Gain at the special point chip by chip. 
  TVectorD* vChipNoise;            //Noise at the special point chip by chip. 
  TVectorD* vChipOffset;           //Offset at the special point chip by chip.
 
  vector<shared_ptr<TF1> > Channelfit; 
  vector<shared_ptr<TGraph> > ChannelGraph;     //Graph of the points that were fitted. 
  TVectorD* vChannelGain;     //Gain at the special point channel by channel. 
  TVectorD* vChannelNoise;    //Noise at the special point channel by channel. 
  TVectorD* vChannelOffset;   //Offset at the special point channel by channel.

  static bool inMap;

  ArchNPtGainTestResult(shared_ptr<NPtGainTestResult>);

 public:

  ArchNPtGainTestResult();
  virtual shared_ptr<ArchTestResult> clone(shared_ptr<TestResult> test) {
                                   shared_ptr<NPtGainTestResult> NPtest = dynamic_pointer_cast<NPtGainTestResult>(test);
                                   return shared_ptr<ArchTestResult>(new ArchNPtGainTestResult(NPtest));
  } 
  ~ArchNPtGainTestResult();
 
  void SaveNPtGainTestDataOnly();
  void Save();  
  void TestSummary(shared_ptr<NPtGainTestResult>);

};


#endif
