#include "ArchNPtGainTestResult.h"
#include "ArchivingManager.h"
#include <TFile.h>
#include <TKey.h>
#include <TDirectory.h>
#include <TSystem.h>
#include <TNamed.h>
#include <TObject.h>
#include <TObjArray.h>
#include <TString.h>
#include <TObjString.h>
#include <TVector.h>
#include <TVectorD.h>
#include <TH1.h>
#include <TH2.h>
#include <TCanvas.h>
#include <TROOT.h>
#include <is/isinfo.h>
#include <iostream>
#include <vector>
#include "SummaryWriter/SummaryWriter.h"
#include "SummaryWriter/SummaryManager.h"

#include "SctData/ResponseCurve.h"

using namespace SctData;


bool ArchNPtGainTestResult::inMap = ArchivingManager::instance().addTestArchiver("SctData::NPtGainTestResult", shared_ptr<ArchTestResult>(new ArchNPtGainTestResult()));  


/***********************  Constructor  *************** */

ArchNPtGainTestResult::ArchNPtGainTestResult(): ArchTestResult()  {

  //cout<< "I am in the ArchNPtGainTestResult Default Constructor"<< endl;
  
  
  
}
  
  
ArchNPtGainTestResult::ArchNPtGainTestResult(shared_ptr<NPtGainTestResult> NPtGtest): ArchTestResult(NPtGtest)  {

  //cout<< "I am in the ArchNPtGainTestResult Constructor"<< endl;
  
  /*--- Initialisation ---*/
  NChipData = NPtGtest->getNChipData();
  NChannelData = NPtGtest->getNChannelData();

  
  for (unsigned int i = 0; i<NChipData;i++) {
   chipData.push_back(&NPtGtest->getChipData(i));
   //cout<<"I chip = " <<i <<endl;
  }

  for (unsigned int i = 0; i<NChannelData;i++) { 
   channelData.push_back(&NPtGtest->getChannelData(i));
   // cout<<"I channel = " <<endl;
  }

  
  /* Initialisattion of Chip Data */
  vector<const NPtGainTestResultData*>::iterator icf = chipData.begin();
  while( icf != chipData.end() ) {
    Chipfit.push_back((*icf)->rc->getFunction());
    ++icf;
  } 
  

  vector<const NPtGainTestResultData*>::iterator icg = chipData.begin();
  while( icg != chipData.end() ) {
    ChipGraph.push_back((*icg)->graph);
    ++icg;
  } 

  
  //Storing Chip TVectorD's  
  double g[NChipData];
  unsigned int Ig=0;
  vector<const NPtGainTestResultData*>::iterator icgain = chipData.begin();
  while( icgain != chipData.end() ) {
    g[Ig] = (*icgain)->gain ;
    ++Ig;
    ++icgain;
  }
  vChipGain = new TVectorD(NChipData,g);

  
  double n[NChipData];
  unsigned int In=0;
  vector<const NPtGainTestResultData*>::iterator icnoise = chipData.begin();
  while( icnoise != chipData.end() ) {
    n[In] = (*icnoise)->noise ;
    ++In;
    ++icnoise;
  }
  vChipNoise = new TVectorD(NChipData,n);

  
  double o[NChipData];
  unsigned int Io=0;
  vector<const NPtGainTestResultData*>::iterator icoffset = chipData.begin();
  while( icnoise != chipData.end() ) {
    o[Io] = (*icoffset)->noise ;
    ++Io;
    ++icoffset;
  }
  vChipOffset = new TVectorD(NChipData,o);



  /* Initialisation of Channel Data */
  vector<const NPtGainTestResultData*>::iterator ichnf = channelData.begin();
  while( ichnf != channelData.end() ) {
    Channelfit.push_back((*ichnf)->rc->getFunction());
    ++ichnf;
  } 
  

  vector<const NPtGainTestResultData*>::iterator ichng = channelData.begin();
  while( ichng != channelData.end() ) {
    ChannelGraph.push_back((*ichng)->graph);
    ++ichng;
  } 

  
 
  /*Storing Channel TVectorD's  */
  double chng[NChannelData];
  unsigned int Ichng=0;
  vector<const NPtGainTestResultData*>::iterator ichngain = channelData.begin();
  while( ichngain != channelData.end() ) {
    chng[Ichng] = (*ichngain)->gain ;
    ++Ichng;
    ++ichngain;
  }
  vChannelGain = new TVectorD(NChannelData,chng);

  double chnn[NChannelData];
  unsigned int Ichnn=0;
  vector<const NPtGainTestResultData*>::iterator ichnnoise = channelData.begin();
  while( ichnnoise != channelData.end() ) {
    chnn[Ichnn] = (*ichnnoise)->noise ;
    ++Ichnn;
    ++ichnnoise;
  }
  vChannelNoise = new TVectorD(NChannelData,chnn);

  double chno[NChannelData];
  unsigned int Ichno=0;
  vector<const NPtGainTestResultData*>::iterator ichnoffset = channelData.begin();
  while( ichnnoise != channelData.end() ) {
    chno[Ichno] = (*ichnoffset)->noise ;
    ++Ichno;
    ++ichnoffset;
  }
  vChannelOffset = new TVectorD(NChannelData,chno);



  //Retrieve Test Summary from IS
  //cout <<" About to retrieve Test Summary " << endl;
  try{
    TestSummary(NPtGtest);
  } catch(...) {
    cout<<" ERROR in retrieving Test Summary from IS" <<endl;
  }
  



}







/**********************  Other Member Functions  *********************/

ArchNPtGainTestResult::~ArchNPtGainTestResult()  {
  
  //cout << "I am in the  ArchNPtGainTestResult destructor" << endl;
  

  
}





void ArchNPtGainTestResult::SaveNPtGainTestDataOnly() {

  cout<<"Saving NPtGainTestData "<<endl;
  //TO DO : Save time and date of first and last saving  
  
  string filename = names->getfilename();
  string moduleID = names->getModuleID(); 
  string testType  = names->getTestType(); 
  string runID = names->getRunID();
  string ChipDataID = names->getChipDataID();
  string vChipGainID = names->getChipGainID();
  string vChipNoiseID = names->getChipNoiseID();
  string vChipOffsetID = names->getChipOffsetID();
  string ChannelDataID = names->getChannelDataID();
  string vChannelGainID = names->getChannelGainID();
  string vChannelNoiseID = names->getChannelNoiseID();
  string vChannelOffsetID = names->getChannelOffsetID();


  /* OPENING TEST FILE  */
  //cout << "Opening file..."<<endl; 
 

  TFile *storage_file = new TFile(filename.c_str(),"update");
  //storage_file->ls();
  //cout << "The file .root succesfully open"<<endl; 

  


  /* CREATING DIRECTORIES and SAVING DATA  */
  
    
    /* Making RunNumber   */
    //cout<<"I am making RunNumber Dir"<<endl;
    //storage_file->GetListOfKeys()->Print();
    TDirectory *this_run = (TDirectory*) gDirectory->Get(runID.c_str());
    //cout<<"The RUN is "<< runID <<endl;
    
    if (!this_run) {
      //cout<<"This NEW run "<< runID <<" doesn't exist"<<endl;
      this_run = storage_file->mkdir(runID.c_str());
      //cout<<"New RunNumber Dir made "<<endl;
    }
    storage_file->GetListOfKeys()->Print();
    this_run->cd();  //make this_run the current directory
    
   
    /* Saving RunNumber as a TVector: it is saved only once, just the first time   */
    TObject* pers_runnumber = gDirectory->FindObjectAny(runID.c_str()); 
    if (!pers_runnumber) {
      double frunNumber = runNumber;
      TVector run(1,1,frunNumber, "END");
      run.Write(runID.c_str());
    }
    
    
    /* Making moduleNumber   */
    
    TDirectory* this_module = (TDirectory*) gDirectory->Get(moduleID.c_str()); //Can be made using FindAnyObject
    //cout<<"The MODULE is "<< moduleID <<endl;
    if (!this_module) {
      //cout<<"This NEW module "<< moduleID <<" doesn't exist"<<endl;
      this_module =gDirectory ->mkdir(moduleID.c_str());
    }
    
    
    /* Making TestType   */
    //cout<<"I am making TestType Dir "<<endl;
    this_module->cd();  //make this_module the current directory 
    TDirectory* this_testType = (TDirectory*) gDirectory->Get(testType.c_str());
    //cout<<"The test Type is "<< testType <<endl;
    
    if (!this_testType) {
      //cout<<"This NEW test "<< testType <<" doesn't exist"<<endl;
      this_testType = gDirectory->mkdir(testType.c_str());
    }
    this_testType->cd();

    
    /* making ChipData dir */
    TDirectory* this_ChipData = (TDirectory*) this_testType->Get(ChipDataID.c_str());
    if (!this_ChipData) {
      //cout<<"This NEW ChipData dir  doesn't exist"<<endl;
      this_ChipData = this_testType->mkdir(ChipDataID.c_str());
    }
    this_ChipData->cd();

    /* Saving ChipData */
    int chipN=0;
    for (vector<shared_ptr<TF1> >::iterator i = Chipfit.begin(); i!=Chipfit.end(); i++) {
      (*i)->Write(names->getChipFitID(chipN).c_str());
      ++chipN;
    } 
    chipN=0;
    for (vector<shared_ptr<TGraph> >::iterator i = ChipGraph.begin(); i!=ChipGraph.end(); i++) {
      (*i)->Write(names->getChipGraphID(chipN).c_str());
      ++chipN;
    }

    vChipGain->Write(vChipGainID.c_str());
    vChipNoise->Write(vChipNoiseID.c_str());
    vChipOffset->Write(vChipOffsetID.c_str()); 
   
    
    /* making ChannelData dir */
    TDirectory* this_ChannelData = (TDirectory*) this_testType->Get(ChannelDataID.c_str());
    if (!this_ChannelData) {
      //cout<<"This NEW ChannelData dir  doesn't exist"<<endl;
      this_ChannelData = this_testType->mkdir(ChannelDataID.c_str());
    }
    this_ChannelData->cd();

    /* Saving ChannelData */
    int channelN=0;
    for (vector<shared_ptr<TF1> >::iterator i = Channelfit.begin(); i!=Channelfit.end(); i++) {
      (*i)->Write(names->getChannelFitID(channelN).c_str());
      ++channelN;
    }
    channelN=0;
    for (vector<shared_ptr<TGraph> >::iterator i = ChannelGraph.begin(); i!=ChannelGraph.end(); i++) {
      (*i)->Write(names->getChannelGraphID(channelN).c_str());
       ++channelN;
    }
    //cout<<" I am here "<<endl;
    vChannelGain->Write(vChannelGainID.c_str());
    //cout<<" I am here "<<endl;
    vChannelNoise->Write(vChannelNoiseID.c_str());
    //cout<<" I am here "<<endl;
    vChannelOffset->Write(vChannelOffsetID.c_str()); 
    //cout<<" I am here "<<endl;

    //Save TestSummery (if it has been retrieved)
    if(testSummary != NULL) { 
      this_testType->cd();
      //cout<<"testSummary != NULL...";
      TObject* pers_testSummary = gDirectory->FindObjectAny(names->getTestSummaryID().c_str());
      if (!pers_testSummary) {
	testSummary->Write(names->getTestSummaryID().c_str());
	//cout<<"testSummary SAVED"<<endl;
      }
    }
   


    
    /* CLOSING FILE  */
    //cout << "I am Closing File " << endl;
    storage_file->Close();
    delete storage_file;
    //cout << "File closed " << endl;


   


}



void ArchNPtGainTestResult::Save() {

  ArchTestResult::Save();
  SaveNPtGainTestDataOnly();
  //SaveRawScans();
  //SaveFitScans();
  AddTestToIndex();

}





void ArchNPtGainTestResult::TestSummary(shared_ptr<NPtGainTestResult> NPtGtest) {
  
  ostringstream datastream;
  shared_ptr<const SctData::TestSummary::SummaryWriter> writer = 
    SctData::TestSummary::SummaryManager::instance().getWriter(NPtGtest->getClassName());
  writer->writeHeader(*(NPtGtest.get()), datastream);
  writer->write(*(NPtGtest.get()), datastream);
  string myString = datastream.str();
  //cout<< "TestSummary = " << myString;

  testSummary = new TObjString(myString.c_str());

  


  return;


}
