#ifndef ARCHMODULEDEFECTS_H
#define ARCHMODULEDEFECTS_H

#include "Sct/Streamable.h"
#include "Sct/Exception.h"
#include "Sct/LogicErrors.h"

#include <vector>
#include <boost/shared_ptr.hpp>
#include "SctData/ModuleDefect.h"
#include <TObjArray.h>

using namespace SctData;
using namespace Sct;
using boost::shared_ptr;


class ArchModuleDefects {

 protected:
       vector<shared_ptr<const ModuleDefect> > defects; 
       vector< shared_ptr<TObjArray> > defectList; 
       //TObjArray *tmp_defectList[40];
       //In each element of the vector (in eacj TObjArray) the entry no. 0 is the TObjString saying what kind of defect is (defect name)

       /*
       //@{ @name Fit Defects
       shared_ptr<TObjArray> DEAD;	       
       shared_ptr<TObjArray> STUCKON;	
       shared_ptr<TObjArray> OVER; 
       shared_ptr<TObjArray> UNDER;       
       shared_ptr<TObjArray> NOINIT;	
       shared_ptr<TObjArray> FIT_UNDER;
       shared_ptr<TObjArray> FIT_OVER;
       shared_ptr<TObjArray> SIG_UNDER;
       shared_ptr<TObjArray> SIG_OVER;
       //@} 
       //@{ @name Strobe Delay Defects
       shared_ptr<TObjArray> SD_LO;
       shared_ptr<TObjArray> SD_HI;
       shared_ptr<TObjArray> LO_GAIN; 
       shared_ptr<TObjArray> HI_GAIN; 
       shared_ptr<TObjArray> LO_OFFSET; 
       shared_ptr<TObjArray> HI_OFFSET;  
       shared_ptr<TObjArray> UNBONDED;     
       shared_ptr<TObjArray> PARTBONDED; 
       shared_ptr<TObjArray> NOISY;   
       //@}
       //@{ @name Trim Defects
       shared_ptr<TObjArray> TR_RANGE;     
       shared_ptr<TObjArray> TR_STEP;      
       shared_ptr<TObjArray> TR_OFFSET;     
       shared_ptr<TObjArray> TR_NOTRIM;    
       //@}
       //@{ Other defects
       shared_ptr<TObjArray> NO_HI;    
       shared_ptr<TObjArray> MEAN_ERROR;
       shared_ptr<TObjArray> SIG_ERROR;
       shared_ptr<TObjArray> STUCK_CELL; 
       shared_ptr<TObjArray> DEAD_CELL; 
       shared_ptr<TObjArray> TOKEN;     
       shared_ptr<TObjArray> RTOKEN;  
       shared_ptr<TObjArray> TW_HI;   
       shared_ptr<TObjArray> TW_LO;
       */

 private:

       map<string, int> defectMap;


 public:
       ArchModuleDefects(vector<shared_ptr<const ModuleDefect> > testDefects); //to be used if there are no persisted defects
       ArchModuleDefects(vector<shared_ptr<const ModuleDefect> > testDefects, vector<shared_ptr<TObjArray> > persDefects ); //to be used if there are persisted defects
       vector< shared_ptr<TObjArray> > getDefects();  
       map <string, int> getMap();
       /*Returns all kind of defects for the current test. The TObjArray contains:  defects[i]->getName()
	                                                                            defects[i]->getModuleElement().getFirst()
                                                                                    defects[i]->getModuleElement().getNChannels()
										    defects[i]->isChipDefect()
										    defects[i]->isLinkDefect()
										    defects[i]->isUnfittable()
										    defects[i]->isUnuseable()
										    defects[i]->isDodgy()
       */

       bool IsInMap(const string& defectName) throw();
       int IndexInMap(const string& defectName) throw(LogicError);
       bool addToMap(const string& curveName) throw();

       void addDefectsToList(shared_ptr<TObjArray> defectlist); 
       /* Gets the TObjArray defetclist and appends the deftecs of the current test */
      
};


#endif
