#include "Service.h"
#include "ArchivingWorkerGroup.h"
#include "archiving/ArchRawScanResult.h"
#include "archiving/ArchFitScanResult.h"

#include "Sct/SctNames.h"
#include "is/isinfo.h" 
#include "Sct/IS/IOManagerIS.h"
#include "SctData/TestResult.h"
#include "SctData/ScanResult.h"
#include "SctData/RawScanResult.h"
#include "SctData/FitScanResult.h"
#include <string>

using namespace Sct;
using namespace SctData;
using namespace Sct::IS;
using namespace boost;

namespace SctArchivingService {

ArchivingService::ArchivingService() : IPCObject(Archiving_C_ArchivingService_interfaceName, &server()) 
    , infoReceiver(new ISInfoReceiver(SctNames::getPartition())), group(new ArchivingWorkerGroup()) {    
}


IPCServer& ArchivingService::server() {
    static IPCServer* server = new IPCServer(Archiving_C_ArchivingService_serverName, SctNames::getPartition());
    return *server;
}

void ArchivingService::run() {
    cout<<" I am in ArchivingService::run() " <<endl;
    group->go(1);
    
    infoReceiver->subscribe("TestData", ".*TestResult.*", testDataISCallback,this);
    infoReceiver->subscribe(SctNames::getControlDataName().c_str(), ".*TestData.*", controlDataISCallback, this);
    infoReceiver->subscribe(SctNames::getFittedDataName().c_str(),  ".*FitScanResult.*", fitScanResultISCallback, this);
    infoReceiver->subscribe(SctNames::getEventDataName().c_str(), ".*RawScanResult.*", rawScanResultISCallback, this);
}


void ArchivingService::testDataISCallback(ISCallbackInfo * iscTest) {
    cout<<" I am in ArchivingService::testDataISCallback " <<endl;
    ArchivingService* aTest = static_cast<ArchivingService*>(iscTest->parameter());
    //cout<< " !!!! IS Object Name = " << isc->type().name()<<endl;
    aTest->archive(iscTest);
    
    
    /*
    if (isc->reason() != ISInfoCreated && isc->reason() != ISInfoUpdated ) return;
    shared_ptr<Serializable> ob = IOManagerIS::instance().read(*isc);
    cout << "!!!!!!!!! CLASS NAME ==== " << ob->getClassName() <<endl;
    if (ob == 0) {
        cerr << "Failed to get object from IS" << endl;
        return;
    }

    instance().group->push(ob);
    cout << "Bye bye Test" <<endl;
    */

}

void ArchivingService::controlDataISCallback(ISCallbackInfo * isc) {
    try {
        shared_ptr<TestData> testdata( new TestData() );
        isc->value(*testdata);

        if (isc->reason() == ISInfoCreated ) {
	  cout << "Callback for new controldata object "<<endl;

	  if (instance().group->findTest(*testdata).get() == 0 ) {
	    cout << "Listener adding test" << endl;
	    instance().group->addTest(testdata);
	    cout << "Listener added test" << endl;
	    //AT !!!!!! Just for now !!!!!!
	    
	  
	  } 
	  else {
	    throw Sct::InvalidArgumentError(string("AnalysisService::TestCallback Test already exists: ")+string(isc->name()), __FILE__, __LINE__);
	  }
	  
	  
	}
        
    } catch (Sct::Throwable& e) {
      e.sendToMrs(MRS_ERROR);
    }
}

void ArchivingService::rawScanResultISCallback(ISCallbackInfo * iscRaw) {
    cout<<" I am in ArchivingService::rawScanResultISCallback " <<endl;
     
    ArchivingService* aRaw = static_cast<ArchivingService*>(iscRaw->parameter());
    //cout<< " !!!! IS Object Name = " << isc->type().name()<<endl;
    aRaw->archive(iscRaw);
    
    


}

void ArchivingService::fitScanResultISCallback(ISCallbackInfo * iscFit) {
    cout<<" I am in ArchivingService::fitScanResultISCallback " <<endl;
     
    ArchivingService* aFit = static_cast<ArchivingService*>(iscFit->parameter());
    //cout<< " !!!! IS Object Name = " << isc->type().name()<<endl;
    aFit->archive(iscFit);

    
	   

}

void ArchivingService::archive(ISCallbackInfo * isc) {
  //cout<<" I am in ArchivingService::archive " <<endl;
    
    if (isc->reason() != ISInfoCreated && isc->reason() != ISInfoUpdated ) return;

   
    
    

    shared_ptr<Serializable> ob = IOManagerIS::instance().read(*isc);
    cout << "!!!!!!!!! CLASS NAME ==== " << ob->getClassName() <<endl;
    if (ob == 0) {
        cerr << "Failed to get object from IS" << endl;
        return;
    }

    group->push(ob);
    cout << "PUSHED" <<endl;
    
}




ilu_T_CString ArchivingService::ping (ArchivingStatus *_status) {
    char* msg = new char[28];
    strcpy(msg, "Hello from ArchivingService");
    return msg;
}


ArchivingService& ArchivingService::instance() {
    if (!service)
        return initialize();
    return *service;
}

ArchivingService& ArchivingService::initialize() {
    if (!service) {
        service = new ArchivingService();
    }
    return *service;
}

ArchivingService* ArchivingService::service = 0;


}
