#ifndef ARCHIVINGWORKERGROUP_H
#define ARCHIVINGWORKERGROUP_H

#include "SctService/WorkerGroup.h"
#include <boost/shared_ptr.hpp>
#include "Sct/Serializable.h"
#include "CalibrationController/IS/TestData.h"
#include "archiving/ArchRawScanResult.h"
#include "archiving/ArchFitScanResult.h"

using boost::shared_ptr;
using Sct::Serializable;
using SctService::WorkerGroup;

namespace SctArchivingService {
    
/**
  This class is the handles the ArchivingService's worker threads.
  They operate on de-serialized objects from IS.  ATM this is most
  efficient as TestData is stored directly in IS.  Should this switch 
  to a file based storage at some point, then it would be better to just
  use names (strings).
  */
class ArchivingWorkerGroup : public WorkerGroup<shared_ptr<Serializable> > {
 
 public:
  
  class TestAlgs;	
  /**
     Add a new TestData to the list of tests
     @param testdata the test to add.
     @note one must lock the internals whilst doing the adding
  */
  void addTest(shared_ptr<const TestData> testdata);
  /**
     Look for a TestAlgs which matches a given run number and scan number
     @param runno the run number
     @param scanno the scan number
     @return TestAlgs for this test if these exist.
     @note one must lock the internals whilst doing the finding.
  */
  shared_ptr<TestAlgs> findTest(const unsigned long runno, const unsigned long scanno) const throw();
  /**
     Look for a TestAlgs which matches a given run number and scan number
     @param testdata the TestData we want to find.
     @return TestAlgs for this test if these exist.
     @note one must lock the internals whilst doing the finding.
  */
  shared_ptr<TestAlgs> findTest(const TestData& testdata)const throw() ;

  //void RawScanWork(shared_ptr<const RawScanResult> raw) throw();
  //void FitScanWork(shared_ptr<const FitScanResult> fit) throw();

  shared_ptr<ArchScanResult>  getScanFromMap(shared_ptr<Serializable> ob);
  
  /*--------internal class-----------------------------------------------------------*/

	/** keeps a test and its results together. Associates these with a lockable mutex.*/
	class TestAlgs {
	public:
	    /** constructor takes a Test object. Also works out what sort of test it is and  */
	    TestAlgs(shared_ptr<const TestData> testdata) : m_testdata(testdata) {} 
	    /** Get the TestData object */
	    const TestData& getTest() const {return *m_testdata;}
	    
	    /**
	       Destructor gets the lock before destroying the internals.
	     */
	    ~TestAlgs();
	    /**
	       Print the contents of this testalgs
	    */
	    ostream& printStatus(ostream& os) const throw();
	private:
	    shared_ptr<const TestData> m_testdata;               ///< the TestData itself.

	    //AT mutable boost::recursive_mutex m_access;                 ///< lock results
	};

 private:
	
	virtual void work(shared_ptr<Serializable>) throw();
	
	list<shared_ptr<TestAlgs> > m_tests; ///< List of the tests, and associated analysis algorithms.
	mutable boost::recursive_mutex m_tests_access; ///< access to the list of algorithms
	mutable boost::recursive_mutex m_file_access; ///< access to the ROOT file.

  
	
	
};
    
}

#endif //ARCHIVINGWORKERGROUP_H
