#include "ArchivingWorkerGroup.h"
#include "archiving/ArchRawScanResult.h"
#include "archiving/ArchFitScanResult.h"
#include "archiving/ArchNPtGainTestResult.h"
#include "archiving/ArchNoiseOccupancyTestResult.h"
#include "archiving/ArchStrobeDelayTestResult.h"
#include "archiving/ArchTrimRangeTestResult.h"
#include "archiving/ArchTimeWalkTestResult.h"
#include "archiving/ArchPipelineTestResult.h"
#include "archiving/ArchFullBypassTestResult.h"
#include "archiving/ArchNMaskTestResult.h"
#include "archiving/ArchivingManager.h"



#include "Sct/LogicErrors.h"

using namespace Sct;
using namespace SctData;
using namespace boost;

namespace SctArchivingService {
    
void ArchivingWorkerGroup::work(shared_ptr<Serializable> ob) throw() {
  try {
    if (!ob) throw InvalidArgumentError("Failed to get object from IS", __FILE__, __LINE__);
    
    
    /** Save Scans  */
    
    
      if(ob->getClassName() == "SctData::FitScanResult" || ob->getClassName() == "SctData::RawScanResult") {
	
	
	
	{
	  boost::recursive_mutex::scoped_lock lock(m_file_access);  
	  shared_ptr<ArchScanResult> myScanArchiving = ArchivingManager::instance().getScanFromMap(ob);
	  shared_ptr<ScanResult> scan = dynamic_pointer_cast<ScanResult>(ob);
	  //cout<<"Before Cloning"<<endl;
	  shared_ptr<ArchScanResult> cloned_scan = myScanArchiving->clone(scan);
	  //cout<<"After Cloning"<<endl;
	  
	  unsigned long runno = scan->getHeader().getRunNumber();
	  unsigned long scanno = scan->getHeader().getScanNumber();
	  
	
	  while (findTest(runno, scanno).get() == 0  ) {
	    //sleeping: waiting to get Test in the List
	    sleep(1);
	    cout<<"RawScanWork: I am sleeping"<<endl;
	  }
	  
	
	  cout<< "(Work) About to save ScanResult... " << endl;
	  cloned_scan->SetUNIXDir();
	  string testName = findTest( runno, scanno )->getTest().testName;
	  cout <<"TestName = " << testName<<endl;
	  cloned_scan->SetTestType(testName);
	  
	  cloned_scan->Save();
	}
 
	cout<< "ScanResult Correctly Saved (work) " << endl;
	return;
      }
      
    


      /** Save Tests  */
      
      if(ob->getClassName() == "SctData::FullBypassTestResult" 
	 || ob->getClassName() == "SctData::NMaskTestResult"
	 || ob->getClassName() == "SctData::NoiseOccupancyTestResult" 
	 || ob->getClassName() == "SctData::NPtGainTestResult" 
	 || ob->getClassName() == "SctData::PipelineTestResult"
	 || ob->getClassName() == "SctData::StrobeDelayTestResult"
	 || ob->getClassName() == "SctData::TimeWalkTestResult"
	 || ob->getClassName() == "SctData::TrimRangeTestResult") {
	
	{
	  boost::recursive_mutex::scoped_lock lock(m_file_access); 
	  
	  shared_ptr<ArchTestResult> myTestArchiving = ArchivingManager::instance().getTestFromMap(ob);
	  shared_ptr<TestResult> test = dynamic_pointer_cast<TestResult>(ob);
	  //cout<<"Before Cloning"<<endl;
	  shared_ptr<ArchTestResult> cloned_test = myTestArchiving->clone(test);
	  //cout<<"After Cloning"<<endl;
	  
	  cout<< "(Work) About to save TestResult... " << endl;
	  cloned_test->SetUNIXDir();
	  
	
	  cloned_test->Save();
	}
	cout<< "TestResult Correctly Saved (work) " << endl;
	return;
      }
      
      
      
    
    
	/*
	//RawScans:
	{
	  shared_ptr<RawScanResult> raw = dynamic_pointer_cast<RawScanResult>(ob);
	  if(raw) {
	    
	    cout<< "(Work) About to save RawScanResult... " << endl;
	    {
	      boost::recursive_mutex::scoped_lock lock(m_file_access);   
	      ArchivingWorkerGroup::RawScanWork(raw); 
	    }
	    cout<< "RawScanResult Correctly Saved (work) " << endl;
	    return;
	    
	  }
	  
	}


	//FitScans:
	{
	  shared_ptr<FitScanResult> fit = dynamic_pointer_cast<FitScanResult>(ob);
	  if(fit) {
	    cout<< "(Work) About to save FitScanResult... " << endl;
	    {
	      boost::recursive_mutex::scoped_lock lock(m_file_access);
	      ArchivingWorkerGroup::FitScanWork(fit);
	    }	 
	    cout<< "FitScanResult Correctly Saved (work) " << endl;
	    return;
	  }
	}
	 */
	
	/* OLD
	   shared_ptr<NoiseOccupancyTestResult> NOResult = dynamic_pointer_cast<NoiseOccupancyTestResult>(ob); 
	   if(NOResult) {      
	   cout<<" The Test Obj is NoiseOccupancyTestResult "<<endl;
	   {
	   boost::recursive_mutex::scoped_lock lock(m_file_access);      
	   ArchNoiseOccupancyTestResult archnotest(NOResult);
	   archnotest.SetUNIXDir();
	   archnotest.SaveTestDataOnly();
	   archnotest.SaveNOTestDataOnly();
	   archnotest.AddTestToIndex();
	   }
	   cout<< "Noise Occupancy Test Correctly Saved " << endl;
	   return;
	   }
	   
	   shared_ptr<NPtGainTestResult> NPtResult = dynamic_pointer_cast<NPtGainTestResult>(ob);
	   if(NPtResult) {
	   cout<<" The Test Obj is NPtGainTestResult "<<endl;
	   {
	   boost::recursive_mutex::scoped_lock lock(m_file_access);      
	   ArchNPtGainTestResult archNPtGtest(NPtResult);
	   archNPtGtest.SetUNIXDir();
	   archNPtGtest.SaveTestDataOnly();
	   archNPtGtest.SaveNPtGainTestDataOnly();
	   archNPtGtest.AddTestToIndex();
	   }
	   cout<< "NPt Gain Test Correctly Saved " << endl;
	   return;
	   }
	   
	   shared_ptr<StrobeDelayTestResult> SDResult = dynamic_pointer_cast<StrobeDelayTestResult>(ob);
	   if(SDResult) {
	   cout<<" The Test Obj is StrobeDelayTestResult "<<endl; 
	   {
	      boost::recursive_mutex::scoped_lock lock(m_file_access);     
	      ArchStrobeDelayTestResult archSDtest(SDResult);
	      archSDtest.SetUNIXDir();
	      archSDtest.SaveTestDataOnly();
	      archSDtest.SaveStrobeDelayTestDataOnly();
	      archSDtest.AddTestToIndex();
	    }
	    cout<< "Strobe Delay Test Correctly Saved " << endl;
	    return;
	}
	
	shared_ptr<TrimRangeTestResult> TRResult = dynamic_pointer_cast<TrimRangeTestResult>(ob);
	if(TRResult) {
	    cout<<" The Test Obj is TrimRangeTestResult "<<endl;  
	    {
	      boost::recursive_mutex::scoped_lock lock(m_file_access);    
	      ArchTrimRangeTestResult archTRtest(TRResult);
	      archTRtest.SetUNIXDir();
	      archTRtest.SaveTestDataOnly();
	      archTRtest.SaveTrimRangeTestDataOnly();
	      archTRtest.AddTestToIndex();
	    }
	    cout<< "Trim Range Test Correctly Saved " << endl;
	    return;
	}


	shared_ptr<TimeWalkTestResult> TWResult = dynamic_pointer_cast<TimeWalkTestResult>(ob);
	if(TWResult) {
	    cout<<" The Test Obj is TimeWalkTestResult "<<endl; 
	    {
	      boost::recursive_mutex::scoped_lock lock(m_file_access);     
	      ArchTimeWalkTestResult archTWtest(TWResult);
	      archTWtest.SetUNIXDir();
	      archTWtest.SaveTestDataOnly();
	      archTWtest.SaveTimeWalkTestDataOnly();
	      archTWtest.AddTestToIndex();
	    }  
	    cout<< "TimeWalk Test Correctly Saved " << endl;
	    return;
	}

	shared_ptr<FullBypassTestResult> FBResult = dynamic_pointer_cast<FullBypassTestResult>(ob);
	if(FBResult) {
	    cout<<" The Test Obj is FullBypassTestResult "<<endl;  
	    {
	      boost::recursive_mutex::scoped_lock lock(m_file_access);    
	      ArchFullBypassTestResult archFBtest(FBResult);
	      archFBtest.SetUNIXDir();
	      archFBtest.SaveTestDataOnly();
	      archFBtest.SaveFullBypassTestDataOnly();
	      archFBtest.AddTestToIndex();   
	    }
	    cout<< "FullBypass Test Correctly Saved " << endl;
	    return;
	}


	shared_ptr<PipelineTestResult> PResult = dynamic_pointer_cast<PipelineTestResult>(ob);
	if(PResult) {
	    cout<<" The Test Obj is PipelineTestResult "<<endl; 
	    {
	      boost::recursive_mutex::scoped_lock lock(m_file_access);     
	      ArchPipelineTestResult archPtest(PResult);
	      archPtest.SetUNIXDir();
	      archPtest.SaveTestDataOnly();
	      archPtest.SavePipelineTestDataOnly();
	      archPtest.AddTestToIndex();
	    } 
	    cout<< "Pipeline Test Correctly Saved " << endl;
	    return;
	}
	

	shared_ptr<NMaskTestResult> NMResult = dynamic_pointer_cast<NMaskTestResult>(ob);
	if(NMResult) {
	    cout<<" The Test Obj is NMaskTestResult "<<endl; 
	    {
	      boost::recursive_mutex::scoped_lock lock(m_file_access);     
	      ArchNMaskTestResult archNMtest(NMResult);
	      archNMtest.SetUNIXDir();
	      archNMtest.SaveTestDataOnly();
	      archNMtest.SaveNMaskTestDataOnly();
	      archNMtest.AddTestToIndex();
	    }  
	    cout<< "NMask Test Correctly Saved " << endl;
	    return;
	}
	*/

      throw InvalidArgumentError("The object on IS is an unknown Test type: " + ob->getClassName(), __FILE__, __LINE__);
  } catch(Throwable& e) {
    e.sendToMrs(MRS_ERROR);
  }
  

  



}    




shared_ptr<ArchivingWorkerGroup::TestAlgs> ArchivingWorkerGroup::findTest(const TestData& testdata) const throw() {
    return findTest(testdata.runNumber, testdata.startScanNumber);
}


shared_ptr<ArchivingWorkerGroup::TestAlgs> ArchivingWorkerGroup::findTest(const unsigned long runno, const unsigned long scanno) const throw() {
    //AT boost::recursive_mutex::scoped_lock lock(m_tests_access);
    shared_ptr<ArchivingWorkerGroup::TestAlgs> talgs;
    for (list<shared_ptr<TestAlgs> >::const_iterator it = m_tests.begin();
            it != m_tests.end();
            ++it ) {
        const TestData& td=(*it)->getTest();
        if ( runno == td.runNumber &&
                scanno >= td.startScanNumber &&
                scanno < td.startScanNumber + td.nScans) {
            talgs=*it;
            cout << "found test for run " << runno<< ", scan " << scanno << endl;
        }
    }
    return talgs;
}



void ArchivingWorkerGroup::addTest(shared_ptr<const TestData> testdata) {
  boost::recursive_mutex::scoped_lock lock(m_tests_access);
  m_tests.push_back(shared_ptr<TestAlgs>(new TestAlgs(testdata) ) );

   
}



  /*
void ArchivingWorkerGroup::RawScanWork(shared_ptr<const RawScanResult> raw) throw() {
	  cout<< "RawScanResult created"<<endl;
	  
	   

	    unsigned long runno = raw->getHeader().getRunNumber();
	    unsigned long scanno = raw->getHeader().getScanNumber();
	    
	    while (findTest(runno, scanno).get() == 0  ) {
	      //sleeping: waiting to get Test in the List
	      sleep(1);
	      cout<<"RawScanWork: I am sleeping"<<endl;
	    }
	    
	    
	    
	    //archive RawScan: 
	    cout << "Archiving  RawScanResult: " << endl;
	    
	      ArchRawScanResult archraw(raw);
	      archraw.SetUNIXDir(); 
	      string testName = findTest( runno, scanno )->getTest().testName;
	      //cout <<"TestName = " << testName<<endl;
	      archraw.SetTestType(testName);
	      cout<<"I am here" <<endl;
	      //{
	      //boost::recursive_mutex::scoped_lock lock(m_file_access);   
	      //AT archraw.SaveRawScan();
	      archraw.Save();
	      //}
	  
	  cout<< "RawScanResult Correctly Saved " << endl;
	  return;
	 
	 
}



void ArchivingWorkerGroup::FitScanWork(shared_ptr<const FitScanResult> fit) throw() {
          cout<< "FitScanResult created"<<endl;

	  unsigned long runno = fit->getHeader().getRunNumber();
	  unsigned long scanno = fit->getHeader().getScanNumber();
	  while (findTest( runno, scanno ).get() == 0  ) {
	    //sleep:  waiting to get Test in the List
	    sleep(1);
	    cout<<"FitScanWork: I am sleeping"<<endl;

	  }
	    //archive FitScan:
	    cout << "Archiving  FitScanResult: " << endl;
	    ArchFitScanResult archfit(fit);
	    archfit.SetUNIXDir(); 
	    string testName = findTest(runno, scanno)->getTest().testName;
	    //cout <<"TestName = " << testName<<endl;
	    archfit.SetTestType(testName);
	    //{
	    //boost::recursive_mutex::scoped_lock lock(m_file_access);
	    //AT archfit.SaveFitScan();
	    archfit.Save();
	      //}
	    cout<< "FitScanResult Correctly Saved " << endl;
	    return;
	 
	  
	  
}
  */


//TestAlgs methods

ArchivingWorkerGroup::TestAlgs::~TestAlgs() {
  //AT boost::recursive_mutex::scoped_lock lock(m_access);

    //We need to explicitly delete the list here so the lock is in force
    //Note that this just removes the pointer..actual deletion will only occur
    //if noone else has grabbed a reference to the object
   //AT  m_algorithms.clear();
}

ostream& ArchivingWorkerGroup::TestAlgs::printStatus(ostream& os) const throw() {
    //AT boost::recursive_mutex::scoped_lock lock(m_access);
    os << "   Test name: "  << getTest().testName 
       << ", run number = " << getTest().runNumber
       << ", first scan number = " << getTest().startScanNumber
       << ", nscans = " << getTest().nScans 
       <<  endl;

    
    return os;
}








}
