import Sct.IS.*;
import Sct.*;
import SctData.*;
import hep.aida.*;
import hep.aida.ref.histogram.*;

public class CheckRaw {
    public int runNumber;
    public int scanNumber;
    public String moduleName;
    public byte groupID;
    public float chip5CalFactor;
    public byte chip4Target;
    public byte chip11Threshold;
    public byte chip0Chan0Trim;
    public int nPoints;
    public double point0;
    public double bin00;
    public double bin4949;
    public int exitCode = 0;
    RawScanResult r;
    
    public static void main(String[] args) {
	CheckRaw cr = new CheckRaw();
	cr.runNumber = 1000;
	cr.scanNumber = 100;
	cr.moduleName = "TestSubmit";
	cr.groupID = 4;
	cr.chip5CalFactor = 5.3f;
	cr.chip4Target = 20;
	cr.chip11Threshold = 123;
	cr.chip0Chan0Trim = 15;
	cr.nPoints = 64;
	cr.point0 = 13.5;
	cr.bin00 = 1000;
	cr.bin4949 = 2000;
	
	try {
	    cr.compare("EventData.SctData::RawScanResult.1000.100.TestSubmit");
	} catch (Exception e) {
	    e.printStackTrace();
	    System.exit(2);
	}
	
	if (args.length > 0) cr.plot();
	else System.exit(cr.exitCode);
    }
  
    
    public void compare(String name) throws java.io.IOException{
	Serializable s = ObjectManagerIS.getInstance().readObject(name);
	System.out.println(s.getClassName());
	r = (RawScanResult)s;
	
	if (r.getHeader().getRunNumber() != runNumber) {
	    System.err.println("RunNumber not equal. Got: " + r.getHeader().getRunNumber() + " expected: " + runNumber);
	    ++exitCode;
	}
	
	if (r.getHeader().getScanNumber() != scanNumber) {
	    System.err.println("ScanNumber not equal. Got: " + r.getHeader().getScanNumber() + " expected: " + scanNumber);
	    ++exitCode;
	}

	if (!r.getHeader().getModuleName().equals(moduleName)) {
	    System.err.println("ModuleName not equal. Got: " + r.getHeader().getModuleName() + " expected: " + moduleName);
	    ++exitCode;
	}

	if (r.getConfiguration().getGroupId() != groupID) {
	    System.err.println("GroupId not equal. Got: " + r.getConfiguration().getGroupId() + " expected: " + groupID);
	    ++exitCode;    
	}
	if (r.getConfiguration().getChipConfiguration(5).getCalFactor() != chip5CalFactor) {
	    System.err.println("chip5CalFactor not equal. Got: " + r.getConfiguration().getChipConfiguration(5).getCalFactor() + " expected: " + chip5CalFactor);
	    ++exitCode;    
	}
	if (r.getConfiguration().getChipConfiguration(4).getTrimTarget() != chip4Target) {
	    System.err.println("chip4Target not equal. Got: " + r.getConfiguration().getChipConfiguration(4).getTrimTarget() + " expected: " + chip4Target);
	    ++exitCode;    
	}
	if (r.getConfiguration().getChipConfiguration(11).getThreshold() != chip11Threshold) {
	    System.err.println("chip11Threshold not equal. Got: " + r.getConfiguration().getChipConfiguration(11).getThreshold() + " expected: " + chip11Threshold);
	    ++exitCode;    
	}	
	if (r.getConfiguration().getChipConfiguration(0).getTrim(0) != chip0Chan0Trim) {
	    System.err.println("chip0Chan0Trim not equal. Got: " + r.getConfiguration().getChipConfiguration(0).getTrim(0) + " expected: " + chip0Chan0Trim);
	    ++exitCode;    
	}
	
	if (r.getPoints().getNPoints() != nPoints) {
	    System.err.println("nPoints not equal. Got: " + r.getPoints().getNPoints() + " expected: " + nPoints);
	    ++exitCode;        
	}
	if (r.getPoints().getPoint(0) != point0) {
	    System.err.println("point0 not equal. Got: " + r.getPoints().getPoint(0) + " expected: " + point0);
	    ++exitCode;        
	}
	
	if (r.getData().binHeight(0, 0) != bin00) {
	    System.err.println("bin00 not equal. Got: " + r.getData().binHeight(0, 0) + " expected: " + bin00);
	    ++exitCode; 
	}
	if (r.getData().binHeight(768+49, 49) != bin4949) {
	    System.err.println("bin4949 not equal. Got: " + r.getData().binHeight(768+49, 49) + " expected: " + bin4949);
	    ++exitCode; 
	}
    }
    
    public void plot() {
	IAnalysisFactory af = IAnalysisFactory.create();
	ITree tree = af.createTreeFactory().create();            

	// Create an IPlotter 
	IPlotter iplotter = af.createPlotterFactory().create();  
	iplotter.show();
	iplotter.createRegion().plot(r.getData());
    }
}

