#include "SctDaqRootFileExt.h"
#include "../SCTTestAPI/Exceptions.h"
#include <sstream>
#include <TH1.h>
#include <TFile.h>

using namespace std;
using namespace SctTest;

SctDaqRootFileExt::SctDaqRootFileExt(string fileName) : SctDaqRootFile(fileName) {
}

auto_ptr<TH1> SctDaqRootFileExt::getSigmaGraph(unsigned int link, unsigned int cycle) {
    ostringstream oss;
    oss << "h_sigma" << link << ";" << cycle;
    auto_ptr<TH1> hist ((TH1*)file.Get(oss.str().c_str()));
    if (!hist.get()) throw DataNotValidException("Couldn't get histogram: " + oss.str(), __FILE__, __LINE__);
    return hist;
}

auto_ptr<TH1> SctDaqRootFileExt::getMeanGraph(unsigned int link, unsigned int cycle) {
    ostringstream oss;
    oss << "h_mean" << link << ";" << cycle;
    auto_ptr<TH1> hist ((TH1*)file.Get(oss.str().c_str()));
    if (!hist.get()) throw DataNotValidException("Couldn't get histogram: " + oss.str(), __FILE__, __LINE__);
    return hist;
}

auto_ptr<TH1> SctDaqRootFileExt::getChiSqGraph(unsigned int link, unsigned int cycle) {
    ostringstream oss;
    oss << "h_chisq" << link << ";" << cycle;
    auto_ptr<TH1> hist ((TH1*)file.Get(oss.str().c_str()));
    if (!hist.get()) throw DataNotValidException("Couldn't get histogram: " + oss.str(), __FILE__, __LINE__);
    return hist;
}
