#include "SummaryManager.h"
#include "TrimRangeSummaryWriter.h"

#include "SctData/TrimRangeTestResult.h"
#include "SctData/ResponseCurve.h"
#include "SctData/Stat.h"

#include <iomanip>
#include <TF1.h>

namespace SctData {
    namespace TestSummary{
	using namespace std;

	void TrimRangeSummaryWriter::write(const TestResult& t, ostream& out) const throw(Sct::IoError, Sct::LogicError)
	{
	    const TrimRangeTestResult& result  = dynamic_cast<const TrimRangeTestResult&>(t);
	    
	    out << "#\n%Trim\n#\n"
		<< "TRIM   CHARGE   TYPE   ALGORITHM" << endl;
	    out << "     " << setw(6) << result.charge 
		<< " " << setw(6) << result.type 
		<< " " << setw(6) << result.algorithm << endl;
	    out << "#\n#\n"
		<< "    range     target   ntrim     vt50    vt50rms    tr_off   off_rms  tr_step   step_rms"<<endl;
	    for (unsigned ichip=0; ichip<nChipModule; ++ichip){
		out << "#"<<getChipName(ichip) << endl;
		out << setw(6) << "  " << result.chipTrim[ichip]->range                              // range
		    << setw(6) << "  " << result.chipTrim[ichip]->target                             // target
		    << setw(6) << "  " << result.chipTrim[ichip]->channelTrim.n()                    // ntrim
		    << setw(6) << "  " << result.chipTrim[ichip]->channelTrim.mean().vthr            // vt50 mean
		    << setw(6) << "  " << sqrt ( result.chipTrim[ichip]->channelTrim.var().vthr )    // vt50 rms
		    << setw(6) << "  " << result.chipTrimData[ichip]->getOffsets().mean()            // mean offset
		    << setw(6) << "  " << sqrt ( result.chipTrimData[ichip]->getOffsets().var() )    // rms offset
		    << setw(6) << "  " << result.chipTrimData[ichip]->getSteps().mean()              // mean step
		    << setw(6) << "  " << sqrt ( result.chipTrimData[ichip]->getSteps().var() )      // rms step
		    << endl;
	    }

	    SummaryWriter::write(t.getDefects(), out);
	}

	//------------------------------------------------------

	bool TrimRangeSummaryWriter::inMap = SummaryManager::instance().addWriter("SctData::TrimRangeTestResult", shared_ptr<SummaryWriter>(new TrimRangeSummaryWriter()));
    }
}
