// For gcc296 floor
#include <cmath>

#include "SummaryManager.h"
#include "RxThresholdSummaryWriter.h"
#include "SctData/RxThresholdTestResult.h"

namespace SctData {
    namespace TestSummary{
	using namespace std;

	void RxThresholdSummaryWriter::write(const TestResult& t, ostream& out) const throw(Sct::IoError, Sct::LogicError)
	{
	    const RxThresholdTestResult& result  = dynamic_cast<const RxThresholdTestResult&>(t);

	    out << "#\n%RxThreshold\n#\n#Thresholds\n";
	    for (unsigned ilink=0; ilink<nLinkModule; ++ilink){
		out << static_cast<int>(floor( result.getOptimum(ilink) + 0.5)) << " ";
	    }
	    out << "\n#" << endl;

	    SummaryWriter::write(result.getDefects(), out);
	    
	}

	bool RxThresholdSummaryWriter::inMap = SummaryManager::instance().addWriter("SctData::RxThresholdTestResult", shared_ptr<SummaryWriter>(new RxThresholdSummaryWriter()));
    }
}
