#include "PipelineSummaryWriter.h"
#include "SctData/TestResult.h"
#include "SummaryManager.h"

namespace SctData {
    namespace TestSummary{
	void PipelineSummaryWriter::write(const TestResult& t, std::ostream& out) const throw(Sct::IoError, Sct::LogicError)
	{
	    out << "#\n%PipelineTest\n#\n";
	    out << "#NGOOD\n#";
	    
	    for (unsigned ilink=0; ilink<2; ++ilink){
		
		for (unsigned ichip=0; ichip<nChipLink; ++ichip){
		    out << getChipName(ichip+ilink*nChipLink) << " ";
		}
		out << endl;
		for (unsigned ichip=0; ichip<nChipLink; ++ichip){
		    out << nChannelChip - t.getDefects().getDefectsAffectingElement(ModuleElement::Chip(ichip+ilink*nChipLink))->getAllDefects().size() << " ";
		}
		out << "\n#";
	    }
	    out << endl;

	    SummaryWriter::write(t.getDefects(), out);
	}

	bool PipelineSummaryWriter::inMap = SummaryManager::instance().addWriter("SctData::PipelineTestResult", shared_ptr<SummaryWriter>(new PipelineSummaryWriter()));
    }
}
